/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vafer.jdependency.Clazz;

public final class ClazzpathUnit {
    private final String id;
    private final Map<String, Clazz> clazzes;
    private final Map<String, Clazz> dependencies;

    ClazzpathUnit(String pId, Map pClazzes, Map pDependencies) {
        this.id = pId;
        this.clazzes = pClazzes;
        this.dependencies = pDependencies;
    }

    public Set getClazzes() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.clazzes.values()) {
            all.add(clazz);
        }
        return all;
    }

    public Clazz getClazz(String pClazzName) {
        return this.clazzes.get(pClazzName);
    }

    public Set getDependencies() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        for (Clazz clazz : this.dependencies.values()) {
            all.add(clazz);
        }
        return all;
    }

    public Set getTransitiveDependencies() {
        HashSet all = new HashSet();
        for (Clazz clazz : this.clazzes.values()) {
            clazz.findTransitiveDependencies(all);
        }
        return all;
    }

    public String toString() {
        return this.id;
    }
}

