/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.sun;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.AbstractLdLinker;
import java.io.File;
import java.util.Vector;

public final class ForteCCLinker
extends AbstractLdLinker {
    private static final String[] discardFiles = new String[]{".dll", ".so", ".sl"};
    private static final String[] objFiles = new String[]{".o", ".a", ".lib"};
    private static final ForteCCLinker arLinker = new ForteCCLinker("CC", objFiles, discardFiles, "lib", ".a");
    private static final ForteCCLinker dllLinker = new ForteCCLinker("CC", objFiles, discardFiles, "lib", ".so");
    private static final ForteCCLinker instance = new ForteCCLinker("CC", objFiles, discardFiles, "", "");
    private File[] libDirs;

    public static ForteCCLinker getInstance() {
        return instance;
    }

    private ForteCCLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix) {
        super(command, "-V", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, null);
    }

    public void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (debug) {
            args.addElement("-g");
        }
        if (linkType.isStaticRuntime()) {
            args.addElement("-staticlib=%all");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-G");
        }
        if (linkType.isStaticLibrary()) {
            args.addElement("-xar");
        }
    }

    public void addIncremental(boolean incremental, Vector<String> args) {
    }

    @Override
    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            File compilerLib;
            File CCloc = CUtil.getExecutableLocation("CC");
            if (CCloc != null && (compilerLib = new File(new File(CCloc, "../lib").getAbsolutePath())).exists()) {
                this.libDirs = new File[2];
                this.libDirs[0] = compilerLib;
            }
            if (this.libDirs == null) {
                this.libDirs = new File[1];
            }
        }
        this.libDirs[this.libDirs.length - 1] = new File("/usr/lib");
        return this.libDirs;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return arLinker;
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }
}

