/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.os400;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.AbstractCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.os400.IccLinker;
import com.github.maven_nar.cpptasks.os400.IccProcessor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class IccCompiler
extends CommandLineCCompiler {
    private static final AbstractCompiler instance = new IccCompiler(false, null);

    public static AbstractCompiler getInstance() {
        return instance;
    }

    private IccCompiler(boolean newEnvironment, Environment env) {
        super("icc", null, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".s"}, new String[]{".h", ".hpp"}, ".o", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
        IccProcessor.addWarningSwitch(args, level);
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new IccCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-q");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return IccProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return IccLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

