/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.Linker;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.TextStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Commandline;

public final class NarUtil {
    public static final String DEFAULT_EXCLUDES = "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store";

    private NarUtil() {
    }

    public static String getOS(String defaultOs) {
        String os = defaultOs;
        if (os == null) {
            os = System.getProperty("os.name");
            String name = os.toLowerCase();
            if (name.startsWith("windows")) {
                os = "Windows";
            }
            if (name.startsWith("linux")) {
                os = "Linux";
            }
            if (name.startsWith("freebsd")) {
                os = "FreeBSD";
            }
            if (name.equals("mac os x")) {
                os = "MacOSX";
            }
        }
        return os;
    }

    public static String getArchitecture(String architecture) {
        if (architecture == null) {
            return System.getProperty("os.arch");
        }
        return architecture;
    }

    public static Linker getLinker(Linker linker, Log log) {
        Linker link = linker;
        if (link == null) {
            link = new Linker(log);
        }
        return link;
    }

    public static String getLinkerName(MavenProject project, String architecture, String os, Linker linker, Log log) throws MojoFailureException, MojoExecutionException {
        return NarUtil.getLinker(linker, log).getName(NarProperties.getInstance(project), NarUtil.getArchitecture(architecture) + "." + NarUtil.getOS(os) + ".");
    }

    public static AOL getAOL(MavenProject project, String architecture, String os, Linker linker, String aol, Log log) throws MojoFailureException, MojoExecutionException {
        return aol == null ? new AOL(NarUtil.getArchitecture(architecture), NarUtil.getOS(os), NarUtil.getLinkerName(project, architecture, os, linker, log)) : new AOL(aol);
    }

    public static String getAOLKey(String aol) {
        return NarUtil.replace("-", ".", aol);
    }

    public static File getJavaHome(File javaHome, String os) {
        File home = javaHome;
        if (home == null && (home = new File(System.getProperty("java.home"))).getName().equals("jre")) {
            home = home.getParentFile();
        }
        return home;
    }

    public static void makeExecutable(File file, Log log) throws MojoExecutionException, MojoFailureException {
        int result;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                NarUtil.makeExecutable(files[i], log);
            }
        }
        if (file.isFile() && file.canRead() && file.canWrite() && !file.isHidden() && (result = NarUtil.runCommand("chmod", new String[]{"+x", file.getPath()}, null, null, log)) != 0) {
            throw new MojoExecutionException("Failed to execute 'chmod +x " + file.getPath() + "'" + " return code: '" + result + "'.");
        }
    }

    public static void runRanlib(File file, Log log) throws MojoExecutionException, MojoFailureException {
        int result;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                NarUtil.runRanlib(files[i], log);
            }
        }
        if (file.isFile() && file.canWrite() && !file.isHidden() && file.getName().endsWith(".a") && (result = NarUtil.runCommand("ranlib", new String[]{file.getPath()}, null, null, log)) != 0) {
            throw new MojoExecutionException("Failed to execute 'ranlib " + file.getPath() + "'" + " return code: '" + result + "'.");
        }
    }

    static void runInstallNameTool(File[] files, Log log) throws MojoExecutionException, MojoFailureException {
        Set libs = NarUtil.findInstallNameToolCandidates(files, log);
        for (File subjectFile : libs) {
            String subjectName = subjectFile.getName();
            String subjectPath = subjectFile.getPath();
            int idResult = NarUtil.runCommand("install_name_tool", new String[]{"-id", subjectPath, subjectPath}, null, null, log);
            if (idResult != 0) {
                throw new MojoExecutionException("Failed to execute 'install_name_tool -id " + subjectPath + " " + subjectPath + "'" + " return code: '" + idResult + "'.");
            }
            for (File dependentFile : libs) {
                String dependentPath = dependentFile.getPath();
                if (dependentPath == subjectPath) continue;
                int changeResult = NarUtil.runCommand("install_name_tool", new String[]{"-change", subjectName, subjectPath, dependentPath}, null, null, log);
                if (changeResult == 0) continue;
                throw new MojoExecutionException("Failed to execute 'install_name_tool -change " + subjectName + " " + subjectPath + " " + dependentPath + "'" + " return code: '" + changeResult + "'.");
            }
        }
    }

    static Set findInstallNameToolCandidates(File[] files, Log log) throws MojoExecutionException, MojoFailureException {
        HashSet<File> candidates = new HashSet<File>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                candidates.addAll(NarUtil.findInstallNameToolCandidates(file.listFiles(), log));
            }
            String fileName = file.getName();
            if (!file.isFile() || !file.canWrite() || !fileName.endsWith(".so") && !fileName.endsWith(".dylib") && !fileName.endsWith(".jnilib")) continue;
            candidates.add(file);
        }
        return candidates;
    }

    public static void makeLink(File file, Log log) throws MojoExecutionException, MojoFailureException {
        int result;
        File sofile;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                NarUtil.makeLink(files[i], log);
            }
        }
        if (file.isFile() && file.canRead() && file.canWrite() && !file.isHidden() && file.getName().matches(".*\\.so(\\.\\d+)+$") && !(sofile = new File(file.getParent(), file.getName().substring(0, file.getName().indexOf(".so") + 3))).exists() && (result = NarUtil.runCommand("ln", new String[]{"-s", file.getName(), sofile.getPath()}, null, null, log)) != 0) {
            throw new MojoExecutionException("Failed to execute 'ln -s " + file.getName() + " " + sofile.getPath() + "'" + " return code: '" + result + "'.");
        }
    }

    public static JavaClass getBcelClass(String filename) throws IOException {
        ClassParser parser = new ClassParser(filename);
        return parser.parse();
    }

    public static String getHeaderName(String basename, String filename) {
        String base = basename.replaceAll("\\\\", "/");
        String file = filename.replaceAll("\\\\", "/");
        if (!file.startsWith(base)) {
            throw new IllegalArgumentException("Error " + file + " does not start with " + base);
        }
        String header = file.substring(base.length() + 1);
        header = header.replaceAll("/", "_");
        header = header.replaceAll("\\.class", ".h");
        return header;
    }

    public static String replace(CharSequence target, CharSequence replacement, String string) {
        return Pattern.compile(NarUtil.quote(((Object)target).toString())).matcher(string).replaceAll(NarUtil.quoteReplacement(((Object)replacement).toString()));
    }

    private static String quote(String s) {
        String escQ = "\\Q";
        String escE = "\\E";
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E");
            sb.append("\\");
            sb.append("\\E");
            sb.append("\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int copyDirectoryStructure(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        List files = org.codehaus.plexus.util.FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
        String sourcePath = sourceDirectory.getAbsolutePath();
        int copied = 0;
        for (File file : files) {
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                FileUtils.copyFile((File)file, (File)destination);
                ++copied;
                try {
                    Method canExecute = file.getClass().getDeclaredMethod("canExecute", new Class[0]);
                    Method setExecutable = destination.getClass().getDeclaredMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
                    setExecutable.invoke((Object)destination, (Boolean)canExecute.invoke((Object)file, new Object[0]), Boolean.FALSE);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                copied += NarUtil.copyDirectoryStructure(file, destination, includes, excludes);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
        return copied;
    }

    public static String getEnv(String envKey, String alternateSystemProperty, String defaultValue) {
        String envValue;
        block4: {
            envValue = null;
            try {
                envValue = System.getenv(envKey);
                if (envValue == null && alternateSystemProperty != null) {
                    envValue = System.getProperty(alternateSystemProperty);
                }
            }
            catch (Error e) {
                if (alternateSystemProperty == null) break block4;
                envValue = System.getProperty(alternateSystemProperty);
            }
        }
        if (envValue == null) {
            envValue = defaultValue;
        }
        return envValue;
    }

    public static String addLibraryPathToEnv(String path, Map environment, String os) {
        String value;
        String pathName = null;
        char separator = ' ';
        if (os.equals("Windows")) {
            pathName = "PATH";
            separator = ';';
        } else if (os.equals("MacOSX")) {
            pathName = "DYLD_LIBRARY_PATH";
            separator = ':';
        } else {
            pathName = "LD_LIBRARY_PATH";
            separator = ':';
        }
        String string = value = environment != null ? (String)environment.get(pathName) : null;
        if (value == null) {
            value = NarUtil.getEnv(pathName, pathName, null);
        }
        String libPath = path;
        libPath = libPath.replace(File.pathSeparatorChar, separator);
        value = value != null ? value + separator + libPath : libPath;
        if (environment != null) {
            environment.put(pathName, value);
        }
        return pathName + "=" + value;
    }

    public static int runCommand(String cmd, String[] args, File workingDirectory, String[] env, final Log log) throws MojoExecutionException, MojoFailureException {
        if (log.isInfoEnabled()) {
            StringBuilder argLine = new StringBuilder();
            if (args != null) {
                for (String arg : args) {
                    argLine.append(" " + arg);
                }
            }
            if (workingDirectory != null) {
                log.info((CharSequence)("+ cd " + workingDirectory.getAbsolutePath()));
            }
            log.info((CharSequence)("+ " + cmd + argLine));
        }
        return NarUtil.runCommand(cmd, args, workingDirectory, env, new TextStream(){

            @Override
            public void println(String text) {
                log.info((CharSequence)text);
            }
        }, new TextStream(){

            @Override
            public void println(String text) {
                log.error((CharSequence)text);
            }
        }, new TextStream(){

            @Override
            public void println(String text) {
                log.debug((CharSequence)text);
            }
        }, log);
    }

    public static int runCommand(String cmd, String[] args, File workingDirectory, String[] env, TextStream out, TextStream err, TextStream dbg, Log log) throws MojoExecutionException, MojoFailureException {
        return NarUtil.runCommand(cmd, args, workingDirectory, env, out, err, dbg, log, false);
    }

    public static int runCommand(String cmd, String[] args, File workingDirectory, String[] env, TextStream out, TextStream err, TextStream dbg, Log log, boolean expectFailure) throws MojoExecutionException, MojoFailureException {
        Commandline cmdLine = new Commandline();
        try {
            int i;
            dbg.println("RunCommand: " + cmd);
            cmdLine.setExecutable(cmd);
            if (args != null) {
                for (i = 0; i < args.length; ++i) {
                    dbg.println("  '" + args[i] + "'");
                }
                cmdLine.addArguments(args);
            }
            if (workingDirectory != null) {
                dbg.println("in: " + workingDirectory.getPath());
                cmdLine.setWorkingDirectory(workingDirectory);
            }
            if (env != null) {
                dbg.println("with Env:");
                for (i = 0; i < env.length; ++i) {
                    String[] nameValue = env[i].split("=", 2);
                    if (nameValue.length < 2) {
                        throw new MojoFailureException("   Misformed env: '" + env[i] + "'");
                    }
                    dbg.println("   '" + nameValue[0] + "=" + nameValue[1] + "'");
                    cmdLine.addEnvironment(nameValue[0], nameValue[1]);
                }
            }
            Process process = cmdLine.execute();
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), err);
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), out);
            errorGobbler.start();
            outputGobbler.start();
            process.waitFor();
            int exitValue = process.exitValue();
            dbg.println("ExitValue: " + exitValue);
            int timeout = 5000;
            errorGobbler.join(5000L);
            outputGobbler.join(5000L);
            if (exitValue != 0 ^ expectFailure) {
                if (log == null) {
                    System.err.println(err.toString());
                    System.err.println(out.toString());
                    System.err.println(dbg.toString());
                } else {
                    log.warn((CharSequence)err.toString());
                    log.warn((CharSequence)out.toString());
                    log.warn((CharSequence)dbg.toString());
                }
                throw new MojoExecutionException("exit code: " + exitValue);
            }
            return exitValue;
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not launch " + cmdLine, e);
        }
    }

    static List collectActiveProfiles(MavenProject project) {
        List profiles = project.getActiveProfiles();
        if (project.hasParent()) {
            profiles.addAll(NarUtil.collectActiveProfiles(project.getParent()));
        }
        return profiles;
    }

    static void removeNulls(Collection<?> collection) {
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            iter.remove();
        }
    }

    private static final class StreamGobbler
    extends Thread {
        private InputStream is;
        private TextStream ts;

        private StreamGobbler(InputStream is, TextStream ts) {
            this.is = is;
            this.ts = ts;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.ts.println(line);
                }
                reader.close();
            }
            catch (IOException e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    this.ts.println(stackTrace[i].toString());
                }
            }
        }
    }
}

