/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AttachedNarArtifact;
import com.github.maven_nar.Linker;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarInfo;
import com.github.maven_nar.NarLayout;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class NarManager {
    private Log log;
    private MavenProject project;
    private ArtifactRepository repository;
    private AOL defaultAOL;
    private String linkerName;
    private String[] narTypes = new String[]{"noarch", "static", "shared", "jni", "plugin"};

    public NarManager(Log log, ArtifactRepository repository, MavenProject project, String architecture, String os, Linker linker) throws MojoFailureException, MojoExecutionException {
        this.log = log;
        this.repository = repository;
        this.project = project;
        this.defaultAOL = NarUtil.getAOL(project, architecture, os, linker, null, log);
        this.linkerName = NarUtil.getLinkerName(project, architecture, os, linker, log);
    }

    public final List getNarDependencies(String scope) throws MojoExecutionException {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(scope);
        return this.getNarDependencies(scopes);
    }

    public final List getNarDependencies(List<String> scopes) throws MojoExecutionException {
        LinkedList<NarArtifact> narDependencies = new LinkedList<NarArtifact>();
        for (Artifact dependency : this.getDependencies(scopes)) {
            this.log.debug((CharSequence)("Examining artifact for NarInfo: " + dependency));
            NarInfo narInfo = this.getNarInfo(dependency);
            if (narInfo == null) continue;
            this.log.debug((CharSequence)"    - added as NarDependency");
            narDependencies.add(new NarArtifact(dependency, narInfo));
        }
        return narDependencies;
    }

    public final Map getAttachedNarDependencyMap(String scope) throws MojoExecutionException, MojoFailureException {
        HashMap<String, List> attachedNarDependencies = new HashMap<String, List>();
        for (Artifact dependency : this.getNarDependencies(scope)) {
            for (int j = 0; j < this.narTypes.length; ++j) {
                List artifactList = this.getAttachedNarDependencies(dependency, this.defaultAOL, this.narTypes[j]);
                if (artifactList == null) continue;
                attachedNarDependencies.put(this.narTypes[j], artifactList);
            }
        }
        return attachedNarDependencies;
    }

    public final List getAttachedNarDependencies(List narArtifacts) throws MojoExecutionException, MojoFailureException {
        return this.getAttachedNarDependencies(narArtifacts, (String)null);
    }

    public final List getAttachedNarDependencies(List narArtifacts, String classifier) throws MojoExecutionException, MojoFailureException {
        AOL aol = null;
        String type = null;
        if (classifier != null) {
            int dash = classifier.lastIndexOf(45);
            if (dash < 0) {
                aol = new AOL(classifier);
                type = null;
            } else {
                aol = new AOL(classifier.substring(0, dash));
                type = classifier.substring(dash + 1);
            }
        }
        return this.getAttachedNarDependencies(narArtifacts, aol, type);
    }

    public final List getAttachedNarDependencies(List narArtifacts, String[] classifiers) throws MojoExecutionException, MojoFailureException {
        ArrayList artifactList = new ArrayList();
        if (classifiers != null && classifiers.length > 0) {
            for (int j = 0; j < classifiers.length; ++j) {
                if (artifactList == null) continue;
                artifactList.addAll(this.getAttachedNarDependencies(narArtifacts, classifiers[j]));
            }
        } else {
            artifactList.addAll(this.getAttachedNarDependencies(narArtifacts, (String)null));
        }
        return artifactList;
    }

    public final List getAttachedNarDependencies(List narArtifacts, AOL archOsLinker, String type) throws MojoExecutionException, MojoFailureException {
        boolean noarch = false;
        AOL aol = archOsLinker;
        if (aol == null) {
            noarch = true;
            aol = this.defaultAOL;
        }
        ArrayList artifactList = new ArrayList();
        for (Artifact dependency : narArtifacts) {
            NarInfo narInfo = this.getNarInfo(dependency);
            if (noarch) {
                artifactList.addAll(this.getAttachedNarDependencies(dependency, null, "noarch"));
            }
            String binding = narInfo.getBinding(aol, type != null ? type : "static");
            if (aol.equals("noarch")) {
                artifactList.addAll(this.getAttachedNarDependencies(dependency, null, "noarch"));
                continue;
            }
            artifactList.addAll(this.getAttachedNarDependencies(dependency, aol, binding));
        }
        return artifactList;
    }

    private List getAttachedNarDependencies(Artifact dependency, AOL archOsLinker, String type) throws MojoExecutionException, MojoFailureException {
        AOL aol = archOsLinker;
        this.log.debug((CharSequence)("GetNarDependencies for " + dependency + ", aol: " + aol + ", type: " + type));
        ArrayList<AttachedNarArtifact> artifactList = new ArrayList<AttachedNarArtifact>();
        NarInfo narInfo = this.getNarInfo(dependency);
        String[] nars = narInfo.getAttachedNars(aol, type);
        if (nars != null) {
            for (int j = 0; j < nars.length; ++j) {
                this.log.debug((CharSequence)("    Checking: " + nars[j]));
                if (nars[j].equals("")) continue;
                String[] nar = nars[j].split(":", 5);
                if (nar.length >= 4) {
                    try {
                        String groupId = nar[0].trim();
                        String artifactId = nar[1].trim();
                        String ext = nar[2].trim();
                        String classifier = nar[3].trim();
                        aol = narInfo.getAOL(aol);
                        if (aol != null) {
                            classifier = NarUtil.replace("${aol}", aol.toString(), classifier);
                        }
                        String version = nar.length >= 5 ? nar[4].trim() : dependency.getBaseVersion();
                        artifactList.add(new AttachedNarArtifact(groupId, artifactId, version, dependency.getScope(), ext, classifier, dependency.isOptional(), dependency.getFile()));
                        continue;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException("Error while reading nar file for dependency " + dependency, (Exception)((Object)e));
                    }
                }
                this.log.warn((CharSequence)("nars property in " + dependency.getArtifactId() + " contains invalid field: '" + nars[j] + "' for type: " + type));
            }
        }
        return artifactList;
    }

    public final NarInfo getNarInfo(Artifact dependency) throws MojoExecutionException {
        NarInfo narInfo;
        dependency.isSnapshot();
        File file = new File(this.repository.getBasedir(), this.repository.pathOf(dependency));
        if (!file.exists()) {
            return null;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            NarInfo info = new NarInfo(dependency.getGroupId(), dependency.getArtifactId(), dependency.getBaseVersion(), this.log);
            if (!info.exists(jar)) {
                NarInfo narInfo2 = null;
                return narInfo2;
            }
            info.read(jar);
            narInfo = info;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading " + file, (Exception)e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return narInfo;
    }

    public final File getNarFile(Artifact dependency) throws MojoFailureException {
        dependency.isSnapshot();
        return new File(this.repository.getBasedir(), NarUtil.replace("${aol}", this.defaultAOL.toString(), this.repository.pathOf(dependency)));
    }

    public List getDependencies(List<String> scopes) {
        Set artifacts = this.project.getArtifacts();
        ArrayList<Artifact> returnArtifact = new ArrayList<Artifact>();
        for (Artifact a : artifacts) {
            if (!scopes.contains(a.getScope())) continue;
            returnArtifact.add(a);
        }
        return returnArtifact;
    }

    public final void downloadAttachedNars(List narArtifacts, List remoteRepositories, ArtifactResolver resolver, String classifier) throws MojoExecutionException, MojoFailureException {
        List dependencies = this.getAttachedNarDependencies(narArtifacts, classifier);
        this.log.debug((CharSequence)("Download called with classifier: " + classifier + " for NarDependencies {"));
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            this.log.debug((CharSequence)("  - " + i.next()));
        }
        this.log.debug((CharSequence)"}");
        for (Artifact dependency : dependencies) {
            try {
                this.log.debug((CharSequence)("Resolving " + dependency));
                resolver.resolve(dependency, remoteRepositories, this.repository);
            }
            catch (ArtifactNotFoundException e) {
                String message = "nar not found " + dependency.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
            catch (ArtifactResolutionException e) {
                String message = "nar cannot resolve " + dependency.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        }
    }

    public final void unpackAttachedNars(List narArtifacts, ArchiverManager archiverManager, String classifier, String os, NarLayout layout, File unpackDir) throws MojoExecutionException, MojoFailureException {
        this.log.debug((CharSequence)("Unpack called for OS: " + os + ", classifier: " + classifier + " for NarArtifacts {"));
        Iterator i = narArtifacts.iterator();
        while (i.hasNext()) {
            this.log.debug((CharSequence)("  - " + i.next()));
        }
        this.log.debug((CharSequence)"}");
        List dependencies = this.getAttachedNarDependencies(narArtifacts, classifier);
        for (Artifact dependency : dependencies) {
            this.log.debug((CharSequence)("Unpack " + dependency + " to " + unpackDir));
            File file = this.getNarFile(dependency);
            layout.unpackNar(unpackDir, archiverManager, file, os, this.linkerName, this.defaultAOL);
        }
    }
}

