/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIParameterMetaData
implements ParameterMetaData {
    private final int[] m_sqlTypes;

    SPIParameterMetaData(int[] sqlTypes) {
        this.m_sqlTypes = sqlTypes;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.m_sqlTypes == null ? 0 : this.m_sqlTypes.length;
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        return true;
    }

    @Override
    public int getPrecision(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int arg0) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return this.m_sqlTypes[paramIndex - 1];
    }

    @Override
    public String getParameterTypeName(int arg0) throws SQLException {
        throw new UnsupportedFeatureException("Parameter type name support not yet implemented");
    }

    @Override
    public String getParameterClassName(int arg0) throws SQLException {
        throw new UnsupportedFeatureException("Parameter class name support not yet implemented");
    }

    @Override
    public int getParameterMode(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<?> ) not implemented yet.", "0A000");
    }
}

