/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.org.apache.commons.lang.enums;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.shade.org.apache.commons.lang.ClassUtils;
import org.apache.maven.surefire.shade.org.apache.commons.lang.StringUtils;

public abstract class Enum
implements Comparable,
Serializable {
    private static final long serialVersionUID = -487045951170455942L;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static final Map cEnumClasses = new HashMap();
    private final String iName;
    private final transient int iHashCode;
    protected transient String iToString = null;
    static /* synthetic */ Class class$org$apache$commons$lang$enums$Enum;
    static /* synthetic */ Class class$org$apache$commons$lang$enums$ValuedEnum;

    protected Enum(String name) {
        this.init(name);
        this.iName = name;
        this.iHashCode = 7 + this.getEnumClass().hashCode() + 3 * name.hashCode();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        return this.iName.compareTo(((Enum)other).iName);
    }

    private static Entry createEntry(Class enumClass) {
        class Org_apache_maven_surefire_shade_org_apache_commons_lang_enums_Enum$1 {
            /* synthetic */ Org_apache_maven_surefire_shade_org_apache_commons_lang_enums_Enum$1() {
            }
        }
        Entry entry = new Entry();
        Class cls = enumClass.getSuperclass();
        while (cls != null && cls != (class$org$apache$commons$lang$enums$Enum != null ? class$org$apache$commons$lang$enums$Enum : Enum.class$("org.apache.maven.surefire.shade.org.apache.commons.lang.enums.Enum")) && cls != (class$org$apache$commons$lang$enums$ValuedEnum != null ? class$org$apache$commons$lang$enums$ValuedEnum : Enum.class$("org.apache.maven.surefire.shade.org.apache.commons.lang.enums.ValuedEnum"))) {
            Entry loopEntry = (Entry)cEnumClasses.get(cls);
            if (loopEntry != null) {
                entry.list.addAll(loopEntry.list);
                entry.map.putAll(loopEntry.map);
                break;
            }
            cls = cls.getSuperclass();
        }
        return entry;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)other).iName);
        }
        if (!other.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        try {
            Method mth = other.getClass().getMethod("getName", null);
            String name = (String)mth.invoke(other, null);
            return this.iName.equals(name);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    private static Entry getEntry(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!(class$org$apache$commons$lang$enums$Enum != null ? class$org$apache$commons$lang$enums$Enum : (class$org$apache$commons$lang$enums$Enum = Enum.class$("org.apache.maven.surefire.shade.org.apache.commons.lang.enums.Enum"))).isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        return entry;
    }

    protected static Enum getEnum(Class enumClass, String name) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(name);
    }

    public Class getEnumClass() {
        return this.getClass();
    }

    protected static List getEnumList(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return entry.unmodifiableList;
    }

    protected static Map getEnumMap(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return entry.unmodifiableMap;
    }

    public final String getName() {
        return this.iName;
    }

    public final int hashCode() {
        return this.iHashCode;
    }

    private void init(String name) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("The Enum name must not be empty or null");
        }
        Class enumClass = this.getEnumClass();
        if (enumClass == null) {
            throw new IllegalArgumentException("getEnumClass() must not be null");
        }
        Class<?> cls = this.getClass();
        boolean ok = false;
        while (cls != null && cls != (class$org$apache$commons$lang$enums$Enum != null ? class$org$apache$commons$lang$enums$Enum : Enum.class$("org.apache.maven.surefire.shade.org.apache.commons.lang.enums.Enum")) && cls != (class$org$apache$commons$lang$enums$ValuedEnum != null ? class$org$apache$commons$lang$enums$ValuedEnum : Enum.class$("org.apache.maven.surefire.shade.org.apache.commons.lang.enums.ValuedEnum"))) {
            if (cls == enumClass) {
                ok = true;
                break;
            }
            cls = cls.getSuperclass();
        }
        if (!ok) {
            throw new IllegalArgumentException("getEnumClass() must return a superclass of this class");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        if (entry == null) {
            entry = Enum.createEntry(enumClass);
            cEnumClasses.put(enumClass, entry);
        }
        if (entry.map.containsKey(name)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
        }
        entry.map.put(name, this);
        entry.list.add(this);
    }

    protected static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    protected Object readResolve() {
        Entry entry = (Entry)cEnumClasses.get(this.getEnumClass());
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(this.getName());
    }

    public String toString() {
        if (this.iToString == null) {
            String shortName = ClassUtils.getShortClassName(this.getEnumClass());
            this.iToString = String.valueOf(shortName) + "[" + this.getName() + "]";
        }
        return this.iToString;
    }

    private static class Entry {
        final Map map = new HashMap();
        final Map unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List list = new ArrayList(25);
        final List unmodifiableList = Collections.unmodifiableList(this.list);

        private Entry() {
        }
    }
}

