# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._batch_management_client_enums import *


class ActivateApplicationPackageParameters(msrest.serialization.Model):
    """Parameters for an activating an application package.

    All required parameters must be populated in order to send to Azure.

    :param format: Required. The format of the application package binary file.
    :type format: str
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        format: str,
        **kwargs
    ):
        super(ActivateApplicationPackageParameters, self).__init__(**kwargs)
        self.format = format


class ProxyResource(msrest.serialization.Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class Application(ProxyResource):
    """Contains information about an application in a Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param display_name: The display name for the application.
    :type display_name: str
    :param allow_updates: A value indicating whether packages within the application may be
     overwritten using the same version string.
    :type allow_updates: bool
    :param default_version: The package to use if a client requests the application but does not
     specify a version. This property can only be set to the name of an existing package.
    :type default_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'allow_updates': {'key': 'properties.allowUpdates', 'type': 'bool'},
        'default_version': {'key': 'properties.defaultVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        allow_updates: Optional[bool] = None,
        default_version: Optional[str] = None,
        **kwargs
    ):
        super(Application, self).__init__(**kwargs)
        self.display_name = display_name
        self.allow_updates = allow_updates
        self.default_version = default_version


class ApplicationPackage(ProxyResource):
    """An application package which represents a particular version of an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar state: The current state of the application package. Possible values include: "Pending",
     "Active".
    :vartype state: str or ~azure.mgmt.batch.models.PackageState
    :ivar format: The format of the application package, if the package is active.
    :vartype format: str
    :ivar storage_url: The URL for the application package in Azure Storage.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the Azure Storage URL will expire.
    :vartype storage_url_expiry: ~datetime.datetime
    :ivar last_activation_time: The time at which the package was last activated, if the package is
     active.
    :vartype last_activation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
        'format': {'readonly': True},
        'storage_url': {'readonly': True},
        'storage_url_expiry': {'readonly': True},
        'last_activation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'storage_url': {'key': 'properties.storageUrl', 'type': 'str'},
        'storage_url_expiry': {'key': 'properties.storageUrlExpiry', 'type': 'iso-8601'},
        'last_activation_time': {'key': 'properties.lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationPackage, self).__init__(**kwargs)
        self.state = None
        self.format = None
        self.storage_url = None
        self.storage_url_expiry = None
        self.last_activation_time = None


class ApplicationPackageReference(msrest.serialization.Model):
    """Link to an application package inside the batch account.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the application package to install. This must be inside the same
     batch account as the pool. This can either be a reference to a specific version or the default
     version if one exists.
    :type id: str
    :param version: If this is omitted, and no default version is specified for this application,
     the request fails with the error code InvalidApplicationPackageReferences. If you are calling
     the REST API directly, the HTTP status code is 409.
    :type version: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationPackageReference, self).__init__(**kwargs)
        self.id = id
        self.version = version


class AutoScaleRun(msrest.serialization.Model):
    """The results and errors from an execution of a pool autoscale formula.

    All required parameters must be populated in order to send to Azure.

    :param evaluation_time: Required. The time at which the autoscale formula was last evaluated.
    :type evaluation_time: ~datetime.datetime
    :param results: Each variable value is returned in the form $variable=value, and variables are
     separated by semicolons.
    :type results: str
    :param error: An error that occurred when autoscaling a pool.
    :type error: ~azure.mgmt.batch.models.AutoScaleRunError
    """

    _validation = {
        'evaluation_time': {'required': True},
    }

    _attribute_map = {
        'evaluation_time': {'key': 'evaluationTime', 'type': 'iso-8601'},
        'results': {'key': 'results', 'type': 'str'},
        'error': {'key': 'error', 'type': 'AutoScaleRunError'},
    }

    def __init__(
        self,
        *,
        evaluation_time: datetime.datetime,
        results: Optional[str] = None,
        error: Optional["AutoScaleRunError"] = None,
        **kwargs
    ):
        super(AutoScaleRun, self).__init__(**kwargs)
        self.evaluation_time = evaluation_time
        self.results = results
        self.error = error


class AutoScaleRunError(msrest.serialization.Model):
    """An error that occurred when autoscaling a pool.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be suitable for display
     in a user interface.
    :type message: str
    :param details: Additional details about the error.
    :type details: list[~azure.mgmt.batch.models.AutoScaleRunError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AutoScaleRunError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["AutoScaleRunError"]] = None,
        **kwargs
    ):
        super(AutoScaleRunError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class AutoScaleSettings(msrest.serialization.Model):
    """AutoScale settings for the pool.

    All required parameters must be populated in order to send to Azure.

    :param formula: Required. A formula for the desired number of compute nodes in the pool.
    :type formula: str
    :param evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
    :type evaluation_interval: ~datetime.timedelta
    """

    _validation = {
        'formula': {'required': True},
    }

    _attribute_map = {
        'formula': {'key': 'formula', 'type': 'str'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        formula: str,
        evaluation_interval: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        super(AutoScaleSettings, self).__init__(**kwargs)
        self.formula = formula
        self.evaluation_interval = evaluation_interval


class AutoStorageBaseProperties(msrest.serialization.Model):
    """The properties related to the auto-storage account.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_id: Required. The resource ID of the storage account to be used for
     auto-storage account.
    :type storage_account_id: str
    :param authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Possible values include: "StorageKeys",
     "BatchAccountManagedIdentity". Default value: "StorageKeys".
    :type authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :param node_identity_reference: The identity referenced here must be assigned to pools which
     have compute nodes that need access to auto-storage.
    :type node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _validation = {
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'node_identity_reference': {'key': 'nodeIdentityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        authentication_mode: Optional[Union[str, "AutoStorageAuthenticationMode"]] = "StorageKeys",
        node_identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        super(AutoStorageBaseProperties, self).__init__(**kwargs)
        self.storage_account_id = storage_account_id
        self.authentication_mode = authentication_mode
        self.node_identity_reference = node_identity_reference


class AutoStorageProperties(AutoStorageBaseProperties):
    """Contains information about the auto-storage account associated with a Batch account.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_id: Required. The resource ID of the storage account to be used for
     auto-storage account.
    :type storage_account_id: str
    :param authentication_mode: The authentication mode which the Batch service will use to manage
     the auto-storage account. Possible values include: "StorageKeys",
     "BatchAccountManagedIdentity". Default value: "StorageKeys".
    :type authentication_mode: str or ~azure.mgmt.batch.models.AutoStorageAuthenticationMode
    :param node_identity_reference: The identity referenced here must be assigned to pools which
     have compute nodes that need access to auto-storage.
    :type node_identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    :param last_key_sync: Required. The UTC time at which storage keys were last synchronized with
     the Batch account.
    :type last_key_sync: ~datetime.datetime
    """

    _validation = {
        'storage_account_id': {'required': True},
        'last_key_sync': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'authentication_mode': {'key': 'authenticationMode', 'type': 'str'},
        'node_identity_reference': {'key': 'nodeIdentityReference', 'type': 'ComputeNodeIdentityReference'},
        'last_key_sync': {'key': 'lastKeySync', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        storage_account_id: str,
        last_key_sync: datetime.datetime,
        authentication_mode: Optional[Union[str, "AutoStorageAuthenticationMode"]] = "StorageKeys",
        node_identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        super(AutoStorageProperties, self).__init__(storage_account_id=storage_account_id, authentication_mode=authentication_mode, node_identity_reference=node_identity_reference, **kwargs)
        self.last_key_sync = last_key_sync


class AutoUserSpecification(msrest.serialization.Model):
    """Specifies the parameters for the auto user that runs a task on the Batch service.

    :param scope: The default value is Pool. If the pool is running Windows a value of Task should
     be specified if stricter isolation between tasks is required. For example, if the task mutates
     the registry in a way which could impact other tasks, or if certificates have been specified on
     the pool which should not be accessible by normal tasks but should be accessible by start
     tasks. Possible values include: "Task", "Pool".
    :type scope: str or ~azure.mgmt.batch.models.AutoUserScope
    :param elevation_level: The default value is nonAdmin. Possible values include: "NonAdmin",
     "Admin".
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scope: Optional[Union[str, "AutoUserScope"]] = None,
        elevation_level: Optional[Union[str, "ElevationLevel"]] = None,
        **kwargs
    ):
        super(AutoUserSpecification, self).__init__(**kwargs)
        self.scope = scope
        self.elevation_level = elevation_level


class AzureBlobFileSystemConfiguration(msrest.serialization.Model):
    """Information used to connect to an Azure Storage Container using Blobfuse.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. The Azure Storage Account name.
    :type account_name: str
    :param container_name: Required. The Azure Blob Storage Container name.
    :type container_name: str
    :param account_key: This property is mutually exclusive with both sasKey and identity; exactly
     one must be specified.
    :type account_key: str
    :param sas_key: This property is mutually exclusive with both accountKey and identity; exactly
     one must be specified.
    :type sas_key: str
    :param blobfuse_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :type blobfuse_options: str
    :param relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param identity_reference: This property is mutually exclusive with both accountKey and sasKey;
     exactly one must be specified.
    :type identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _validation = {
        'account_name': {'required': True},
        'container_name': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'sas_key': {'key': 'sasKey', 'type': 'str'},
        'blobfuse_options': {'key': 'blobfuseOptions', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        container_name: str,
        relative_mount_path: str,
        account_key: Optional[str] = None,
        sas_key: Optional[str] = None,
        blobfuse_options: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        super(AzureBlobFileSystemConfiguration, self).__init__(**kwargs)
        self.account_name = account_name
        self.container_name = container_name
        self.account_key = account_key
        self.sas_key = sas_key
        self.blobfuse_options = blobfuse_options
        self.relative_mount_path = relative_mount_path
        self.identity_reference = identity_reference


class AzureFileShareConfiguration(msrest.serialization.Model):
    """Information used to connect to an Azure Fileshare.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. The Azure Storage account name.
    :type account_name: str
    :param azure_file_url: Required. This is of the form
     'https://{account}.file.core.windows.net/'.
    :type azure_file_url: str
    :param account_key: Required. The Azure Storage account key.
    :type account_key: str
    :param relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :type mount_options: str
    """

    _validation = {
        'account_name': {'required': True},
        'azure_file_url': {'required': True},
        'account_key': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'azure_file_url': {'key': 'azureFileUrl', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_name: str,
        azure_file_url: str,
        account_key: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        super(AzureFileShareConfiguration, self).__init__(**kwargs)
        self.account_name = account_name
        self.azure_file_url = azure_file_url
        self.account_key = account_key
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options


class Resource(msrest.serialization.Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class BatchAccount(Resource):
    """Contains information about an Azure Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :param identity: The identity of the Batch account.
    :type identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :ivar account_endpoint: The account endpoint used to interact with the Batch service.
    :vartype account_endpoint: str
    :ivar provisioning_state: The provisioned state of the resource. Possible values include:
     "Invalid", "Creating", "Deleting", "Succeeded", "Failed", "Cancelled".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.ProvisioningState
    :ivar pool_allocation_mode: The allocation mode for creating pools in the Batch account.
     Possible values include: "BatchService", "UserSubscription".
    :vartype pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: Identifies the Azure key vault associated with a Batch account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: If not specified, the default value is 'enabled'. Possible values
     include: "Enabled", "Disabled". Default value: "Enabled".
    :vartype public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     Batch account.
    :vartype private_endpoint_connections: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :ivar auto_storage: Contains information about the auto-storage account associated with a Batch
     account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageProperties
    :ivar encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar dedicated_core_quota: For accounts with PoolAllocationMode set to UserSubscription, quota
     is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota: int
    :ivar low_priority_core_quota: For accounts with PoolAllocationMode set to UserSubscription,
     quota is managed on the subscription so this value is not returned.
    :vartype low_priority_core_quota: int
    :ivar dedicated_core_quota_per_vm_family: A list of the dedicated core quota per Virtual
     Machine family for the Batch account. For accounts with PoolAllocationMode set to
     UserSubscription, quota is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota_per_vm_family:
     list[~azure.mgmt.batch.models.VirtualMachineFamilyCoreQuota]
    :ivar dedicated_core_quota_per_vm_family_enforced: Batch is transitioning its core quota system
     for dedicated cores to be enforced per Virtual Machine family. During this transitional phase,
     the dedicated core quota per Virtual Machine family may not yet be enforced. If this flag is
     false, dedicated core quota is enforced via the old dedicatedCoreQuota property on the account
     and does not consider Virtual Machine family. If this flag is true, dedicated core quota is
     enforced via the dedicatedCoreQuotaPerVMFamily property on the account, and the old
     dedicatedCoreQuota does not apply.
    :vartype dedicated_core_quota_per_vm_family_enforced: bool
    :ivar pool_quota: The pool quota for the Batch account.
    :vartype pool_quota: int
    :ivar active_job_and_job_schedule_quota: The active job and job schedule quota for the Batch
     account.
    :vartype active_job_and_job_schedule_quota: int
    :ivar allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :vartype allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'account_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pool_allocation_mode': {'readonly': True},
        'key_vault_reference': {'readonly': True},
        'public_network_access': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'auto_storage': {'readonly': True},
        'encryption': {'readonly': True},
        'dedicated_core_quota': {'readonly': True},
        'low_priority_core_quota': {'readonly': True},
        'dedicated_core_quota_per_vm_family': {'readonly': True},
        'dedicated_core_quota_per_vm_family_enforced': {'readonly': True},
        'pool_quota': {'readonly': True},
        'active_job_and_job_schedule_quota': {'readonly': True},
        'allowed_authentication_modes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'account_endpoint': {'key': 'properties.accountEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'str'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'dedicated_core_quota': {'key': 'properties.dedicatedCoreQuota', 'type': 'int'},
        'low_priority_core_quota': {'key': 'properties.lowPriorityCoreQuota', 'type': 'int'},
        'dedicated_core_quota_per_vm_family': {'key': 'properties.dedicatedCoreQuotaPerVMFamily', 'type': '[VirtualMachineFamilyCoreQuota]'},
        'dedicated_core_quota_per_vm_family_enforced': {'key': 'properties.dedicatedCoreQuotaPerVMFamilyEnforced', 'type': 'bool'},
        'pool_quota': {'key': 'properties.poolQuota', 'type': 'int'},
        'active_job_and_job_schedule_quota': {'key': 'properties.activeJobAndJobScheduleQuota', 'type': 'int'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["BatchAccountIdentity"] = None,
        **kwargs
    ):
        super(BatchAccount, self).__init__(**kwargs)
        self.identity = identity
        self.account_endpoint = None
        self.provisioning_state = None
        self.pool_allocation_mode = None
        self.key_vault_reference = None
        self.public_network_access = None
        self.private_endpoint_connections = None
        self.auto_storage = None
        self.encryption = None
        self.dedicated_core_quota = None
        self.low_priority_core_quota = None
        self.dedicated_core_quota_per_vm_family = None
        self.dedicated_core_quota_per_vm_family_enforced = None
        self.pool_quota = None
        self.active_job_and_job_schedule_quota = None
        self.allowed_authentication_modes = None


class BatchAccountCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create operation.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The region in which to create the account.
    :type location: str
    :param tags: A set of tags. The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param identity: The identity of the Batch account.
    :type identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :param pool_allocation_mode: The pool allocation mode also affects how clients may authenticate
     to the Batch Service API. If the mode is BatchService, clients may authenticate using access
     keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active
     Directory. The default is BatchService. Possible values include: "BatchService",
     "UserSubscription".
    :type pool_allocation_mode: str or ~azure.mgmt.batch.models.PoolAllocationMode
    :param key_vault_reference: A reference to the Azure key vault associated with the Batch
     account.
    :type key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :param public_network_access: If not specified, the default value is 'enabled'. Possible values
     include: "Enabled", "Disabled". Default value: "Enabled".
    :type public_network_access: str or ~azure.mgmt.batch.models.PublicNetworkAccessType
    :param encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :type encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :param allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :type allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'str'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["BatchAccountIdentity"] = None,
        auto_storage: Optional["AutoStorageBaseProperties"] = None,
        pool_allocation_mode: Optional[Union[str, "PoolAllocationMode"]] = None,
        key_vault_reference: Optional["KeyVaultReference"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccessType"]] = "Enabled",
        encryption: Optional["EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[List[Union[str, "AuthenticationMode"]]] = None,
        **kwargs
    ):
        super(BatchAccountCreateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.identity = identity
        self.auto_storage = auto_storage
        self.pool_allocation_mode = pool_allocation_mode
        self.key_vault_reference = key_vault_reference
        self.public_network_access = public_network_access
        self.encryption = encryption
        self.allowed_authentication_modes = allowed_authentication_modes


class BatchAccountIdentity(msrest.serialization.Model):
    """The identity of the Batch account, if configured. This is used when the user specifies 'Microsoft.KeyVault' as their Batch account encryption configuration or when ``ManagedIdentity`` is selected as the auto-storage authentication mode.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal id of the Batch account. This property will only be provided
     for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the Batch account. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: Required. The type of identity used for the Batch account. Possible values
     include: "SystemAssigned", "UserAssigned", "None".
    :type type: str or ~azure.mgmt.batch.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the Batch account.
    :type user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentities}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ResourceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentities"]] = None,
        **kwargs
    ):
        super(BatchAccountIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class BatchAccountKeys(msrest.serialization.Model):
    """A set of Azure Batch account keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    _validation = {
        'account_name': {'readonly': True},
        'primary': {'readonly': True},
        'secondary': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BatchAccountKeys, self).__init__(**kwargs)
        self.account_name = None
        self.primary = None
        self.secondary = None


class BatchAccountListResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :param value: The collection of Batch accounts returned by the listing operation.
    :type value: list[~azure.mgmt.batch.models.BatchAccount]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BatchAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["BatchAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(BatchAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BatchAccountRegenerateKeyParameters(msrest.serialization.Model):
    """Parameters supplied to the RegenerateKey operation.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The type of account key to regenerate. Possible values include:
     "Primary", "Secondary".
    :type key_name: str or ~azure.mgmt.batch.models.AccountKeyType
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Union[str, "AccountKeyType"],
        **kwargs
    ):
        super(BatchAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class BatchAccountUpdateParameters(msrest.serialization.Model):
    """Parameters for updating an Azure Batch account.

    :param tags: A set of tags. The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param identity: The identity of the Batch account.
    :type identity: ~azure.mgmt.batch.models.BatchAccountIdentity
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :param encryption: Configures how customer data is encrypted inside the Batch account. By
     default, accounts are encrypted using a Microsoft managed key. For additional control, a
     customer-managed key can be used instead.
    :type encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :param allowed_authentication_modes: List of allowed authentication modes for the Batch account
     that can be used to authenticate with the data plane. This does not affect authentication with
     the control plane.
    :type allowed_authentication_modes: list[str or ~azure.mgmt.batch.models.AuthenticationMode]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'BatchAccountIdentity'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'allowed_authentication_modes': {'key': 'properties.allowedAuthenticationModes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["BatchAccountIdentity"] = None,
        auto_storage: Optional["AutoStorageBaseProperties"] = None,
        encryption: Optional["EncryptionProperties"] = None,
        allowed_authentication_modes: Optional[List[Union[str, "AuthenticationMode"]]] = None,
        **kwargs
    ):
        super(BatchAccountUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.auto_storage = auto_storage
        self.encryption = encryption
        self.allowed_authentication_modes = allowed_authentication_modes


class BatchLocationQuota(msrest.serialization.Model):
    """Quotas associated with a Batch region for a particular subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_quota: The number of Batch accounts that may be created under the subscription in
     the specified region.
    :vartype account_quota: int
    """

    _validation = {
        'account_quota': {'readonly': True},
    }

    _attribute_map = {
        'account_quota': {'key': 'accountQuota', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BatchLocationQuota, self).__init__(**kwargs)
        self.account_quota = None


class BatchPoolIdentity(msrest.serialization.Model):
    """The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the updated identities.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of identity used for the Batch Pool. Possible values include:
     "UserAssigned", "None".
    :type type: str or ~azure.mgmt.batch.models.PoolIdentityType
    :param user_assigned_identities: The list of user identities associated with the Batch pool.
    :type user_assigned_identities: dict[str, ~azure.mgmt.batch.models.UserAssignedIdentities]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentities}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "PoolIdentityType"],
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentities"]] = None,
        **kwargs
    ):
        super(BatchPoolIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Certificate(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state:  Possible values include: "Succeeded", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time: The time at which the certificate entered its current
     state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar previous_provisioning_state: The previous provisioned state of the resource. Possible
     values include: "Succeeded", "Deleting", "Failed".
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time: The time at which the certificate entered
     its previous state.
    :vartype previous_provisioning_state_transition_time: ~datetime.datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: This is only returned when the certificate provisioningState is
     'Failed'.
    :vartype delete_certificate_error: ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'properties.previousProvisioningState', 'type': 'str'},
        'previous_provisioning_state_transition_time': {'key': 'properties.previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'properties.publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'properties.deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateBaseProperties(msrest.serialization.Model):
    """Base certificate properties.

    :param thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    """

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        super(CertificateBaseProperties, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format


class CertificateCreateOrUpdateParameters(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :param data: The maximum size is 10KB.
    :type data: str
    :param password: This must not be specified if the certificate format is Cer.
    :type password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.thumbprint_algorithm = thumbprint_algorithm
        self.thumbprint = thumbprint
        self.format = format
        self.data = data
        self.password = password


class CertificateCreateOrUpdateProperties(CertificateBaseProperties):
    """Certificate properties for create operations.

    All required parameters must be populated in order to send to Azure.

    :param thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :param data: Required. The maximum size is 10KB.
    :type data: str
    :param password: This must not be specified if the certificate format is Cer.
    :type password: str
    """

    _validation = {
        'data': {'required': True},
    }

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data: str,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(CertificateCreateOrUpdateProperties, self).__init__(thumbprint_algorithm=thumbprint_algorithm, thumbprint=thumbprint, format=format, **kwargs)
        self.data = data
        self.password = password


class CertificateProperties(CertificateBaseProperties):
    """Certificate properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param thumbprint_algorithm: This must match the first portion of the certificate name.
     Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If omitted, the default is
     Pfx. Possible values include: "Pfx", "Cer".
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state:  Possible values include: "Succeeded", "Deleting", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time: The time at which the certificate entered its current
     state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar previous_provisioning_state: The previous provisioned state of the resource. Possible
     values include: "Succeeded", "Deleting", "Failed".
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time: The time at which the certificate entered
     its previous state.
    :vartype previous_provisioning_state_transition_time: ~datetime.datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: This is only returned when the certificate provisioningState is
     'Failed'.
    :vartype delete_certificate_error: ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'previousProvisioningState', 'type': 'str'},
        'previous_provisioning_state_transition_time': {'key': 'previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(
        self,
        *,
        thumbprint_algorithm: Optional[str] = None,
        thumbprint: Optional[str] = None,
        format: Optional[Union[str, "CertificateFormat"]] = None,
        **kwargs
    ):
        super(CertificateProperties, self).__init__(thumbprint_algorithm=thumbprint_algorithm, thumbprint=thumbprint, format=format, **kwargs)
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateReference(msrest.serialization.Model):
    """A reference to a certificate to be installed on compute nodes in a pool. This must exist inside the same account as the pool.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The fully qualified ID of the certificate to install on the pool. This
     must be inside the same batch account as the pool.
    :type id: str
    :param store_location: The default value is currentUser. This property is applicable only for
     pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with
     virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the
     certificates are stored in a directory inside the task working directory and an environment
     variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For
     certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home
     directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     Possible values include: "CurrentUser", "LocalMachine".
    :type store_location: str or ~azure.mgmt.batch.models.CertificateStoreLocation
    :param store_name: This property is applicable only for pools configured with Windows nodes
     (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a
     Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed,
     TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be
     used. The default value is My.
    :type store_name: str
    :param visibility: Which user accounts on the compute node should have access to the private
     data of the certificate.
    :type visibility: list[str or ~azure.mgmt.batch.models.CertificateVisibility]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'store_location': {'key': 'storeLocation', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: str,
        store_location: Optional[Union[str, "CertificateStoreLocation"]] = None,
        store_name: Optional[str] = None,
        visibility: Optional[List[Union[str, "CertificateVisibility"]]] = None,
        **kwargs
    ):
        super(CertificateReference, self).__init__(**kwargs)
        self.id = id
        self.store_location = store_location
        self.store_name = store_name
        self.visibility = visibility


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name to check for availability.
    :type name: str
    :ivar type: The resource type. Has constant value: "Microsoft.Batch/batchAccounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Batch/batchAccounts"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Batch account name could not be used. The Reason element
     is only returned if NameAvailable is false. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.batch.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CIFSMountConfiguration(msrest.serialization.Model):
    """Information used to connect to a CIFS file system.

    All required parameters must be populated in order to send to Azure.

    :param username: Required. The user to use for authentication against the CIFS file system.
    :type username: str
    :param source: Required. The URI of the file system to mount.
    :type source: str
    :param relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :type mount_options: str
    :param password: Required. The password to use for authentication against the CIFS file system.
    :type password: str
    """

    _validation = {
        'username': {'required': True},
        'source': {'required': True},
        'relative_mount_path': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: str,
        source: str,
        relative_mount_path: str,
        password: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        super(CIFSMountConfiguration, self).__init__(**kwargs)
        self.username = username
        self.source = source
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options
        self.password = password


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.batch.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CloudServiceConfiguration(msrest.serialization.Model):
    """The configuration for nodes in a pool based on the Azure Cloud Services platform.

    All required parameters must be populated in order to send to Azure.

    :param os_family: Required. Possible values are: 2 - OS Family 2, equivalent to Windows Server
     2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to
     Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6,
     equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases
     (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
    :type os_family: str
    :param os_version: The default value is * which specifies the latest operating system version
     for the specified OS family.
    :type os_version: str
    """

    _validation = {
        'os_family': {'required': True},
    }

    _attribute_map = {
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_family: str,
        os_version: Optional[str] = None,
        **kwargs
    ):
        super(CloudServiceConfiguration, self).__init__(**kwargs)
        self.os_family = os_family
        self.os_version = os_version


class ComputeNodeIdentityReference(msrest.serialization.Model):
    """The reference to a user assigned identity associated with the Batch pool which a compute node will use.

    :param resource_id: The ARM resource id of the user assigned identity.
    :type resource_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ComputeNodeIdentityReference, self).__init__(**kwargs)
        self.resource_id = resource_id


class ContainerConfiguration(msrest.serialization.Model):
    """The configuration for container-enabled pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The container technology to be used. Has constant value: "DockerCompatible".
    :vartype type: str
    :param container_image_names: This is the full image reference, as would be specified to
     "docker pull". An image will be sourced from the default Docker registry unless the image is
     fully qualified with an alternative registry.
    :type container_image_names: list[str]
    :param container_registries: If any images must be downloaded from a private registry which
     requires credentials, then those credentials must be provided here.
    :type container_registries: list[~azure.mgmt.batch.models.ContainerRegistry]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'container_image_names': {'key': 'containerImageNames', 'type': '[str]'},
        'container_registries': {'key': 'containerRegistries', 'type': '[ContainerRegistry]'},
    }

    type = "DockerCompatible"

    def __init__(
        self,
        *,
        container_image_names: Optional[List[str]] = None,
        container_registries: Optional[List["ContainerRegistry"]] = None,
        **kwargs
    ):
        super(ContainerConfiguration, self).__init__(**kwargs)
        self.container_image_names = container_image_names
        self.container_registries = container_registries


class ContainerRegistry(msrest.serialization.Model):
    """A private container registry.

    :param user_name: The user name to log into the registry server.
    :type user_name: str
    :param password: The password to log into the registry server.
    :type password: str
    :param registry_server: If omitted, the default is "docker.io".
    :type registry_server: str
    :param identity_reference: The reference to a user assigned identity associated with the Batch
     pool which a compute node will use.
    :type identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _attribute_map = {
        'user_name': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'registry_server': {'key': 'registryServer', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        registry_server: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        super(ContainerRegistry, self).__init__(**kwargs)
        self.user_name = user_name
        self.password = password
        self.registry_server = registry_server
        self.identity_reference = identity_reference


class DataDisk(msrest.serialization.Model):
    """Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. The lun is used to uniquely identify each data disk. If attaching
     multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
    :type lun: int
    :param caching: Values are:
    
      none - The caching mode for the disk is not enabled.
      readOnly - The caching mode for the disk is read only.
      readWrite - The caching mode for the disk is read and write.
    
      The default value for caching is none. For information about the caching options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Possible values include: "None", "ReadOnly", "ReadWrite".
    :type caching: str or ~azure.mgmt.batch.models.CachingType
    :param disk_size_gb: Required. The initial disk size in GB when creating new data disk.
    :type disk_size_gb: int
    :param storage_account_type: If omitted, the default is "Standard_LRS". Values are:
    
      Standard_LRS - The data disk should use standard locally redundant storage.
      Premium_LRS - The data disk should use premium locally redundant storage. Possible values
     include: "Standard_LRS", "Premium_LRS".
    :type storage_account_type: str or ~azure.mgmt.batch.models.StorageAccountType
    """

    _validation = {
        'lun': {'required': True},
        'disk_size_gb': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: int,
        disk_size_gb: int,
        caching: Optional[Union[str, "CachingType"]] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        **kwargs
    ):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class DeleteCertificateError(msrest.serialization.Model):
    """An error response from the Batch service.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be suitable for display
     in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.batch.models.DeleteCertificateError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DeleteCertificateError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["DeleteCertificateError"]] = None,
        **kwargs
    ):
        super(DeleteCertificateError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DeploymentConfiguration(msrest.serialization.Model):
    """Deployment configuration properties.

    :param cloud_service_configuration: This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property cannot be specified if the
     Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration: ~azure.mgmt.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :type virtual_machine_configuration: ~azure.mgmt.batch.models.VirtualMachineConfiguration
    """

    _attribute_map = {
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
    }

    def __init__(
        self,
        *,
        cloud_service_configuration: Optional["CloudServiceConfiguration"] = None,
        virtual_machine_configuration: Optional["VirtualMachineConfiguration"] = None,
        **kwargs
    ):
        super(DeploymentConfiguration, self).__init__(**kwargs)
        self.cloud_service_configuration = cloud_service_configuration
        self.virtual_machine_configuration = virtual_machine_configuration


class DiffDiskSettings(msrest.serialization.Model):
    """Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.

    :param placement: This property can be used by user in the request to choose which location the
     operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For
     more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size
     requirements for Windows VMs at
     https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
     and Linux VMs at
     https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements.
     The only acceptable values to pass in are None and "CacheDisk". The default value is None.
    :type placement: str
    """

    _attribute_map = {
        'placement': {'key': 'placement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        placement: Optional[str] = None,
        **kwargs
    ):
        super(DiffDiskSettings, self).__init__(**kwargs)
        self.placement = placement


class DiskEncryptionConfiguration(msrest.serialization.Model):
    """The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.

    :param targets: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
     "TemporaryDisk" must be specified.
    :type targets: list[str or ~azure.mgmt.batch.models.DiskEncryptionTarget]
    """

    _attribute_map = {
        'targets': {'key': 'targets', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        targets: Optional[List[Union[str, "DiskEncryptionTarget"]]] = None,
        **kwargs
    ):
        super(DiskEncryptionConfiguration, self).__init__(**kwargs)
        self.targets = targets


class EncryptionProperties(msrest.serialization.Model):
    """Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.

    :param key_source: Type of the key source. Possible values include: "Microsoft.Batch",
     "Microsoft.KeyVault".
    :type key_source: str or ~azure.mgmt.batch.models.KeySource
    :param key_vault_properties: Additional details when using Microsoft.KeyVault.
    :type key_vault_properties: ~azure.mgmt.batch.models.KeyVaultProperties
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        *,
        key_source: Optional[Union[str, "KeySource"]] = None,
        key_vault_properties: Optional["KeyVaultProperties"] = None,
        **kwargs
    ):
        super(EncryptionProperties, self).__init__(**kwargs)
        self.key_source = key_source
        self.key_vault_properties = key_vault_properties


class EndpointDependency(msrest.serialization.Model):
    """A domain name and connection details used to access a dependency.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_name: The domain name of the dependency. Domain names may be fully qualified or
     may contain a * wildcard.
    :vartype domain_name: str
    :ivar description: Human-readable supplemental information about the dependency and when it is
     applicable.
    :vartype description: str
    :ivar endpoint_details: The list of connection details for this endpoint.
    :vartype endpoint_details: list[~azure.mgmt.batch.models.EndpointDetail]
    """

    _validation = {
        'domain_name': {'readonly': True},
        'description': {'readonly': True},
        'endpoint_details': {'readonly': True},
    }

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = None
        self.description = None
        self.endpoint_details = None


class EndpointDetail(msrest.serialization.Model):
    """Details about the connection between the Batch service and the endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    _validation = {
        'port': {'readonly': True},
    }

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.port = None


class EnvironmentSetting(msrest.serialization.Model):
    """An environment variable to be set on a task process.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the environment variable.
    :type name: str
    :param value: The value of the environment variable.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        super(EnvironmentSetting, self).__init__(**kwargs)
        self.name = name
        self.value = value


class FixedScaleSettings(msrest.serialization.Model):
    """Fixed scale settings for the pool.

    :param resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format. For
     example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less
     than 5 minutes, the Batch service rejects the request with an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: ~datetime.timedelta
    :param target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes
     must be set.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes
     must be set.
    :type target_low_priority_nodes: int
    :param node_deallocation_option: If omitted, the default value is Requeue. Possible values
     include: "Requeue", "Terminate", "TaskCompletion", "RetainedData".
    :type node_deallocation_option: str or ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resize_timeout: Optional[datetime.timedelta] = None,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        node_deallocation_option: Optional[Union[str, "ComputeNodeDeallocationOption"]] = None,
        **kwargs
    ):
        super(FixedScaleSettings, self).__init__(**kwargs)
        self.resize_timeout = resize_timeout
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.node_deallocation_option = node_deallocation_option


class ImageReference(msrest.serialization.Model):
    """A reference to an Azure Virtual Machines Marketplace image or the Azure Image resource of a custom Virtual Machine. To get the list of all imageReferences verified by Azure Batch, see the 'List supported node agent SKUs' operation.

    :param publisher: For example, Canonical or MicrosoftWindowsServer.
    :type publisher: str
    :param offer: For example, UbuntuServer or WindowsServer.
    :type offer: str
    :param sku: For example, 18.04-LTS or 2019-Datacenter.
    :type sku: str
    :param version: A value of 'latest' can be specified to select the latest version of an image.
     If omitted, the default is 'latest'.
    :type version: str
    :param id: This property is mutually exclusive with other properties. The Shared Image Gallery
     image must have replicas in the same region as the Azure Batch account. For information about
     the firewall settings for the Batch node agent to communicate with the Batch service see
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :type id: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.id = id


class InboundNatPool(msrest.serialization.Model):
    """A inbound NAT pool that can be used to address specific ports on compute nodes in a Batch pool externally.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name must be unique within a Batch pool, can contain letters,
     numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end
     with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values
     are provided the request fails with HTTP status code 400.
    :type name: str
    :param protocol: Required. The protocol of the endpoint. Possible values include: "TCP", "UDP".
    :type protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
    :param backend_port: Required. This must be unique within a Batch pool. Acceptable values are
     between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved
     values are provided the request fails with HTTP status code 400.
    :type backend_port: int
    :param frontend_port_range_start: Required. Acceptable values range between 1 and 65534 except
     ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and
     cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP
     status code 400.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: Required. Acceptable values range between 1 and 65534 except
     ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool
     must be distinct and cannot overlap. If any reserved or overlapping values are provided the
     request fails with HTTP status code 400.
    :type frontend_port_range_end: int
    :param network_security_group_rules: The maximum number of rules that can be specified across
     all the endpoints on a Batch pool is 25. If no network security group rules are specified, a
     default rule will be created to allow inbound access to the specified backendPort. If the
     maximum number of network security group rules is exceeded the request fails with HTTP status
     code 400.
    :type network_security_group_rules: list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'backend_port': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'frontend_port_range_start': {'key': 'frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'frontendPortRangeEnd', 'type': 'int'},
        'network_security_group_rules': {'key': 'networkSecurityGroupRules', 'type': '[NetworkSecurityGroupRule]'},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "InboundEndpointProtocol"],
        backend_port: int,
        frontend_port_range_start: int,
        frontend_port_range_end: int,
        network_security_group_rules: Optional[List["NetworkSecurityGroupRule"]] = None,
        **kwargs
    ):
        super(InboundNatPool, self).__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.backend_port = backend_port
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.network_security_group_rules = network_security_group_rules


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVault configuration when using an encryption KeySource of Microsoft.KeyVault.

    :param key_identifier: Full path to the versioned secret. Example
     https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable
     the following prerequisites must be met:
    
      The Batch Account has a System Assigned identity
      The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
      The KeyVault has soft-delete and purge protection enabled.
    :type key_identifier: str
    """

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier


class KeyVaultReference(msrest.serialization.Model):
    """Identifies the Azure key vault associated with a Batch account.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the Azure key vault associated with the Batch account.
    :type id: str
    :param url: Required. The URL of the Azure key vault associated with the Batch account.
    :type url: str
    """

    _validation = {
        'id': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        url: str,
        **kwargs
    ):
        super(KeyVaultReference, self).__init__(**kwargs)
        self.id = id
        self.url = url


class LinuxUserConfiguration(msrest.serialization.Model):
    """Properties used to create a user account on a Linux node.

    :param uid: The uid and gid properties must be specified together or not at all. If not
     specified the underlying operating system picks the uid.
    :type uid: int
    :param gid: The uid and gid properties must be specified together or not at all. If not
     specified the underlying operating system picks the gid.
    :type gid: int
    :param ssh_private_key: The private key must not be password protected. The private key is used
     to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux
     pool when the pool's enableInterNodeCommunication property is true (it is ignored if
     enableInterNodeCommunication is false). It does this by placing the key pair into the user's
     .ssh directory. If not specified, password-less SSH is not configured between nodes (no
     modification of the user's .ssh directory is done).
    :type ssh_private_key: str
    """

    _attribute_map = {
        'uid': {'key': 'uid', 'type': 'int'},
        'gid': {'key': 'gid', 'type': 'int'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uid: Optional[int] = None,
        gid: Optional[int] = None,
        ssh_private_key: Optional[str] = None,
        **kwargs
    ):
        super(LinuxUserConfiguration, self).__init__(**kwargs)
        self.uid = uid
        self.gid = gid
        self.ssh_private_key = ssh_private_key


class ListApplicationPackagesResult(msrest.serialization.Model):
    """The result of performing list application packages.

    :param value: The list of application packages.
    :type value: list[~azure.mgmt.batch.models.ApplicationPackage]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationPackage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationPackage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListApplicationPackagesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListApplicationsResult(msrest.serialization.Model):
    """The result of performing list applications.

    :param value: The list of applications.
    :type value: list[~azure.mgmt.batch.models.Application]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Application]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Application"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListApplicationsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListCertificatesResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :param value: The collection of returned certificates.
    :type value: list[~azure.mgmt.batch.models.Certificate]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Certificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListCertificatesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPoolsResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :param value: The collection of returned pools.
    :type value: list[~azure.mgmt.batch.models.Pool]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Pool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Pool"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListPoolsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPrivateEndpointConnectionsResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :param value: The collection of returned private endpoint connection.
    :type value: list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListPrivateEndpointConnectionsResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListPrivateLinkResourcesResult(msrest.serialization.Model):
    """Values returned by the List operation.

    :param value: The collection of returned private link resources.
    :type value: list[~azure.mgmt.batch.models.PrivateLinkResource]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListPrivateLinkResourcesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MetadataItem(msrest.serialization.Model):
    """The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the metadata item.
    :type name: str
    :param value: Required. The value of the metadata item.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(MetadataItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class MountConfiguration(msrest.serialization.Model):
    """The file system to mount on each node.

    :param azure_blob_file_system_configuration: This property is mutually exclusive with all other
     properties.
    :type azure_blob_file_system_configuration:
     ~azure.mgmt.batch.models.AzureBlobFileSystemConfiguration
    :param nfs_mount_configuration: This property is mutually exclusive with all other properties.
    :type nfs_mount_configuration: ~azure.mgmt.batch.models.NFSMountConfiguration
    :param cifs_mount_configuration: This property is mutually exclusive with all other properties.
    :type cifs_mount_configuration: ~azure.mgmt.batch.models.CIFSMountConfiguration
    :param azure_file_share_configuration: This property is mutually exclusive with all other
     properties.
    :type azure_file_share_configuration: ~azure.mgmt.batch.models.AzureFileShareConfiguration
    """

    _attribute_map = {
        'azure_blob_file_system_configuration': {'key': 'azureBlobFileSystemConfiguration', 'type': 'AzureBlobFileSystemConfiguration'},
        'nfs_mount_configuration': {'key': 'nfsMountConfiguration', 'type': 'NFSMountConfiguration'},
        'cifs_mount_configuration': {'key': 'cifsMountConfiguration', 'type': 'CIFSMountConfiguration'},
        'azure_file_share_configuration': {'key': 'azureFileShareConfiguration', 'type': 'AzureFileShareConfiguration'},
    }

    def __init__(
        self,
        *,
        azure_blob_file_system_configuration: Optional["AzureBlobFileSystemConfiguration"] = None,
        nfs_mount_configuration: Optional["NFSMountConfiguration"] = None,
        cifs_mount_configuration: Optional["CIFSMountConfiguration"] = None,
        azure_file_share_configuration: Optional["AzureFileShareConfiguration"] = None,
        **kwargs
    ):
        super(MountConfiguration, self).__init__(**kwargs)
        self.azure_blob_file_system_configuration = azure_blob_file_system_configuration
        self.nfs_mount_configuration = nfs_mount_configuration
        self.cifs_mount_configuration = cifs_mount_configuration
        self.azure_file_share_configuration = azure_file_share_configuration


class NetworkConfiguration(msrest.serialization.Model):
    """The network configuration for a pool.

    :param subnet_id: The virtual network must be in the same region and subscription as the Azure
     Batch account. The specified subnet should have enough free IP addresses to accommodate the
     number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will
     partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch'
     service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control
     (RBAC) role for the specified VNet. The specified subnet must allow communication from the
     Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by
     checking if the specified VNet has any associated Network Security Groups (NSG). If
     communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch
     service will set the state of the compute nodes to unusable. If the specified VNet has any
     associated Network Security Groups (NSG), then a few reserved system ports must be enabled for
     inbound communication. For pools created with a virtual machine configuration, enable ports
     29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with
     a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound
     connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic'
     VNETs are supported. For more details see:
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :type subnet_id: str
    :param endpoint_configuration: Pool endpoint configuration is only supported on pools with the
     virtualMachineConfiguration property.
    :type endpoint_configuration: ~azure.mgmt.batch.models.PoolEndpointConfiguration
    :param public_ip_address_configuration: This property is only supported on Pools with the
     virtualMachineConfiguration property.
    :type public_ip_address_configuration: ~azure.mgmt.batch.models.PublicIPAddressConfiguration
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'PoolEndpointConfiguration'},
        'public_ip_address_configuration': {'key': 'publicIPAddressConfiguration', 'type': 'PublicIPAddressConfiguration'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        endpoint_configuration: Optional["PoolEndpointConfiguration"] = None,
        public_ip_address_configuration: Optional["PublicIPAddressConfiguration"] = None,
        **kwargs
    ):
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = subnet_id
        self.endpoint_configuration = endpoint_configuration
        self.public_ip_address_configuration = public_ip_address_configuration


class NetworkSecurityGroupRule(msrest.serialization.Model):
    """A network security group rule to apply to an inbound endpoint.

    All required parameters must be populated in order to send to Azure.

    :param priority: Required. Priorities within a pool must be unique and are evaluated in order
     of priority. The lower the number the higher the priority. For example, rules could be
     specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes
     precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any
     reserved or duplicate values are provided the request fails with HTTP status code 400.
    :type priority: int
    :param access: Required. The action that should be taken for a specified IP address, subnet
     range or tag. Possible values include: "Allow", "Deny".
    :type access: str or ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
    :param source_address_prefix: Required. Valid values are a single IP address (i.e.
     10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any
     other values are provided the request fails with HTTP status code 400.
    :type source_address_prefix: str
    :param source_port_ranges: Valid values are '\ *' (for all ports 0 - 65535) or arrays of ports
     or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges
     or ports can't overlap. If any other values are provided the request fails with HTTP status
     code 400. Default value will be *.
    :type source_port_ranges: list[str]
    """

    _validation = {
        'priority': {'required': True},
        'access': {'required': True},
        'source_address_prefix': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'access': {'key': 'access', 'type': 'str'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        priority: int,
        access: Union[str, "NetworkSecurityGroupRuleAccess"],
        source_address_prefix: str,
        source_port_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        super(NetworkSecurityGroupRule, self).__init__(**kwargs)
        self.priority = priority
        self.access = access
        self.source_address_prefix = source_address_prefix
        self.source_port_ranges = source_port_ranges


class NFSMountConfiguration(msrest.serialization.Model):
    """Information used to connect to an NFS file system.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. The URI of the file system to mount.
    :type source: str
    :param relative_mount_path: Required. All file systems are mounted relative to the Batch mounts
     directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
    :type mount_options: str
    """

    _validation = {
        'source': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
        **kwargs
    ):
        super(NFSMountConfiguration, self).__init__(**kwargs)
        self.source = source
        self.relative_mount_path = relative_mount_path
        self.mount_options = mount_options


class NodePlacementConfiguration(msrest.serialization.Model):
    """Allocation configuration used by Batch Service to provision the nodes.

    :param policy: Allocation policy used by Batch Service to provision the nodes. If not
     specified, Batch will use the regional policy. Possible values include: "Regional", "Zonal".
    :type policy: str or ~azure.mgmt.batch.models.NodePlacementPolicyType
    """

    _attribute_map = {
        'policy': {'key': 'policy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy: Optional[Union[str, "NodePlacementPolicyType"]] = None,
        **kwargs
    ):
        super(NodePlacementConfiguration, self).__init__(**kwargs)
        self.policy = policy


class Operation(msrest.serialization.Model):
    """A REST API operation.

    :param name: This is of the format {provider}/{resource}/{operation}.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.batch.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Any object.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: For example: read, write, delete, or listKeys/action.
    :type operation: str
    :param resource: The resource type on which the operation is performed.
    :type resource: str
    :param description: The friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :param value: The list of operations supported by the resource provider.
    :type value: list[~azure.mgmt.batch.models.Operation]
    :param next_link: The URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSDisk(msrest.serialization.Model):
    """Settings for the operating system disk of the virtual machine.

    :param ephemeral_os_disk_settings: Specifies the ephemeral Disk Settings for the operating
     system disk used by the virtual machine.
    :type ephemeral_os_disk_settings: ~azure.mgmt.batch.models.DiffDiskSettings
    """

    _attribute_map = {
        'ephemeral_os_disk_settings': {'key': 'ephemeralOSDiskSettings', 'type': 'DiffDiskSettings'},
    }

    def __init__(
        self,
        *,
        ephemeral_os_disk_settings: Optional["DiffDiskSettings"] = None,
        **kwargs
    ):
        super(OSDisk, self).__init__(**kwargs)
        self.ephemeral_os_disk_settings = ephemeral_os_disk_settings


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """A collection of related endpoints from the same service for which the Batch service requires outbound access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category: The type of service that the Batch service connects to.
    :vartype category: str
    :ivar endpoints: The endpoints for this service to which the Batch service makes outbound
     calls.
    :vartype endpoints: list[~azure.mgmt.batch.models.EndpointDependency]
    """

    _validation = {
        'category': {'readonly': True},
        'endpoints': {'readonly': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = None
        self.endpoints = None


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Values returned by the List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The collection of outbound network dependency endpoints returned by the listing
     operation.
    :vartype value: list[~azure.mgmt.batch.models.OutboundEnvironmentEndpoint]
    :param next_link: The continuation token.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Pool(ProxyResource):
    """Contains information about a pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param identity: The type of identity used for the Batch Pool.
    :type identity: ~azure.mgmt.batch.models.BatchPoolIdentity
    :param display_name: The display name need not be unique and can contain any Unicode characters
     up to a maximum length of 1024.
    :type display_name: str
    :ivar last_modified: This is the last time at which the pool level data, such as the
     targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes
     such as a compute node changing state.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the pool.
    :vartype creation_time: ~datetime.datetime
    :ivar provisioning_state: The current state of the pool. Possible values include: "Succeeded",
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.batch.models.PoolProvisioningState
    :ivar provisioning_state_transition_time: The time at which the pool entered its current state.
    :vartype provisioning_state_transition_time: ~datetime.datetime
    :ivar allocation_state: Whether the pool is resizing. Possible values include: "Steady",
     "Resizing", "Stopping".
    :vartype allocation_state: str or ~azure.mgmt.batch.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the pool entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :param vm_size: For information about available sizes of virtual machines for Cloud Services
     pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services
     (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch
     supports all Cloud Services VM sizes except ExtraSmall. For information about available VM
     sizes for pools using images from the Virtual Machines Marketplace (pools created with
     virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for
     Virtual Machines (Windows)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch
     supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS,
     STANDARD_DS, and STANDARD_DSV2 series).
    :type vm_size: str
    :param deployment_configuration: Using CloudServiceConfiguration specifies that the nodes
     should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses
     Azure Virtual Machines (IaaS).
    :type deployment_configuration: ~azure.mgmt.batch.models.DeploymentConfiguration
    :ivar current_dedicated_nodes: The number of compute nodes currently in the pool.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of low-priority compute nodes currently in the
     pool.
    :vartype current_low_priority_nodes: int
    :param scale_settings: Defines the desired size of the pool. This can either be 'fixedScale'
     where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula
     which is periodically reevaluated. If this property is not specified, the pool will have a
     fixed scale with 0 targetDedicatedNodes.
    :type scale_settings: ~azure.mgmt.batch.models.ScaleSettings
    :ivar auto_scale_run: This property is set only if the pool automatically scales, i.e.
     autoScaleSettings are used.
    :vartype auto_scale_run: ~azure.mgmt.batch.models.AutoScaleRun
    :param inter_node_communication: This imposes restrictions on which nodes can be assigned to
     the pool. Enabling this value can reduce the chance of the requested number of nodes to be
     allocated in the pool. If not specified, this value defaults to 'Disabled'. Possible values
     include: "Enabled", "Disabled".
    :type inter_node_communication: str or ~azure.mgmt.batch.models.InterNodeCommunicationState
    :param network_configuration: The network configuration for a pool.
    :type network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
    :param task_slots_per_node: The default value is 1. The maximum value is the smaller of 4 times
     the number of cores of the vmSize of the pool or 256.
    :type task_slots_per_node: int
    :param task_scheduling_policy: If not specified, the default is spread.
    :type task_scheduling_policy: ~azure.mgmt.batch.models.TaskSchedulingPolicy
    :param user_accounts: The list of user accounts to be created on each node in the pool.
    :type user_accounts: list[~azure.mgmt.batch.models.UserAccount]
    :param metadata: The Batch service does not assign any meaning to metadata; it is solely for
     the use of user code.
    :type metadata: list[~azure.mgmt.batch.models.MetadataItem]
    :param start_task: In an PATCH (update) operation, this property can be set to an empty object
     to remove the start task from the pool.
    :type start_task: ~azure.mgmt.batch.models.StartTask
    :param certificates: For Windows compute nodes, the Batch service installs the certificates to
     the specified certificate store and location. For Linux compute nodes, the certificates are
     stored in a directory inside the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates
     with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory
     (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificates: list[~azure.mgmt.batch.models.CertificateReference]
    :param application_packages: Changes to application package references affect all new compute
     nodes joining the pool, but do not affect compute nodes that are already in the pool until they
     are rebooted or reimaged. There is a maximum of 10 application package references on any given
     pool.
    :type application_packages: list[~azure.mgmt.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses must be a subset of available
     Batch service application licenses. If a license is requested which is not supported, pool
     creation will fail.
    :type application_licenses: list[str]
    :ivar resize_operation_status: Describes either the current operation (if the pool
     AllocationState is Resizing) or the previously completed operation (if the AllocationState is
     Steady).
    :vartype resize_operation_status: ~azure.mgmt.batch.models.ResizeOperationStatus
    :param mount_configuration: This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
    :type mount_configuration: list[~azure.mgmt.batch.models.MountConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'current_dedicated_nodes': {'readonly': True},
        'current_low_priority_nodes': {'readonly': True},
        'auto_scale_run': {'readonly': True},
        'resize_operation_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'BatchPoolIdentity'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'allocation_state': {'key': 'properties.allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'properties.allocationStateTransitionTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'deployment_configuration': {'key': 'properties.deploymentConfiguration', 'type': 'DeploymentConfiguration'},
        'current_dedicated_nodes': {'key': 'properties.currentDedicatedNodes', 'type': 'int'},
        'current_low_priority_nodes': {'key': 'properties.currentLowPriorityNodes', 'type': 'int'},
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
        'auto_scale_run': {'key': 'properties.autoScaleRun', 'type': 'AutoScaleRun'},
        'inter_node_communication': {'key': 'properties.interNodeCommunication', 'type': 'str'},
        'network_configuration': {'key': 'properties.networkConfiguration', 'type': 'NetworkConfiguration'},
        'task_slots_per_node': {'key': 'properties.taskSlotsPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'properties.taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'properties.userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'properties.metadata', 'type': '[MetadataItem]'},
        'start_task': {'key': 'properties.startTask', 'type': 'StartTask'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateReference]'},
        'application_packages': {'key': 'properties.applicationPackages', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'properties.applicationLicenses', 'type': '[str]'},
        'resize_operation_status': {'key': 'properties.resizeOperationStatus', 'type': 'ResizeOperationStatus'},
        'mount_configuration': {'key': 'properties.mountConfiguration', 'type': '[MountConfiguration]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["BatchPoolIdentity"] = None,
        display_name: Optional[str] = None,
        vm_size: Optional[str] = None,
        deployment_configuration: Optional["DeploymentConfiguration"] = None,
        scale_settings: Optional["ScaleSettings"] = None,
        inter_node_communication: Optional[Union[str, "InterNodeCommunicationState"]] = None,
        network_configuration: Optional["NetworkConfiguration"] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["TaskSchedulingPolicy"] = None,
        user_accounts: Optional[List["UserAccount"]] = None,
        metadata: Optional[List["MetadataItem"]] = None,
        start_task: Optional["StartTask"] = None,
        certificates: Optional[List["CertificateReference"]] = None,
        application_packages: Optional[List["ApplicationPackageReference"]] = None,
        application_licenses: Optional[List[str]] = None,
        mount_configuration: Optional[List["MountConfiguration"]] = None,
        **kwargs
    ):
        super(Pool, self).__init__(**kwargs)
        self.identity = identity
        self.display_name = display_name
        self.last_modified = None
        self.creation_time = None
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.vm_size = vm_size
        self.deployment_configuration = deployment_configuration
        self.current_dedicated_nodes = None
        self.current_low_priority_nodes = None
        self.scale_settings = scale_settings
        self.auto_scale_run = None
        self.inter_node_communication = inter_node_communication
        self.network_configuration = network_configuration
        self.task_slots_per_node = task_slots_per_node
        self.task_scheduling_policy = task_scheduling_policy
        self.user_accounts = user_accounts
        self.metadata = metadata
        self.start_task = start_task
        self.certificates = certificates
        self.application_packages = application_packages
        self.application_licenses = application_licenses
        self.resize_operation_status = None
        self.mount_configuration = mount_configuration


class PoolEndpointConfiguration(msrest.serialization.Model):
    """The endpoint configuration for a pool.

    All required parameters must be populated in order to send to Azure.

    :param inbound_nat_pools: Required. The maximum number of inbound NAT pools per Batch pool is
     5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status
     code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
    :type inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNatPools', 'type': '[InboundNatPool]'},
    }

    def __init__(
        self,
        *,
        inbound_nat_pools: List["InboundNatPool"],
        **kwargs
    ):
        super(PoolEndpointConfiguration, self).__init__(**kwargs)
        self.inbound_nat_pools = inbound_nat_pools


class PrivateEndpoint(msrest.serialization.Model):
    """The private endpoint of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM resource identifier of the private endpoint. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/privateEndpoints/{privateEndpoint}.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Updating", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PrivateEndpointConnectionProvisioningState
    :param private_endpoint: The private endpoint of the private endpoint connection.
    :type private_endpoint: ~azure.mgmt.batch.models.PrivateEndpoint
    :param private_link_service_connection_state: The private link service connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.batch.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResource(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar group_id: The group id is used to establish the private link connection.
    :vartype group_id: str
    :ivar required_members: The list of required members that are used to establish the private
     link connection.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required zone names for the private DNS resource name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The private link service connection state of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of the Batch private endpoint connection. Possible values
     include: "Approved", "Pending", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.batch.models.PrivateLinkServiceConnectionStatus
    :param description: Description of the private Connection state.
    :type description: str
    :ivar action_required: Action required on the private connection state.
    :vartype action_required: str
    """

    _validation = {
        'status': {'required': True},
        'action_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStatus"],
        description: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = None


class PublicIPAddressConfiguration(msrest.serialization.Model):
    """The public IP Address configuration of the networking configuration of a Pool.

    :param provision: The default value is BatchManaged. Possible values include: "BatchManaged",
     "UserManaged", "NoPublicIPAddresses".
    :type provision: str or ~azure.mgmt.batch.models.IPAddressProvisioningType
    :param ip_address_ids: The number of IPs specified here limits the maximum size of the Pool -
     100 dedicated nodes or 100 low-priority nodes can be allocated for each public IP. For example,
     a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of
     this collection is of the form:
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
    :type ip_address_ids: list[str]
    """

    _attribute_map = {
        'provision': {'key': 'provision', 'type': 'str'},
        'ip_address_ids': {'key': 'ipAddressIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        provision: Optional[Union[str, "IPAddressProvisioningType"]] = None,
        ip_address_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(PublicIPAddressConfiguration, self).__init__(**kwargs)
        self.provision = provision
        self.ip_address_ids = ip_address_ids


class ResizeError(msrest.serialization.Model):
    """An error that occurred when resizing a pool.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant and are intended to be
     consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be suitable for display
     in a user interface.
    :type message: str
    :param details: Additional details about the error.
    :type details: list[~azure.mgmt.batch.models.ResizeError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ResizeError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["ResizeError"]] = None,
        **kwargs
    ):
        super(ResizeError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class ResizeOperationStatus(msrest.serialization.Model):
    """Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).

    :param target_dedicated_nodes: The desired number of dedicated compute nodes in the pool.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority compute nodes in the pool.
    :type target_low_priority_nodes: int
    :param resize_timeout: The default value is 15 minutes. The minimum value is 5 minutes. If you
     specify a value less than 5 minutes, the Batch service returns an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: ~datetime.timedelta
    :param node_deallocation_option: The default value is requeue. Possible values include:
     "Requeue", "Terminate", "TaskCompletion", "RetainedData".
    :type node_deallocation_option: str or ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    :param start_time: The time when this resize operation was started.
    :type start_time: ~datetime.datetime
    :param errors: This property is set only if an error occurred during the last pool resize, and
     only when the pool allocationState is Steady.
    :type errors: list[~azure.mgmt.batch.models.ResizeError]
    """

    _attribute_map = {
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ResizeError]'},
    }

    def __init__(
        self,
        *,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        node_deallocation_option: Optional[Union[str, "ComputeNodeDeallocationOption"]] = None,
        start_time: Optional[datetime.datetime] = None,
        errors: Optional[List["ResizeError"]] = None,
        **kwargs
    ):
        super(ResizeOperationStatus, self).__init__(**kwargs)
        self.target_dedicated_nodes = target_dedicated_nodes
        self.target_low_priority_nodes = target_low_priority_nodes
        self.resize_timeout = resize_timeout
        self.node_deallocation_option = node_deallocation_option
        self.start_time = start_time
        self.errors = errors


class ResourceFile(msrest.serialization.Model):
    """A single file or multiple files to be downloaded to a compute node.

    :param auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be specified.
    :type auto_storage_container_name: str
    :param storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl
     properties are mutually exclusive and one of them must be specified. This URL must be readable
     and listable from compute nodes. There are three ways to get such a URL for a container in
     Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on
     the container, use a managed identity with read and list permissions, or set the ACL for the
     container to allow public access.
    :type storage_container_url: str
    :param http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are
     mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage,
     it must be readable from compute nodes. There are three ways to get such a URL for a blob in
     Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob,
     use a managed identity with read permission, or set the ACL for the blob or its container to
     allow public access.
    :type http_url: str
    :param blob_prefix: The property is valid only when autoStorageContainerName or
     storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a
     prefix is not specified, all the files in the container will be downloaded.
    :type blob_prefix: str
    :param file_path: If the httpUrl property is specified, the filePath is required and describes
     the path which the file will be downloaded to, including the filename. Otherwise, if the
     autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and
     is the directory to download the files to. In the case where filePath is used as a directory,
     any directory structure already associated with the input data will be retained in full and
     appended to the specified filePath directory. The specified relative path cannot break out of
     the task's working directory (for example by using '..').
    :type file_path: str
    :param file_mode: This property applies only to files being downloaded to Linux compute nodes.
     It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows
     node. If this property is not specified for a Linux node, then a default value of 0770 is
     applied to the file.
    :type file_mode: str
    :param identity_reference: The reference to a user assigned identity associated with the Batch
     pool which a compute node will use.
    :type identity_reference: ~azure.mgmt.batch.models.ComputeNodeIdentityReference
    """

    _attribute_map = {
        'auto_storage_container_name': {'key': 'autoStorageContainerName', 'type': 'str'},
        'storage_container_url': {'key': 'storageContainerUrl', 'type': 'str'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
        'identity_reference': {'key': 'identityReference', 'type': 'ComputeNodeIdentityReference'},
    }

    def __init__(
        self,
        *,
        auto_storage_container_name: Optional[str] = None,
        storage_container_url: Optional[str] = None,
        http_url: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        file_path: Optional[str] = None,
        file_mode: Optional[str] = None,
        identity_reference: Optional["ComputeNodeIdentityReference"] = None,
        **kwargs
    ):
        super(ResourceFile, self).__init__(**kwargs)
        self.auto_storage_container_name = auto_storage_container_name
        self.storage_container_url = storage_container_url
        self.http_url = http_url
        self.blob_prefix = blob_prefix
        self.file_path = file_path
        self.file_mode = file_mode
        self.identity_reference = identity_reference


class ScaleSettings(msrest.serialization.Model):
    """Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.

    :param fixed_scale: This property and autoScale are mutually exclusive and one of the
     properties must be specified.
    :type fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :param auto_scale: This property and fixedScale are mutually exclusive and one of the
     properties must be specified.
    :type auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    _attribute_map = {
        'fixed_scale': {'key': 'fixedScale', 'type': 'FixedScaleSettings'},
        'auto_scale': {'key': 'autoScale', 'type': 'AutoScaleSettings'},
    }

    def __init__(
        self,
        *,
        fixed_scale: Optional["FixedScaleSettings"] = None,
        auto_scale: Optional["AutoScaleSettings"] = None,
        **kwargs
    ):
        super(ScaleSettings, self).__init__(**kwargs)
        self.fixed_scale = fixed_scale
        self.auto_scale = auto_scale


class SkuCapability(msrest.serialization.Model):
    """A SKU capability, such as the number of cores.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar value: The value of the feature.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class StartTask(msrest.serialization.Model):
    """In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.

    :param command_line: The command line does not run under a shell, and therefore cannot take
     advantage of shell features such as environment variable expansion. If you want to take
     advantage of such features, you should invoke the shell in the command line, for example using
     "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other
     properties of the startTask are specified.
    :type command_line: str
    :param resource_files: A list of files that the Batch service will download to the compute node
     before running the command line.
    :type resource_files: list[~azure.mgmt.batch.models.ResourceFile]
    :param environment_settings: A list of environment variable settings for the start task.
    :type environment_settings: list[~azure.mgmt.batch.models.EnvironmentSetting]
    :param user_identity: If omitted, the task runs as a non-administrative user unique to the
     task.
    :type user_identity: ~azure.mgmt.batch.models.UserIdentity
    :param max_task_retry_count: The Batch service retries a task if its exit code is nonzero. Note
     that this value specifically controls the number of retries. The Batch service will try the
     task once, and may then retry up to this limit. For example, if the maximum retry count is 3,
     Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count
     is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch
     service retries the task without limit.
    :type max_task_retry_count: int
    :param wait_for_success: If true and the start task fails on a compute node, the Batch service
     retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still
     not completed successfully after all retries, then the Batch service marks the compute node
     unusable, and will not schedule tasks to it. This condition can be detected via the node state
     and scheduling error detail. If false, the Batch service will not wait for the start task to
     complete. In this case, other tasks can start executing on the compute node while the start
     task is still running; and even if the start task fails, new tasks will continue to be
     scheduled on the node. The default is true.
    :type wait_for_success: bool
    :param container_settings: When this is specified, all directories recursively below the
     AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the
     container, all task environment variables are mapped into the container, and the task command
     line is executed in the container.
    :type container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
    """

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
    }

    def __init__(
        self,
        *,
        command_line: Optional[str] = None,
        resource_files: Optional[List["ResourceFile"]] = None,
        environment_settings: Optional[List["EnvironmentSetting"]] = None,
        user_identity: Optional["UserIdentity"] = None,
        max_task_retry_count: Optional[int] = None,
        wait_for_success: Optional[bool] = None,
        container_settings: Optional["TaskContainerSettings"] = None,
        **kwargs
    ):
        super(StartTask, self).__init__(**kwargs)
        self.command_line = command_line
        self.resource_files = resource_files
        self.environment_settings = environment_settings
        self.user_identity = user_identity
        self.max_task_retry_count = max_task_retry_count
        self.wait_for_success = wait_for_success
        self.container_settings = container_settings


class SupportedSku(msrest.serialization.Model):
    """Describes a Batch supported SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar family_name: The family name of the SKU.
    :vartype family_name: str
    :ivar capabilities: A collection of capabilities which this SKU supports.
    :vartype capabilities: list[~azure.mgmt.batch.models.SkuCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'family_name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family_name': {'key': 'familyName', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[SkuCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportedSku, self).__init__(**kwargs)
        self.name = None
        self.family_name = None
        self.capabilities = None


class SupportedSkusResult(msrest.serialization.Model):
    """The Batch List supported SKUs operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of SKUs available for the Batch service in the location.
    :type value: list[~azure.mgmt.batch.models.SupportedSku]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SupportedSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SupportedSku"],
        **kwargs
    ):
        super(SupportedSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TaskContainerSettings(msrest.serialization.Model):
    """The container settings for a task.

    All required parameters must be populated in order to send to Azure.

    :param container_run_options: These additional options are supplied as arguments to the "docker
     create" command, in addition to those controlled by the Batch Service.
    :type container_run_options: str
    :param image_name: Required. This is the full image reference, as would be specified to "docker
     pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
    :type image_name: str
    :param registry: This setting can be omitted if was already provided at pool creation.
    :type registry: ~azure.mgmt.batch.models.ContainerRegistry
    :param working_directory: A flag to indicate where the container task working directory is. The
     default is 'taskWorkingDirectory'. Possible values include: "TaskWorkingDirectory",
     "ContainerImageDefault".
    :type working_directory: str or ~azure.mgmt.batch.models.ContainerWorkingDirectory
    """

    _validation = {
        'image_name': {'required': True},
    }

    _attribute_map = {
        'container_run_options': {'key': 'containerRunOptions', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'ContainerRegistry'},
        'working_directory': {'key': 'workingDirectory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_name: str,
        container_run_options: Optional[str] = None,
        registry: Optional["ContainerRegistry"] = None,
        working_directory: Optional[Union[str, "ContainerWorkingDirectory"]] = None,
        **kwargs
    ):
        super(TaskContainerSettings, self).__init__(**kwargs)
        self.container_run_options = container_run_options
        self.image_name = image_name
        self.registry = registry
        self.working_directory = working_directory


class TaskSchedulingPolicy(msrest.serialization.Model):
    """Specifies how tasks should be distributed across compute nodes.

    All required parameters must be populated in order to send to Azure.

    :param node_fill_type: Required. How tasks should be distributed across compute nodes. Possible
     values include: "Spread", "Pack".
    :type node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
    """

    _validation = {
        'node_fill_type': {'required': True},
    }

    _attribute_map = {
        'node_fill_type': {'key': 'nodeFillType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        node_fill_type: Union[str, "ComputeNodeFillType"],
        **kwargs
    ):
        super(TaskSchedulingPolicy, self).__init__(**kwargs)
        self.node_fill_type = node_fill_type


class UserAccount(msrest.serialization.Model):
    """Properties used to create a user on an Azure Batch node.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the user account.
    :type name: str
    :param password: Required. The password for the user account.
    :type password: str
    :param elevation_level: nonAdmin - The auto user is a standard user without elevated access.
     admin - The auto user is a user with elevated access and operates with full Administrator
     permissions. The default value is nonAdmin. Possible values include: "NonAdmin", "Admin".
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    :param linux_user_configuration: This property is ignored if specified on a Windows pool. If
     not specified, the user is created with the default options.
    :type linux_user_configuration: ~azure.mgmt.batch.models.LinuxUserConfiguration
    :param windows_user_configuration: This property can only be specified if the user is on a
     Windows pool. If not specified and on a Windows pool, the user is created with the default
     options.
    :type windows_user_configuration: ~azure.mgmt.batch.models.WindowsUserConfiguration
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'str'},
        'linux_user_configuration': {'key': 'linuxUserConfiguration', 'type': 'LinuxUserConfiguration'},
        'windows_user_configuration': {'key': 'windowsUserConfiguration', 'type': 'WindowsUserConfiguration'},
    }

    def __init__(
        self,
        *,
        name: str,
        password: str,
        elevation_level: Optional[Union[str, "ElevationLevel"]] = None,
        linux_user_configuration: Optional["LinuxUserConfiguration"] = None,
        windows_user_configuration: Optional["WindowsUserConfiguration"] = None,
        **kwargs
    ):
        super(UserAccount, self).__init__(**kwargs)
        self.name = name
        self.password = password
        self.elevation_level = elevation_level
        self.linux_user_configuration = linux_user_configuration
        self.windows_user_configuration = windows_user_configuration


class UserAssignedIdentities(msrest.serialization.Model):
    """The list of associated user identities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentities, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserIdentity(msrest.serialization.Model):
    """Specify either the userName or autoUser property, but not both.

    :param user_name: The userName and autoUser properties are mutually exclusive; you must specify
     one but not both.
    :type user_name: str
    :param auto_user: The userName and autoUser properties are mutually exclusive; you must specify
     one but not both.
    :type auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'auto_user': {'key': 'autoUser', 'type': 'AutoUserSpecification'},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        auto_user: Optional["AutoUserSpecification"] = None,
        **kwargs
    ):
        super(UserIdentity, self).__init__(**kwargs)
        self.user_name = user_name
        self.auto_user = auto_user


class VirtualMachineConfiguration(msrest.serialization.Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual Machines infrastructure.

    All required parameters must be populated in order to send to Azure.

    :param image_reference: Required. A reference to an Azure Virtual Machines Marketplace image or
     the Azure Image resource of a custom Virtual Machine. To get the list of all imageReferences
     verified by Azure Batch, see the 'List supported node agent SKUs' operation.
    :type image_reference: ~azure.mgmt.batch.models.ImageReference
    :param node_agent_sku_id: Required. The Batch node agent is a program that runs on each node in
     the pool, and provides the command-and-control interface between the node and the Batch
     service. There are different implementations of the node agent, known as SKUs, for different
     operating systems. You must specify a node agent SKU which matches the selected image
     reference. To get the list of supported node agent SKUs along with their list of verified image
     references, see the 'List supported node agent SKUs' operation.
    :type node_agent_sku_id: str
    :param windows_configuration: This property must not be specified if the imageReference
     specifies a Linux OS image.
    :type windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
    :param data_disks: This property must be specified if the compute nodes in the pool need to
     have empty data disks attached to them.
    :type data_disks: list[~azure.mgmt.batch.models.DataDisk]
    :param license_type: This only applies to images that contain the Windows operating system, and
     should only be used when you hold valid on-premises licenses for the nodes which will be
     deployed. If omitted, no on-premises licensing discount is applied. Values are:
    
      Windows_Server - The on-premises license is for Windows Server.
      Windows_Client - The on-premises license is for Windows Client.
    :type license_type: str
    :param container_configuration: If specified, setup is performed on each node in the pool to
     allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must
     specify the containerSettings property, and all other tasks may specify it.
    :type container_configuration: ~azure.mgmt.batch.models.ContainerConfiguration
    :param disk_encryption_configuration: If specified, encryption is performed on each node in the
     pool during node provisioning.
    :type disk_encryption_configuration: ~azure.mgmt.batch.models.DiskEncryptionConfiguration
    :param node_placement_configuration: This configuration will specify rules on how nodes in the
     pool will be physically allocated.
    :type node_placement_configuration: ~azure.mgmt.batch.models.NodePlacementConfiguration
    :param extensions: If specified, the extensions mentioned in this configuration will be
     installed on each node.
    :type extensions: list[~azure.mgmt.batch.models.VMExtension]
    :param os_disk: Contains configuration for ephemeral OSDisk settings.
    :type os_disk: ~azure.mgmt.batch.models.OSDisk
    """

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSkuId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'ContainerConfiguration'},
        'disk_encryption_configuration': {'key': 'diskEncryptionConfiguration', 'type': 'DiskEncryptionConfiguration'},
        'node_placement_configuration': {'key': 'nodePlacementConfiguration', 'type': 'NodePlacementConfiguration'},
        'extensions': {'key': 'extensions', 'type': '[VMExtension]'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
    }

    def __init__(
        self,
        *,
        image_reference: "ImageReference",
        node_agent_sku_id: str,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        data_disks: Optional[List["DataDisk"]] = None,
        license_type: Optional[str] = None,
        container_configuration: Optional["ContainerConfiguration"] = None,
        disk_encryption_configuration: Optional["DiskEncryptionConfiguration"] = None,
        node_placement_configuration: Optional["NodePlacementConfiguration"] = None,
        extensions: Optional[List["VMExtension"]] = None,
        os_disk: Optional["OSDisk"] = None,
        **kwargs
    ):
        super(VirtualMachineConfiguration, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.node_agent_sku_id = node_agent_sku_id
        self.windows_configuration = windows_configuration
        self.data_disks = data_disks
        self.license_type = license_type
        self.container_configuration = container_configuration
        self.disk_encryption_configuration = disk_encryption_configuration
        self.node_placement_configuration = node_placement_configuration
        self.extensions = extensions
        self.os_disk = os_disk


class VirtualMachineFamilyCoreQuota(msrest.serialization.Model):
    """A VM Family and its associated core quota for the Batch account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The Virtual Machine family name.
    :vartype name: str
    :ivar core_quota: The core quota for the VM family for the Batch account.
    :vartype core_quota: int
    """

    _validation = {
        'name': {'readonly': True},
        'core_quota': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'core_quota': {'key': 'coreQuota', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineFamilyCoreQuota, self).__init__(**kwargs)
        self.name = None
        self.core_quota = None


class VMExtension(msrest.serialization.Model):
    """The configuration for virtual machine extensions.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the virtual machine extension.
    :type name: str
    :param publisher: Required. The name of the extension handler publisher.
    :type publisher: str
    :param type: Required. The type of the extensions.
    :type type: str
    :param type_handler_version: The version of script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Any object.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
        'provision_after_extensions': {'key': 'provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        provision_after_extensions: Optional[List[str]] = None,
        **kwargs
    ):
        super(VMExtension, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provision_after_extensions = provision_after_extensions


class WindowsConfiguration(msrest.serialization.Model):
    """Windows operating system settings to apply to the virtual machine.

    :param enable_automatic_updates: If omitted, the default value is true.
    :type enable_automatic_updates: bool
    """

    _attribute_map = {
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
        **kwargs
    ):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.enable_automatic_updates = enable_automatic_updates


class WindowsUserConfiguration(msrest.serialization.Model):
    """Properties used to create a user account on a Windows node.

    :param login_mode: Specifies login mode for the user. The default value for
     VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools
     is batch mode. Possible values include: "Batch", "Interactive".
    :type login_mode: str or ~azure.mgmt.batch.models.LoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        login_mode: Optional[Union[str, "LoginMode"]] = None,
        **kwargs
    ):
        super(WindowsUserConfiguration, self).__init__(**kwargs)
        self.login_mode = login_mode
