﻿# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from msrestazure.azure_operation import AzureOperationPoller
import uuid


class NetworkManagementClientConfiguration(AzureConfiguration):
    """Configuration for NetworkManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription credentials which uniquely
     identify the Microsoft Azure subscription. The subscription ID forms part
     of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(NetworkManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('networkmanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class NetworkManagementClient(object):
    """Composite Swagger for Network Client

    :ivar config: Configuration for client.
    :vartype config: NetworkManagementClientConfiguration

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription credentials which uniquely
     identify the Microsoft Azure subscription. The subscription ID forms part
     of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    DEFAULT_API_VERSION='2017-08-01'

    def __init__(
            self, credentials, subscription_id, api_version=DEFAULT_API_VERSION, base_url=None):

        self.config = NetworkManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in self.models(api_version).__dict__.items() if isinstance(v, type)}
        self.api_version = api_version
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

    def check_dns_name_availability(
            self, location, domain_name_label=None, custom_headers=None, raw=False, **operation_config):
        """Checks whether a domain name in the cloudapp.net zone is available for
        use.

        :param location: The location of the domain name.
        :type location: str
        :param domain_name_label: The domain name to be verified. It must
         conform to the following regular expression:
         ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
        :type domain_name_label: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: :class:`DnsNameAvailabilityResult
         <azure.mgmt.network.v2017_08_01.models.DnsNameAvailabilityResult>` or
         :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>` if
         raw=true
        :rtype: :class:`DnsNameAvailabilityResult
         <azure.mgmt.network.v2017_08_01.models.DnsNameAvailabilityResult>` or
         :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        if self.api_version == '2017-08-01':
            from .v2017_08_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2015-06-15':
            from .v2015_06_15 import NetworkManagementClient as ClientClass
        localclient = ClientClass(self.config.credentials,
                                  self.config.subscription_id,
                                  self.config.base_url)
        return localclient.check_dns_name_availability(location,
                                                       domain_name_label,
                                                       custom_headers,
                                                       raw,
                                                       **operation_config)

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-15: :mod:`v2015_06_15.models<azure.mgmt.network.v2015_06_15.models>`
           * 2016-09-01: :mod:`v2016_09_01.models<azure.mgmt.network.v2016_09_01.models>`
           * 2016-12-01: :mod:`v2016_12_01.models<azure.mgmt.network.v2016_12_01.models>`
           * 2017-03-01: :mod:`v2017_03_01.models<azure.mgmt.network.v2017_03_01.models>`
           * 2017-06-01: :mod:`v2017_06_01.models<azure.mgmt.network.v2017_06_01.models>`
           * 2017-08-01: :mod:`v2017_08_01.models<azure.mgmt.network.v2017_08_01.models>`
        """
        if api_version == '2015-06-15':
            from .v2015_06_15 import models
            return models
        elif api_version == '2016-09-01':
            from .v2016_09_01 import models
            return models
        elif api_version == '2016-12-01':
            from .v2016_12_01 import models
            return models
        elif api_version == '2017-03-01':
            from .v2017_03_01 import models
            return models
        elif api_version == '2017-06-01':
            from .v2017_06_01 import models
            return models
        elif api_version == '2017-08-01':
            from .v2017_08_01 import models
            return models
        raise NotImplementedError("APIVersion {} is not available".format(api_version))

    @property
    def application_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.ApplicationGatewaysOperations>`
           * 2016-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.ApplicationGatewaysOperations>`
           * 2016-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.ApplicationGatewaysOperations>`
           * 2017-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.ApplicationGatewaysOperations>`
           * 2017-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.ApplicationGatewaysOperations>`
           * 2017-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.ApplicationGatewaysOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import ApplicationGatewaysOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import ApplicationGatewaysOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import ApplicationGatewaysOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import ApplicationGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def available_endpoint_services(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_06_01.operations.AvailableEndpointServicesOperations>`
           * 2017-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_08_01.operations.AvailableEndpointServicesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def bgp_service_communities(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2016_12_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_03_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_08_01.operations.BgpServiceCommunitiesOperations>`
        """
        if self.api_version == '2016-12-01':
            from .v2016_12_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def default_security_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.DefaultSecurityRulesOperations>`
           * 2017-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.DefaultSecurityRulesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def express_route_circuit_authorizations(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def express_route_circuit_peerings(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def express_route_circuits(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def express_route_service_providers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteServiceProvidersOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def inbound_nat_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_06_01.operations.InboundNatRulesOperations>`
           * 2017-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_08_01.operations.InboundNatRulesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import InboundNatRulesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import InboundNatRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancer_backend_address_pools(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancer_frontend_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancer_load_balancing_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancer_network_interfaces(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancer_probes(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerProbesOperations>`
           * 2017-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerProbesOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerProbesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def load_balancers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LoadBalancersOperations<azure.mgmt.network.v2015_06_15.operations.LoadBalancersOperations>`
           * 2016-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_09_01.operations.LoadBalancersOperations>`
           * 2016-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_12_01.operations.LoadBalancersOperations>`
           * 2017-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_03_01.operations.LoadBalancersOperations>`
           * 2017-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancersOperations>`
           * 2017-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancersOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import LoadBalancersOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import LoadBalancersOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import LoadBalancersOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import LoadBalancersOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancersOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def local_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.LocalNetworkGatewaysOperations>`
           * 2016-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2016-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.LocalNetworkGatewaysOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import LocalNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def network_interface_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def network_interface_load_balancers(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
        """
        if self.api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def network_interfaces(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2015_06_15.operations.NetworkInterfacesOperations>`
           * 2016-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_09_01.operations.NetworkInterfacesOperations>`
           * 2016-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_12_01.operations.NetworkInterfacesOperations>`
           * 2017-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_03_01.operations.NetworkInterfacesOperations>`
           * 2017-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfacesOperations>`
           * 2017-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfacesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkInterfacesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkInterfacesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkInterfacesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def network_security_groups(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2015_06_15.operations.NetworkSecurityGroupsOperations>`
           * 2016-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2016-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_12_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_03_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkSecurityGroupsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkSecurityGroupsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def network_watchers(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_09_01.operations.NetworkWatchersOperations>`
           * 2016-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_12_01.operations.NetworkWatchersOperations>`
           * 2017-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_03_01.operations.NetworkWatchersOperations>`
           * 2017-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkWatchersOperations>`
           * 2017-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkWatchersOperations>`
        """
        if self.api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkWatchersOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkWatchersOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkWatchersOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkWatchersOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkWatchersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def packet_captures(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_09_01.operations.PacketCapturesOperations>`
           * 2016-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_12_01.operations.PacketCapturesOperations>`
           * 2017-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_03_01.operations.PacketCapturesOperations>`
           * 2017-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_06_01.operations.PacketCapturesOperations>`
           * 2017-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_08_01.operations.PacketCapturesOperations>`
        """
        if self.api_version == '2016-09-01':
            from .v2016_09_01.operations import PacketCapturesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import PacketCapturesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import PacketCapturesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import PacketCapturesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import PacketCapturesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def public_ip_addresses(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2015_06_15.operations.PublicIPAddressesOperations>`
           * 2016-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_09_01.operations.PublicIPAddressesOperations>`
           * 2016-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_12_01.operations.PublicIPAddressesOperations>`
           * 2017-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_03_01.operations.PublicIPAddressesOperations>`
           * 2017-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_06_01.operations.PublicIPAddressesOperations>`
           * 2017-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_08_01.operations.PublicIPAddressesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import PublicIPAddressesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import PublicIPAddressesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import PublicIPAddressesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import PublicIPAddressesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def route_filter_rules(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2016_12_01.operations.RouteFilterRulesOperations>`
           * 2017-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_03_01.operations.RouteFilterRulesOperations>`
           * 2017-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_06_01.operations.RouteFilterRulesOperations>`
           * 2017-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_08_01.operations.RouteFilterRulesOperations>`
        """
        if self.api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFilterRulesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFilterRulesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFilterRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def route_filters(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2016_12_01.operations.RouteFiltersOperations>`
           * 2017-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_03_01.operations.RouteFiltersOperations>`
           * 2017-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_06_01.operations.RouteFiltersOperations>`
           * 2017-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_08_01.operations.RouteFiltersOperations>`
        """
        if self.api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFiltersOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFiltersOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFiltersOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFiltersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def route_tables(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RouteTablesOperations<azure.mgmt.network.v2015_06_15.operations.RouteTablesOperations>`
           * 2016-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_09_01.operations.RouteTablesOperations>`
           * 2016-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_12_01.operations.RouteTablesOperations>`
           * 2017-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_03_01.operations.RouteTablesOperations>`
           * 2017-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_06_01.operations.RouteTablesOperations>`
           * 2017-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_08_01.operations.RouteTablesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import RouteTablesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import RouteTablesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteTablesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteTablesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteTablesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteTablesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def routes(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RoutesOperations<azure.mgmt.network.v2015_06_15.operations.RoutesOperations>`
           * 2016-09-01: :class:`RoutesOperations<azure.mgmt.network.v2016_09_01.operations.RoutesOperations>`
           * 2016-12-01: :class:`RoutesOperations<azure.mgmt.network.v2016_12_01.operations.RoutesOperations>`
           * 2017-03-01: :class:`RoutesOperations<azure.mgmt.network.v2017_03_01.operations.RoutesOperations>`
           * 2017-06-01: :class:`RoutesOperations<azure.mgmt.network.v2017_06_01.operations.RoutesOperations>`
           * 2017-08-01: :class:`RoutesOperations<azure.mgmt.network.v2017_08_01.operations.RoutesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import RoutesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import RoutesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import RoutesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import RoutesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import RoutesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import RoutesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def security_rules(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SecurityRulesOperations<azure.mgmt.network.v2015_06_15.operations.SecurityRulesOperations>`
           * 2016-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_09_01.operations.SecurityRulesOperations>`
           * 2016-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_12_01.operations.SecurityRulesOperations>`
           * 2017-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_03_01.operations.SecurityRulesOperations>`
           * 2017-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.SecurityRulesOperations>`
           * 2017-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.SecurityRulesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import SecurityRulesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import SecurityRulesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import SecurityRulesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import SecurityRulesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import SecurityRulesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import SecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def subnets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SubnetsOperations<azure.mgmt.network.v2015_06_15.operations.SubnetsOperations>`
           * 2016-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_09_01.operations.SubnetsOperations>`
           * 2016-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_12_01.operations.SubnetsOperations>`
           * 2017-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_03_01.operations.SubnetsOperations>`
           * 2017-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_06_01.operations.SubnetsOperations>`
           * 2017-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_08_01.operations.SubnetsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import SubnetsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import SubnetsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import SubnetsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import SubnetsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import SubnetsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import SubnetsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def usages(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`UsagesOperations<azure.mgmt.network.v2015_06_15.operations.UsagesOperations>`
           * 2016-09-01: :class:`UsagesOperations<azure.mgmt.network.v2016_09_01.operations.UsagesOperations>`
           * 2016-12-01: :class:`UsagesOperations<azure.mgmt.network.v2016_12_01.operations.UsagesOperations>`
           * 2017-03-01: :class:`UsagesOperations<azure.mgmt.network.v2017_03_01.operations.UsagesOperations>`
           * 2017-06-01: :class:`UsagesOperations<azure.mgmt.network.v2017_06_01.operations.UsagesOperations>`
           * 2017-08-01: :class:`UsagesOperations<azure.mgmt.network.v2017_08_01.operations.UsagesOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import UsagesOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import UsagesOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import UsagesOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import UsagesOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import UsagesOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import UsagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_network_gateway_connections(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewaysOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewaysOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_network_peerings(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2016-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkPeeringsOperations>`
        """
        if self.api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_networks(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworksOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworksOperations>`
           * 2016-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworksOperations>`
           * 2016-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworksOperations>`
           * 2017-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworksOperations>`
           * 2017-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworksOperations>`
           * 2017-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworksOperations>`
        """
        if self.api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworksOperations as OperationClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworksOperations as OperationClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworksOperations as OperationClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworksOperations as OperationClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworksOperations as OperationClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)
