.\"
.\" %nmhwarning%
.\"
.TH BURST %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
burst \- explode digests into messages
.SH SYNOPSIS
.HP 5
.na
.B burst
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-inplace " | " \-noinplace ]
.RB [ \-quiet " | " \-noquiet ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Burst
considers the specified messages in the named folder to be
Internet digests, and explodes them in that folder.
.PP
If
.B \-inplace
is given, each digest is replaced by the \*(lqtable
of contents\*(rq for the digest (the original digest is removed).
.B Burst
then renumbers all of the messages following the digest in the
folder to make room for each of the messages contained within the digest.
These messages are placed immediately after the digest.
.PP
If
.B \-noinplace
is given, each digest is preserved, no table of contents
is produced, and the messages contained within the digest are placed at
the end of the folder.  Other messages are not tampered with in any way.
.PP
The
.B \-quiet
switch directs
.B burst
to be silent about reporting
messages that are not in digest format.
.PP
The
.B \-verbose
switch directs
.B burst
to tell the user the general
actions that it is taking to explode the digest.
.PP
It turns out that
.B burst
works equally well on forwarded messages
and blind\-carbon\-copies as on Internet digests, provided that the
former two were generated by
.B forw
or
.BR send .

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^Msg\-Protect:~^To set mode when creating a new message
.fi

.SH "SEE ALSO"
inc(1), msh(1), pack(1),
.I "Proposed Standard for Message Encapsulation"
(RFC\-934)

.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to cur"
.RB ` \-noinplace '
.RB ` \-noquiet '
.RB ` \-noverbose '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  If
.B \-inplace
is given, then the first message burst becomes the current message.
This leaves the context ready for a
.B show
of the table of contents
of the digest, and a
.B next
to see the first message of the digest. If
.B \-noinplace
is given, then the first message extracted from the
first digest burst becomes the current message.  This leaves the context
in a similar, but not identical, state to the context achieved when using
.BR \-inplace .

.SH BUGS
The
.B burst
program enforces a limit on the number of messages which
may be
.B burst
from a single message.  This number is on the order
of 1000 messages.  There is usually no limit on the number of messages
which may reside in the folder after the
.BR burst ing.
.PP
Although
.B burst
uses a sophisticated algorithm to determine where
one encapsulated message ends and another begins, not all digestifying
programs use an encapsulation algorithm.  In degenerate cases, this
usually results in
.B burst
finding an encapsulation boundary
prematurely and splitting a single encapsulated message into two or
more messages.  These erroneous digestifying programs should be fixed.
.PP
Furthermore, any text which appears after the last encapsulated message
is not placed in a separate message by
.BR burst .
In the case of
digestified messages, this text is usually an \*(lqEnd of digest\*(rq
string.  As a result of this possibly un\-friendly behavior on the
part of
.BR burst ,
note that when the
.B \-inplace
option is used,
this trailing information is lost.  In practice, this is not a problem
since correspondents usually place remarks in text prior to the first
encapsulated message, and this information is not lost.
