
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file FlagPlottingAttributes.h
    \\brief Definition of FlagPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "FlagPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

FlagPlottingAttributes::FlagPlottingAttributes():
	calm_indicator_size_(ParameterManager::getDouble("wind_flag_calm_indicator_size")),
	calm_below_(ParameterManager::getDouble("wind_flag_calm_below")),
	cross_boundary_(ParameterManager::getBool("wind_flag_cross_boundary")),
	length_(ParameterManager::getDouble("wind_flag_length")),
	max_speed_(ParameterManager::getDouble("wind_flag_max_speed")),
	min_speed_(ParameterManager::getDouble("wind_flag_min_speed")),
	origin_marker_size_(ParameterManager::getDouble("wind_flag_origin_marker_size")),
	thickness_(ParameterManager::getInt("wind_flag_thickness"))
	,
	calm_(MagTranslator<string, CalmIndicator>().magics("wind_flag_calm_indicator")),
	colour_(MagTranslator<string, Colour>().magics("wind_flag_colour")),
	style_(MagTranslator<string, LineStyle>().magics("wind_flag_style")),
	origin_(MagTranslator<string, OriginMarker>().magics("wind_flag_origin_marker"))
	
{
}


FlagPlottingAttributes::~FlagPlottingAttributes()
{

}


void FlagPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "wind";
	prefix[i++] = "wind_flag";
	
	setAttribute(prefix, "wind_flag_calm_indicator_size", calm_indicator_size_, params);
	setAttribute(prefix, "wind_flag_calm_below", calm_below_, params);
	setAttribute(prefix, "wind_flag_cross_boundary", cross_boundary_, params);
	setAttribute(prefix, "wind_flag_length", length_, params);
	setAttribute(prefix, "wind_flag_max_speed", max_speed_, params);
	setAttribute(prefix, "wind_flag_min_speed", min_speed_, params);
	setAttribute(prefix, "wind_flag_origin_marker_size", origin_marker_size_, params);
	setAttribute(prefix, "wind_flag_thickness", thickness_, params);
	
	setMember(prefix, "wind_flag_calm_indicator", calm_, params);
	setMember(prefix, "wind_flag_colour", colour_, params);
	setAttribute(prefix, "wind_flag_style", style_, params);
	setMember(prefix, "wind_flag_origin_marker", origin_, params);
	
}

void FlagPlottingAttributes::copy(const FlagPlottingAttributes& other)
{
	calm_indicator_size_ = other.calm_indicator_size_;
	calm_below_ = other.calm_below_;
	cross_boundary_ = other.cross_boundary_;
	length_ = other.length_;
	max_speed_ = other.max_speed_;
	min_speed_ = other.min_speed_;
	origin_marker_size_ = other.origin_marker_size_;
	thickness_ = other.thickness_;
	calm_ = unique_ptr<CalmIndicator>(other.calm_->clone());
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	style_ = other.style_;
	origin_ = unique_ptr<OriginMarker>(other.origin_->clone());
	
}


bool FlagPlottingAttributes::accept(const string& node)
{

	if ( magCompare(node, "flags")  )
		return true;
	if ( acceptNode(node, calm_) )
		return true;
	if ( acceptNode(node, origin_) )
		return true;
	
	return false;
}

void FlagPlottingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "flags")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), calm_, node);
		setMember(node.name(), origin_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), calm_, *elt);
		setMember(elt->name(), origin_, *elt);
		
	}
}

void FlagPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " calm_indicator_size = " <<  calm_indicator_size_;
	out << " calm_below = " <<  calm_below_;
	out << " cross_boundary = " <<  cross_boundary_;
	out << " length = " <<  length_;
	out << " max_speed = " <<  max_speed_;
	out << " min_speed = " <<  min_speed_;
	out << " origin_marker_size = " <<  origin_marker_size_;
	out << " thickness = " <<  thickness_;
	out << " calm = " <<  *calm_;
	out << " colour = " <<  *colour_;
	out << " style = " <<  style_;
	out << " origin = " <<  *origin_;
	
	out << "]" << "\n";
}

void FlagPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"flags\"";
	out << ", \"wind_flag_calm_indicator_size\":";
	niceprint(out,calm_indicator_size_);
	out << ", \"wind_flag_calm_below\":";
	niceprint(out,calm_below_);
	out << ", \"wind_flag_cross_boundary\":";
	niceprint(out,cross_boundary_);
	out << ", \"wind_flag_length\":";
	niceprint(out,length_);
	out << ", \"wind_flag_max_speed\":";
	niceprint(out,max_speed_);
	out << ", \"wind_flag_min_speed\":";
	niceprint(out,min_speed_);
	out << ", \"wind_flag_origin_marker_size\":";
	niceprint(out,origin_marker_size_);
	out << ", \"wind_flag_thickness\":";
	niceprint(out,thickness_);
	out << ", \"wind_flag_calm_indicator\":";
	calm_->toxml(out);
	out << ", \"wind_flag_colour\":";
	niceprint(out, *colour_);
	out << ", \"wind_flag_style\":";
	niceprint(out, style_);
	out << ", \"wind_flag_origin_marker\":";
	origin_->toxml(out);
	
}

static MagicsParameter<double> wind_flag_calm_indicator_size("wind_flag_calm_indicator_size", 0.3);
static MagicsParameter<double> wind_flag_calm_below("wind_flag_calm_below", 0.5);
static MagicsParameter<string> wind_flag_cross_boundary("wind_flag_cross_boundary", "on");
static MagicsParameter<double> wind_flag_length("wind_flag_length", 1.0);
static MagicsParameter<double> wind_flag_max_speed("wind_flag_max_speed", 1.0e+21);
static MagicsParameter<double> wind_flag_min_speed("wind_flag_min_speed", -1.0e+21);
static MagicsParameter<double> wind_flag_origin_marker_size("wind_flag_origin_marker_size", 0.3);
static MagicsParameter<int> wind_flag_thickness("wind_flag_thickness", 1);
static MagicsParameter<string> wind_flag_calm_indicator("wind_flag_calm_indicator", "on");
static MagicsParameter<string> wind_flag_colour("wind_flag_colour", "blue");
static MagicsParameter<string> wind_flag_style("wind_flag_style", "solid");
static MagicsParameter<string> wind_flag_origin_marker("wind_flag_origin_marker", "circle");
#include "CalmIndicator.h"
#include "OriginMarker.h"
static SimpleObjectMaker<CalmIndicator , CalmIndicator> calm_CalmIndicator("calm");
static SimpleObjectMaker<CalmIndicator , CalmIndicator> on_CalmIndicator("on");
static SimpleObjectMaker<NoCalmIndicator , CalmIndicator> nocalm_NoCalmIndicator("nocalm");
static SimpleObjectMaker<NoCalmIndicator , CalmIndicator> off_NoCalmIndicator("off");
static SimpleObjectMaker<DotOriginMarker , OriginMarker> dotmarker_DotOriginMarker("dotmarker");
static SimpleObjectMaker<DotOriginMarker , OriginMarker> dot_DotOriginMarker("dot");
static SimpleObjectMaker<CircleOriginMarker , OriginMarker> circlemarker_CircleOriginMarker("circlemarker");
static SimpleObjectMaker<CircleOriginMarker , OriginMarker> circle_CircleOriginMarker("circle");
static SimpleObjectMaker<NoOriginMarker , OriginMarker> nomarker_NoOriginMarker("nomarker");
static SimpleObjectMaker<NoOriginMarker , OriginMarker> off_NoOriginMarker("off");
