/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.qa.form;

import org.netbeans.jemmy.operators.*;

/**
 * Class implementing all necessary methods for handling "Palette Manager" NbDialog.
 * Most parts of code are generated by jelly tools.* 
 *
 * @author Jiri Vagner
 */
public class PaletteManagerOperator extends JDialogOperator {

    /** Creates new PaletteManager that can handle it.
     */
    public PaletteManagerOperator() {
        super("Palette Manager"); // NOI18N
    }

    private JLabelOperator _lblPaletteContent;
    private JTreeOperator _treePaletteContentsTree;
    private JLabelOperator _lblJLabel;
    private JButtonOperator _btMoveUp;
    private JButtonOperator _btMoveDown;
    private JButtonOperator _btRemove;
    private JButtonOperator _btNewCategory;
    private JButtonOperator _btAddFromJAR;
    private JButtonOperator _btAddFromLibrary;
    private JButtonOperator _btAddFromProject;
    private JButtonOperator _btResetPalette;
    private JButtonOperator _btClose;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Palette Content:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblPaletteContent() {
        if (_lblPaletteContent==null) {
            _lblPaletteContent = new JLabelOperator(this, "Palette Content:"); // NOI18N
        }
        return _lblPaletteContent;
    }

    /** Tries to find null TreeView$ExplorerTree in this dialog.
     * @return JTreeOperator
     */
    public JTreeOperator treePaletteContentsTree() {
        if (_treePaletteContentsTree==null) {
            _treePaletteContentsTree = new JTreeOperator(this);
        }
        return _treePaletteContentsTree;
    }

    /** Tries to find " " JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblJLabel() {
        if (_lblJLabel==null) {
            _lblJLabel = new JLabelOperator(this, " ", 1); // NOI18N
        }
        return _lblJLabel;
    }

    /** Tries to find "Move Up" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btMoveUp() {
        if (_btMoveUp==null) {
            _btMoveUp = new JButtonOperator(this, "Move Up"); // NOI18N
        }
        return _btMoveUp;
    }

    /** Tries to find "Move Down" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btMoveDown() {
        if (_btMoveDown==null) {
            _btMoveDown = new JButtonOperator(this, "Move Down"); // NOI18N
        }
        return _btMoveDown;
    }

    /** Tries to find "Remove..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btRemove() {
        if (_btRemove==null) {
            _btRemove = new JButtonOperator(this, "Remove..."); // NOI18N
        }
        return _btRemove;
    }

    /** Tries to find "New Category..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btNewCategory() {
        if (_btNewCategory==null) {
            _btNewCategory = new JButtonOperator(this, "New Category..."); // NOI18N
        }
        return _btNewCategory;
    }

    /** Tries to find "Add from JAR..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromJAR() {
        if (_btAddFromJAR==null) {
            _btAddFromJAR = new JButtonOperator(this, "Add from JAR..."); // NOI18N
        }
        return _btAddFromJAR;
    }

    /** Tries to find "Add from Library..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromLibrary() {
        if (_btAddFromLibrary==null) {
            _btAddFromLibrary = new JButtonOperator(this, "Add from Library..."); // NOI18N
        }
        return _btAddFromLibrary;
    }

    /** Tries to find "Add from Project..." JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btAddFromProject() {
        if (_btAddFromProject==null) {
            _btAddFromProject = new JButtonOperator(this, "Add from Project..."); // NOI18N
        }
        return _btAddFromProject;
    }

    /** Tries to find "Reset Palette" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btResetPalette() {
        if (_btResetPalette==null) {
            _btResetPalette = new JButtonOperator(this, "Reset Palette"); // NOI18N
        }
        return _btResetPalette;
    }

    /** Tries to find "Close" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btClose() {
        if (_btClose==null) {
            _btClose = new JButtonOperator(this, "Close"); // NOI18N
        }
        return _btClose;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** clicks on "Move Up" JButton
     */
    public void moveUp() {
        btMoveUp().push();
    }

    /** clicks on "Move Down" JButton
     */
    public void moveDown() {
        btMoveDown().push();
    }

    /** clicks on "Remove..." JButton
     */
    public void remove() {
        btRemove().push();
    }

    /** clicks on "New Category..." JButton
     */
    public void newCategory() {
        btNewCategory().push();
    }

    /** clicks on "Add from JAR..." JButton
     */
    public void addFromJAR() {
        btAddFromJAR().push();
    }

    /** clicks on "Add from Library..." JButton
     */
    public void addFromLibrary() {
        btAddFromLibrary().push();
    }

    /** clicks on "Add from Project..." JButton
     */
    public void addFromProject() {
        btAddFromProject().push();
    }

    /** clicks on "Reset Palette" JButton
     */
    public void resetPalette() {
        btResetPalette().push();
    }

    /** clicks on "Close" JButton
     */
    public void close() {
        btClose().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of PaletteManager by accessing all its components.
     */
    public void verify() {
        lblPaletteContent();
        treePaletteContentsTree();
        lblJLabel();
        btMoveUp();
        btMoveDown();
        btRemove();
        btNewCategory();
        btAddFromJAR();
        btAddFromLibrary();
        btAddFromProject();
        btResetPalette();
        btClose();
    }
}

