 typedef enum {
  Element, Text, Comment, Declaration, Procins, Root
} Nodetype;
 typedef struct _node {
  Nodetype tp;
  string name;
  pairlist attribs;
  string text;
  string url;
  struct _node *parent;
  struct _node *sister;
  struct _node *children;
} Node, *Tree;
 Tree create(void);
 void tree_delete(Tree t);
 Tree get_root(Tree t);
 conststring get_attrib(const Node *e, const conststring attname);
 void set_attrib(Node *e, string name, conststring value);
 _Bool delete_attrib(Node *e, const conststring name);
 Tree get_elt_by_id(Node *n, const conststring id);
 Tree wrap_contents(Node *n, const string elem, pairlist attr);
 Tree wrap_elt(Node *n, const conststring elem, pairlist attr);
 void rename_elt(Node *n, const string elem);
 _Bool is_known(const string e);
 _Bool is_pre(const string e);
 _Bool need_stag(const string e);
 _Bool need_etag(const string e);
 _Bool is_empty(const string e);
 _Bool has_parent(const string c, const string p);
 _Bool is_mixed(const string e);
 _Bool break_before(const string e);
 _Bool break_after(const string e);
 Tree tree_push(Tree t, string elem, pairlist attr);
 Tree html_push(Tree t, string elem, pairlist attr);
 Tree tree_pop(Tree t, string elem);
 Tree html_pop(Tree t, string elem);
 Tree append_comment(Tree t, string comment);
 Tree append_declaration(Tree t, string gi,
          string fpi, string url);
 Tree append_procins(Tree t, string procins);
 Tree tree_append_text(Tree t, string text);
 Tree append_text(Tree t, string text);
 void dumptree(Tree t);
