/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.transforms.implementations;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.test.TestUtils;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class TransformBase64DecodeTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest == null ? (class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest = TransformBase64DecodeTest.class$("org.apache.xml.security.test.transforms.implementations.TransformBase64DecodeTest")) : class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest).getName());
    static /* synthetic */ Class class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest == null ? (class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest = TransformBase64DecodeTest.class$("org.apache.xml.security.test.transforms.implementations.TransformBase64DecodeTest")) : class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest);
    }

    public TransformBase64DecodeTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest == null ? (class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest = TransformBase64DecodeTest.class$("org.apache.xml.security.test.transforms.implementations.TransformBase64DecodeTest")) : class$org$apache$xml$security$test$transforms$implementations$TransformBase64DecodeTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        if (document == null) {
            throw new RuntimeException("Could not create a Document");
        }
        log.debug((Object)"I could create the Document");
        return document;
    }

    public static void test1() throws IOException, InvalidTransformException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, XMLSignatureException, XMLSecurityException, ParserConfigurationException {
        String string = "VGhlIFVSSSBvZiB0aGUgdHJhbnNmb3JtIGlzIGh0dHA6Ly93d3cudzMub3JnLzIwMDAvMDkveG1s\nZHNpZyNiYXNlNjQ=";
        Document document = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document);
        document.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)new ByteArrayInputStream(string.getBytes()));
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput);
        String string2 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((boolean)string2.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    public static void test2() throws IOException, InvalidTransformException, TransformationException, CanonicalizationException, InvalidCanonicalizerException, XMLSignatureException, XMLSecurityException, ParserConfigurationException {
        String string = "VkdobElGVlNTU0J2WmlCMGFHVWdkSEpoYm5ObWIzSnRJR2x6SUdoMGRIQTZMeTkzZDNjdWR6TXVi\nM0puTHpJd01EQXZNRGt2ZUcxcwpaSE5wWnlOaVlYTmxOalE9";
        Document document = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document);
        document.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((InputStream)new ByteArrayInputStream(string.getBytes()));
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(transforms.performTransforms(xMLSignatureInput));
        String string2 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((boolean)string2.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    public static void test3() throws Exception {
        String string = "<Object xmlns:signature='http://www.w3.org/2000/09/xmldsig#'>\n<signature:Base64>\nVGhlIFVSSSBvZiB0aGU   gdHJhbn<RealText>Nmb  3JtIGlzIG<test/>h0dHA6</RealText>Ly93d3cudzMub3JnLzIwMDAvMDkveG1s\nZHNpZyNiYXNlNjQ=\n</signature:Base64>\n</Object>\n";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        Element element = TestUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Node node = XPathAPI.selectSingleNode((Node)document, (String)"//ds:Base64", (Node)element);
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(node);
        Document document2 = TransformBase64DecodeTest.createDocument();
        Transforms transforms = new Transforms(document2);
        document2.appendChild(transforms.getElement());
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
        XMLSignatureInput xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput);
        String string2 = new String(xMLSignatureInput2.getBytes());
        TransformBase64DecodeTest.assertTrue((String)("\"" + string2 + "\""), (boolean)string2.equals("The URI of the transform is http://www.w3.org/2000/09/xmldsig#base64"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

