/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CClassFiltersDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/ClassFiltersXml.h"

using namespace Caf;

void ClassFiltersXml::add(
	const SmartPtrCClassFiltersDoc classFiltersDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassFiltersXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(classFiltersDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string dialectVal = classFiltersDoc->getDialect();
		CAF_CM_VALIDATE_STRING(dialectVal);
		thisXml->addAttribute("dialect", dialectVal);

		const std::deque<std::string> classFilterVal =
			classFiltersDoc->getClassFilter();
		CAF_CM_VALIDATE_STL(classFilterVal);

		if (! classFilterVal.empty()) {
			for (TConstIterator<std::deque<std::string> > classFilterIter(classFilterVal);
				classFilterIter; classFilterIter++) {
				const SmartPtrCXmlElement classFilterXml =
					thisXml->createAndAddElement("classFilter");
				classFilterXml->setValue(*classFilterIter);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCClassFiltersDoc ClassFiltersXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ClassFiltersXml", "parse");

	SmartPtrCClassFiltersDoc classFiltersDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string dialectStrVal =
			thisXml->findRequiredAttribute("dialect");
		const std::string dialectVal = dialectStrVal;

		const CXmlElement::SmartPtrCElementCollection classFilterChildrenXml =
			thisXml->findRequiredChildren("classFilter");

		std::deque<std::string> classFilterVal;
		if (! classFilterChildrenXml.IsNull() && ! classFilterChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> classFilterXmlIter(*classFilterChildrenXml);
				classFilterXmlIter; classFilterXmlIter++) {
				const SmartPtrCXmlElement classFilterXml = classFilterXmlIter->second;
				const std::string classFilterDoc = classFilterXml->getValue();
				classFilterVal.push_back(classFilterDoc);
			}
		}

		classFiltersDoc.CreateInstance();
		classFiltersDoc->initialize(
			dialectVal,
			classFilterVal);
	}
	CAF_CM_EXIT;

	return classFiltersDoc;
}

