/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import org.xml.sax.Attributes;

public final class AttributeCollection
implements Attributes {
    private NamePool namePool;
    private Object[] list = null;
    private int used = 0;
    private static int RECSIZE = 3;
    private static int NAMECODE = 0;
    private static int TYPE = 1;
    private static int VALUE = 2;

    public AttributeCollection(NamePool namePool) {
        this.namePool = namePool;
        this.list = null;
        this.used = 0;
    }

    public void addAttribute(int n, String string, String string2) {
        if (this.list == null) {
            this.list = new Object[5 * RECSIZE];
            this.used = 0;
        }
        if (this.list.length == this.used) {
            int n2 = this.used == 0 ? 5 * RECSIZE : this.used * 2;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.list, 0, objectArray, 0, this.used);
            this.list = objectArray;
        }
        this.list[this.used++] = new Integer(n);
        this.list[this.used++] = string;
        this.list[this.used++] = string2;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.list = null;
        } else if (this.list.length > this.used) {
            Object[] objectArray = new Object[this.used];
            System.arraycopy(this.list, 0, objectArray, 0, this.used);
            this.list = objectArray;
        }
    }

    public int getLength() {
        return this.list == null ? 0 : this.used / RECSIZE;
    }

    public int getNameCode(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return -1;
        }
        if (n2 >= this.used) {
            return -1;
        }
        return (Integer)this.list[n2 + NAMECODE];
    }

    public String getQName(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return this.namePool.getDisplayName(this.getNameCode(n));
    }

    public String getLocalName(int n) {
        if (this.list == null) {
            return null;
        }
        if (n * RECSIZE >= this.used) {
            return null;
        }
        return this.namePool.getLocalName(this.getNameCode(n));
    }

    public String getURI(int n) {
        if (this.list == null) {
            return null;
        }
        if (n * RECSIZE >= this.used) {
            return null;
        }
        return this.namePool.getURI(this.getNameCode(n));
    }

    public String getType(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return (String)this.list[n2 + TYPE];
    }

    public String getType(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : (String)this.list[n + TYPE];
    }

    public String getValue(int n) {
        int n2 = n * RECSIZE;
        if (this.list == null) {
            return null;
        }
        if (n2 >= this.used) {
            return null;
        }
        return (String)this.list[n2 + VALUE];
    }

    public String getValue(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : (String)this.list[n + VALUE];
    }

    public String getValueByFingerprint(int n) {
        int n2 = this.findByFingerprint(n);
        return n2 < 0 ? null : (String)this.list[n2 + VALUE];
    }

    public int getIndex(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? -1 : n / RECSIZE;
    }

    public int getIndex(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? -1 : n / RECSIZE;
    }

    public int getIndexByFingerprint(int n) {
        int n2 = this.findByFingerprint(n);
        return n2 < 0 ? -1 : n2 / RECSIZE;
    }

    public String getType(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : (String)this.list[n + TYPE];
    }

    public String getValue(String string) {
        int n = this.findByDisplayName(string);
        return n < 0 ? null : (String)this.list[n + VALUE];
    }

    private int findByName(String string, String string2) {
        if (this.namePool == null) {
            return -1;
        }
        int n = this.namePool.getFingerprint(string, string2);
        if (n == -1) {
            return -1;
        }
        return this.findByFingerprint(n);
    }

    private int findByFingerprint(int n) {
        if (this.list == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.used) {
            if (n == ((Integer)this.list[n2 + NAMECODE] & 0xFFFFF)) {
                return n2;
            }
            n2 += RECSIZE;
        }
        return -1;
    }

    private int findByDisplayName(String string) {
        String[] stringArray;
        if (this.list == null) {
            return -1;
        }
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            return -1;
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            return this.findByName("", string);
        }
        String string3 = stringArray[1];
        int n = 0;
        while (n < this.getLength()) {
            String string4 = this.namePool.getLocalName(this.getNameCode(n));
            String string5 = this.namePool.getPrefix(this.getNameCode(n));
            if (string3.equals(string4) && string2.equals(string5)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

