/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.Collator;
import java.util.Comparator;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class XSLForEachGroup
extends StyleElement {
    private Expression select = null;
    private Expression groupBy = null;
    private Expression groupAdjacent = null;
    private Pattern starting = null;
    private Pattern ending = null;
    private String collationName;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "select") {
                string = attributeCollection.getValue(n2);
            } else if (string6 == "group-by") {
                string2 = attributeCollection.getValue(n2);
            } else if (string6 == "group-adjacent") {
                string3 = attributeCollection.getValue(n2);
            } else if (string6 == "group-starting-with") {
                string4 = attributeCollection.getValue(n2);
            } else if (string6 == "group-ending-with") {
                string5 = attributeCollection.getValue(n2);
            } else if (string6 == "collation") {
                this.collationName = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
        n = (string2 == null ? 0 : 1) + (string3 == null ? 0 : 1) + (string4 == null ? 0 : 1) + (string5 == null ? 0 : 1);
        if (n != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified");
        }
        if (string2 != null) {
            this.groupBy = this.makeExpression(string2);
        }
        if (string3 != null) {
            this.groupAdjacent = this.makeExpression(string3);
        }
        if (string4 != null) {
            this.starting = this.makePattern(string4);
        }
        if (string5 != null) {
            this.ending = this.makePattern(string5);
        }
        if (this.collationName != null && this.groupBy == null) {
            this.compileError("A collation may be specified only if group-by or group-adjacent is specified");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.select = this.typeCheck("select", this.select);
        if (this.groupBy != null) {
            this.groupBy = this.typeCheck("group-by", this.groupBy);
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:for-each-group/group-by", 0);
                this.groupBy = TypeChecker.staticTypeCheck(this.groupBy, SequenceType.ATOMIC_SEQUENCE, false, roleLocator);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (this.groupAdjacent != null) {
            this.groupAdjacent = this.typeCheck("group-adjacent", this.groupAdjacent);
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:for-each-group/group-adjacent", 0);
                this.groupAdjacent = TypeChecker.staticTypeCheck(this.groupAdjacent, SequenceType.SINGLE_ATOMIC, false, roleLocator);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.starting = this.typeCheck("starting", this.starting);
        this.ending = this.typeCheck("ending", this.ending);
    }

    public ItemType getContextItemType() {
        return this.select.getItemType();
    }

    public Instruction compile() throws TransformerConfigurationException {
        Collator collator = null;
        if (this.collationName != null) {
            Comparator comparator = this.getPrincipalStyleSheet().findCollation(this.collationName);
            if (comparator == null) {
                this.compileError("The collation name '" + this.collationName + "' has not been defined");
            }
            if (!(comparator instanceof Collator)) {
                this.compileError("The collation used for xsl:for-each-group must be a java.text.Collator");
            }
            collator = (Collator)comparator;
        }
        byte by = 0;
        Object object = null;
        if (this.groupBy != null) {
            by = 0;
            object = this.groupBy;
        } else if (this.groupAdjacent != null) {
            by = 1;
            object = this.groupAdjacent;
        } else if (this.starting != null) {
            by = 2;
            object = this.starting;
        } else if (this.ending != null) {
            by = 3;
            object = this.ending;
        }
        ForEachGroup forEachGroup = new ForEachGroup(this.select, by, object, collator, this.makeSortKeys());
        this.compileChildren(forEachGroup);
        return forEachGroup;
    }
}

