/*
 * Decompiled with CFR 0.152.
 */
package ari.ucidy;

import ari.ucidy.UCDSyntax;
import ari.ucidy.UCDWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;

public class UCD
implements Iterable<UCDWord> {
    protected final UCDWord[] words;
    protected String strRepresentation = null;
    protected Boolean allValid = null;
    protected Boolean allRecognised = null;
    protected Boolean allRecommended = null;
    protected Boolean fullyValid = null;
    protected boolean alreadyHasSuggestion = false;
    protected UCD suggestion = null;
    protected String[] errors = null;
    protected String[] advice = null;
    protected UCDWord[] deprecatedWords = null;
    protected static String REGEXP_EM = "em\\..+";
    protected static String REGEXP_AXIS_FRAME = "(pos\\.az(\\.(alt|azi|zd))?|pos\\.bodyrc(\\.(alt|lat|long))?|pos\\.cartesian(\\.(x|y|z))?|pos\\.cmb|pos\\.earth(\\.(altitude|lat|lon))?|pos\\.ecliptic(\\.(alt|lon))?|pos\\.eq(\\.(dec|ha|ra|spd))?|pos\\.galactic(\\.(lat|lon))?|pos\\.lg|pos\\.lsr|pos\\.lunar|pos\\.supergalactic(\\.(lat|lon))?)";

    public UCD(Collection<UCDWord> words) throws NullPointerException {
        this(words.toArray(new UCDWord[words.size()]));
    }

    public UCD(UCDWord[] words) throws NullPointerException {
        if (words == null || words.length == 0) {
            throw new NullPointerException("Impossible to create a null UCD!");
        }
        this.words = words;
    }

    protected void checkAllWords() {
        boolean tempValid = true;
        boolean tempRecognised = true;
        boolean tempRecommended = true;
        for (UCDWord w : this.words) {
            if (w == null) {
                this.allValid = false;
                this.allRecognised = false;
                this.allRecommended = false;
                return;
            }
            tempValid = tempValid && w.valid;
            tempRecognised = tempRecognised && w.recognised;
            tempRecommended = tempRecommended && w.recommended;
        }
        this.allValid = tempValid;
        this.allRecognised = tempRecognised;
        this.allRecommended = tempRecommended;
    }

    public final boolean isAllValid() {
        if (this.allValid == null) {
            this.checkAllWords();
        }
        return this.allValid;
    }

    public final boolean isAllRecognised() {
        if (this.allRecognised == null) {
            this.checkAllWords();
        }
        return this.allRecognised;
    }

    public final boolean isAllRecommended() {
        if (this.allRecommended == null) {
            this.checkAllWords();
        }
        return this.allRecommended;
    }

    protected void checkFullValidity() {
        if (!this.isAllRecognised()) {
            this.fullyValid = false;
            return;
        }
        if (this.words[0].syntaxCode == UCDSyntax.SECONDARY) {
            this.fullyValid = false;
            return;
        }
        for (int i = 1; i < this.words.length; ++i) {
            if (this.words[i].syntaxCode != UCDSyntax.PRIMARY) continue;
            this.fullyValid = false;
            return;
        }
        this.fullyValid = true;
    }

    public final boolean isFullyValid() {
        if (this.fullyValid == null) {
            this.checkFullValidity();
        }
        return this.fullyValid;
    }

    protected void listErrors() {
        boolean first = true;
        int nbEmptyWords = 0;
        int nbDeprecated = 0;
        int nbNotValid = 0;
        int nbNotRecognised = 0;
        int nbLatePrimary = 0;
        String firstPrimary = null;
        StringBuffer deprecated = new StringBuffer();
        StringBuffer notValid = new StringBuffer();
        StringBuffer notRecognised = new StringBuffer();
        StringBuffer latePrimary = new StringBuffer();
        StringBuffer lstClosest = new StringBuffer();
        ArrayList<String> lstErrors = new ArrayList<String>();
        for (UCDWord w : this.words) {
            if (w == null || w.word.trim().length() == 0) {
                nbEmptyWords = (short)(nbEmptyWords + 1);
            } else if (w.isDeprecated()) {
                nbDeprecated = (short)(nbDeprecated + 1);
                this.append(deprecated, w.rawWord + " (-> " + w.suggestedReplacement + ")");
            } else {
                if (!w.valid) {
                    nbNotValid = (short)(nbNotValid + 1);
                    this.append(notValid, w.rawWord);
                }
                if (w.syntaxCode == null) {
                    nbNotRecognised = (short)(nbNotRecognised + 1);
                    this.append(notRecognised, w.rawWord);
                    if (w.closest != null) {
                        lstClosest.delete(0, lstClosest.length());
                        for (UCDWord closeWord : w.closest) {
                            this.append(lstClosest, closeWord.rawWord);
                        }
                        notRecognised.append(" (closest: " + lstClosest.toString() + ")");
                    }
                } else if (first && w.syntaxCode == UCDSyntax.SECONDARY) {
                    lstErrors.add("UCD starting with a SECONDARY UCD word: \"" + w + "\"! Such words can NOT be in first position.");
                } else if (w.syntaxCode == UCDSyntax.PRIMARY) {
                    if (first) {
                        firstPrimary = w.rawWord;
                    } else {
                        nbLatePrimary = (short)(nbLatePrimary + 1);
                        this.append(latePrimary, w.rawWord);
                    }
                }
            }
            first = false;
        }
        if (nbLatePrimary > 0) {
            lstErrors.add(0, nbLatePrimary + " PRIMARY UCD word" + (nbLatePrimary > 1 ? "s" : "") + " not in first position: " + latePrimary.toString() + "! Such words MUST be in first position.");
            if (firstPrimary != null || nbLatePrimary > 1) {
                lstErrors.add(0, "Too many (" + (nbLatePrimary + (firstPrimary != null ? 1 : 0)) + ") PRIMARY UCD words: " + (firstPrimary != null ? "\"" + firstPrimary + "\", " : "") + latePrimary + "! Only one is allowed in a UCD.");
            }
        }
        if (nbNotRecognised > 0) {
            lstErrors.add(0, nbNotRecognised + " not recognised UCD word" + (nbNotRecognised > 1 ? "s" : "") + ": " + notRecognised.toString() + "!");
        }
        if (nbNotValid > 0) {
            lstErrors.add(0, "Wrong syntax for " + nbNotValid + " UCD word" + (nbNotValid > 1 ? "s" : "") + ": " + notValid.toString() + "!");
        }
        if (nbDeprecated > 0) {
            lstErrors.add(0, nbDeprecated + " DEPRECATED UCD word" + (nbDeprecated > 1 ? "s" : "") + ": " + deprecated.toString() + "!");
        }
        if (nbEmptyWords > 0) {
            lstErrors.add(0, nbEmptyWords + " empty UCD word" + (nbEmptyWords > 1 ? "s" : "") + "!");
        }
        this.errors = lstErrors.toArray(new String[lstErrors.size()]);
    }

    protected final void append(StringBuffer buf, String word) {
        if (buf == null || word == null || word.trim().length() == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append('\"').append(word).append('\"');
    }

    public final Iterator<String> getErrors() {
        if (this.errors == null) {
            this.listErrors();
        }
        return new ErrorsIterator();
    }

    protected void listAdvice() {
        ArrayList<String> lstAdvice = new ArrayList<String>();
        LinkedHashSet<UCDWord> duplicated = new LinkedHashSet<UCDWord>();
        for (int i = 0; i < this.words.length; ++i) {
            if (duplicated.contains(this.words[i])) continue;
            for (int j = i + 1; j < this.words.length; ++j) {
                if (this.words[i] == null || !this.words[i].equals(this.words[j])) continue;
                duplicated.add(this.words[i]);
            }
        }
        if (duplicated.size() > 0) {
            lstAdvice.add("For more readability, you should remove duplicated UCD words: " + this.concat(duplicated) + ".");
        }
        LinkedHashSet<UCDWord> candidatesEM = this.searchByPattern(REGEXP_EM);
        LinkedHashSet<UCDWord> candidatesAxisFrame = this.searchByPattern(REGEXP_AXIS_FRAME);
        String candidatesEM_str = this.concat(candidatesEM);
        String candidatesAxisFrame_str = this.concat(candidatesAxisFrame);
        duplicated.clear();
        block7: for (int i = 0; i < this.words.length; ++i) {
            UCDWord curr = this.words[i];
            if (curr == null || curr.syntaxCode == null || !duplicated.add(curr)) continue;
            if (curr.namespace != null && curr.recommended && curr.namespace.equalsIgnoreCase("ivoa")) {
                lstAdvice.add("\"" + curr + "\" is a UCD word recommended by the IVOA. The use of the explicit namespace \"ivoa\" should be avoided for more readability. So you should rather write: \"" + curr.word + "\".");
            }
            if (curr.recognised && !curr.recommended) {
                lstAdvice.add("\"" + curr + "\" is a recognised but not recommended word. In order to ensure better detection by VO applications, you should use a UCD word recommended by the IVOA if any can already represent the same quantity.");
            }
            switch (curr.syntaxCode) {
                case PHOT_QUANTITY: {
                    if (!this.matches(i + 1, REGEXP_EM)) {
                        if (candidatesEM.size() == 0) {
                            lstAdvice.add("No part of the electromagnetic spectrum is specified for the photometric quantity \"" + curr + "\". For more precision, one part of the EM spectrum can be added just after \"" + curr + "\".");
                            continue block7;
                        }
                        lstAdvice.add("No part of the electromagnetic spectrum is EXPLICITLY specified for the photometric quantity \"" + curr + "\". Some candidates have been detected in this UCD: " + candidatesEM_str + ". For more clarity, one candidate or a new part of the EM spectrum should be moved just after \"" + curr + "\".");
                        continue block7;
                    }
                    if (!this.matches(i + 2, REGEXP_EM)) continue block7;
                    lstAdvice.add("At least two parts of the electromagnetic spectrum have been specified successively after the photometric quantity \"" + curr + "\". Only one is expected, but maybe more parts of the electromagnetic spectrum are covered here.");
                    continue block7;
                }
                case COLOUR: {
                    if (!this.matches(i + 1, REGEXP_EM)) {
                        if (candidatesEM.size() == 0) {
                            lstAdvice.add("No range of the electromagnetic spectrum is specified for the colour \"" + curr + "\". For more precision, two successive parts of the EM spectrum can be added after \"" + curr + "\".");
                            continue block7;
                        }
                        lstAdvice.add("No range of the electromagnetic spectrum is EXPLICITLY specified for the colour \"" + curr + "\". Some candidates have been detected in this UCD: " + candidatesEM_str + ". For more clarity, two candidates or new parts of the EM spectrum should be moved successively just after \"" + curr + "\".");
                        continue block7;
                    }
                    if (!this.matches(i + 2, REGEXP_EM)) {
                        LinkedHashSet<UCDWord> candidates = new LinkedHashSet<UCDWord>(candidatesEM);
                        candidates.remove(this.words[i + 1]);
                        if (candidates.size() == 0) {
                            lstAdvice.add("Missing second bound of the electromagnetic spectrum range for the colour \"" + curr + "\". For more precision, a part of the EM spectrum can be added after \"" + curr + "\".\"" + this.words[i + 1] + "\".");
                            continue block7;
                        }
                        lstAdvice.add("Missing second bound of the electromagnetic spectrum range for the colour \"" + curr + "\". Some candidates have been detected in this UCD: " + this.concat(candidates) + ". For more clarity, one candidate or a new part of the EM spectrum should be moved just after \"" + curr + "\".\"" + this.words[i + 1] + "\".");
                        continue block7;
                    }
                    if (!this.matches(i + 3, REGEXP_EM)) continue block7;
                    lstAdvice.add("At least three parts of the electromagnetic spectrum have been specified successively after the colour \"" + curr + "\". Only two are expected. For more clarity, you should probably consider to remove the excedent.");
                    continue block7;
                }
                case VECTOR: {
                    if (!this.matches(i + 1, REGEXP_AXIS_FRAME)) {
                        if (candidatesAxisFrame.size() == 0) {
                            lstAdvice.add("No axis or reference frame is specified for the vector \"" + curr + "\". For more precision, one axis or reference frame can be added just after \"" + curr + "\".");
                            continue block7;
                        }
                        lstAdvice.add("No axis or reference frame is EXPLICITLY specified for the vector \"" + curr + "\". Some candidates have been detected in this UCD: " + candidatesAxisFrame_str + ". For more clarity, one candidate or a axis or reference frame should be moved just after \"" + curr + "\".");
                        continue block7;
                    }
                    if (!this.matches(i + 2, REGEXP_AXIS_FRAME)) continue block7;
                    lstAdvice.add("At least two axis or reference frames have been specified successively after the vector \"" + curr + "\". Only one is expected. For more clarity, you should probably consider to remove the excedent.");
                    continue block7;
                }
            }
        }
        this.advice = lstAdvice.toArray(new String[lstAdvice.size()]);
    }

    protected boolean matches(int indexWord, String pattern) {
        return pattern != null && indexWord >= 0 && indexWord < this.words.length && this.words[indexWord] != null && this.words[indexWord].word.trim().toLowerCase().matches(pattern);
    }

    protected String concat(Collection<UCDWord> set) {
        StringBuffer buf = new StringBuffer();
        for (UCDWord d : set) {
            this.append(buf, d.toString());
        }
        return buf.toString();
    }

    protected LinkedHashSet<UCDWord> searchByPattern(String pattern) {
        LinkedHashSet<UCDWord> match = new LinkedHashSet<UCDWord>();
        if (pattern == null) {
            return match;
        }
        for (UCDWord w : this.words) {
            if (w == null || !w.word.trim().toLowerCase().matches(pattern)) continue;
            match.add(w);
        }
        return match;
    }

    public final Iterator<String> getAdvice() {
        if (this.advice == null) {
            this.listAdvice();
        }
        return new AdviceIterator();
    }

    protected void createSuggestion() {
        UCDWord w;
        if (this.isFullyValid()) {
            this.suggestion = this;
            return;
        }
        ArrayList<UCDWord> newWords = new ArrayList<UCDWord>(this.words.length);
        UCD tempSuggestion = null;
        if (!this.allRecognised.booleanValue()) {
            for (UCDWord w2 : this.words) {
                if (w2 == null) continue;
                if (w2.isDeprecated()) {
                    for (UCDWord w22 : w2.suggestedReplacement) {
                        if (newWords.contains(w22)) continue;
                        newWords.add(w22);
                    }
                    continue;
                }
                if (w2.recognised) {
                    if (newWords.contains(w2)) continue;
                    newWords.add(w2);
                    continue;
                }
                if (w2.valid) {
                    if (w2.closest != null) {
                        if (newWords.contains(w2)) continue;
                        newWords.add(w2.closest[0]);
                        continue;
                    }
                    this.suggestion = null;
                    return;
                }
                if (w2.word.trim().length() <= 0) continue;
                UCDWord newWord = new UCDWord(w2.syntaxCode, w2.word.trim().replaceAll("\\s+", "."), w2.description, w2.recommended);
                if (newWord.recognised) {
                    if (newWords.contains(w2)) continue;
                    newWords.add(newWord);
                    continue;
                }
                this.suggestion = null;
                return;
            }
            if (newWords.size() == 0) {
                this.suggestion = null;
                return;
            }
            tempSuggestion = new UCD(newWords);
            if (tempSuggestion.isFullyValid()) {
                this.suggestion = tempSuggestion;
                return;
            }
            tempSuggestion = null;
        } else {
            for (UCDWord w2 : this.words) {
                if (newWords.contains(w2)) continue;
                newWords.add(w2);
            }
        }
        UCDWord firstPrimary = null;
        Iterator<Object> it = newWords.iterator();
        while (it.hasNext()) {
            w = (UCDWord)it.next();
            if (w.syntaxCode != UCDSyntax.PRIMARY) continue;
            if (firstPrimary == null) {
                firstPrimary = w;
            }
            it.remove();
        }
        if (firstPrimary != null) {
            newWords.add(0, firstPrimary);
        } else if (newWords.size() > 0 && newWords.get((int)0).syntaxCode == UCDSyntax.SECONDARY) {
            it = newWords.iterator();
            while (it.hasNext()) {
                w = (UCDWord)it.next();
                if (w.syntaxCode == UCDSyntax.SECONDARY) continue;
                it.remove();
                newWords.add(0, w);
                break;
            }
        }
        if (newWords.size() == 0) {
            this.suggestion = null;
            return;
        }
        tempSuggestion = new UCD(newWords);
        this.suggestion = tempSuggestion.isFullyValid() ? tempSuggestion : null;
    }

    public final UCD getSuggestion() {
        if (!this.alreadyHasSuggestion) {
            this.createSuggestion();
            this.alreadyHasSuggestion = true;
        }
        return this.suggestion;
    }

    public final boolean containsDeprecated() {
        if (this.deprecatedWords == null) {
            this.listDeprecated();
        }
        return this.deprecatedWords.length > 0;
    }

    public final int countDeprecated() {
        if (this.deprecatedWords == null) {
            this.listDeprecated();
        }
        return this.deprecatedWords.length;
    }

    public final Iterator<UCDWord> getDeprecated() {
        if (this.deprecatedWords == null) {
            this.listDeprecated();
        }
        return new DeprecatedIterator();
    }

    protected void listDeprecated() {
        LinkedHashSet<UCDWord> deprecated = new LinkedHashSet<UCDWord>(this.words.length);
        for (UCDWord w : this.words) {
            if (w == null || !w.isDeprecated()) continue;
            deprecated.add(w);
        }
        this.deprecatedWords = deprecated.toArray(new UCDWord[deprecated.size()]);
    }

    public final int size() {
        return this.words.length;
    }

    public final UCDWord getWord(int indWord) throws ArrayIndexOutOfBoundsException {
        return this.words[indWord];
    }

    @Override
    public final Iterator<UCDWord> iterator() {
        return new WordsIterator();
    }

    public final String toString() {
        if (this.strRepresentation == null) {
            StringBuffer buf = new StringBuffer();
            for (UCDWord w : this.words) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                if (w == null) continue;
                buf.append(w.rawWord);
            }
            this.strRepresentation = buf.toString();
        }
        return this.strRepresentation;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof UCD && Arrays.equals(this.words, ((UCD)obj).words);
    }

    public int hashCode() {
        return Arrays.hashCode(this.words);
    }

    protected class WordsIterator
    implements Iterator<UCDWord> {
        private int index = -1;

        protected WordsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < UCD.this.words.length;
        }

        @Override
        public UCDWord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more UCD words!");
            }
            return UCD.this.words[++this.index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Impossible to modify a UCD!");
        }
    }

    protected class DeprecatedIterator
    implements Iterator<UCDWord> {
        private int index = -1;

        protected DeprecatedIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < UCD.this.deprecatedWords.length;
        }

        @Override
        public UCDWord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Sorry, no more deprecated word!");
            }
            return UCD.this.deprecatedWords[++this.index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Impossible to get rid of a deprecated word like that :-P");
        }
    }

    protected class AdviceIterator
    implements Iterator<String> {
        private int index = -1;

        protected AdviceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < UCD.this.advice.length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Sorry, no more advice!");
            }
            return UCD.this.advice[++this.index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Impossible to get rid of my advice :-P");
        }
    }

    protected class ErrorsIterator
    implements Iterator<String> {
        private int index = -1;

        protected ErrorsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < UCD.this.errors.length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more errors!");
            }
            return UCD.this.errors[++this.index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Impossible to drop errors so easily :-P");
        }
    }
}

