# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 0.16.0 - 2021-01-18

- [[#235]] Expose the whoami API endpoint in the AsyncClient.
- [[#233]] Treat device lists as optional in the Sync response class.
- [[#228]] Add support for account data in the AsyncClient.
- [[#223]] Percent encode user IDs when they appear in an URL.

[#235]: https://github.com/poljar/matrix-nio/pull/235
[#233]: https://github.com/poljar/matrix-nio/pull/233
[#228]: https://github.com/poljar/matrix-nio/pull/228
[#223]: https://github.com/poljar/matrix-nio/pull/223

## 0.15.2 - 2020-10-29

### Fixed

- [[#220]] Copy the unencrypted `m.relates_to` part of an encrypted event into the
  decrypted event.

[#220]: https://github.com/poljar/matrix-nio/pull/220

## 0.15.1 - 2020-08-28

### Fixed

- [[#216]] `AsyncClient.room_get_state_event()`: return a 
  `RoomGetStateEventError` if the server returns a 404 error for the request
- [[ffc4228]] When fetching the full list of room members, discard the members
  we previously had that are absent from the full list
- [[c123e24]] `MatrixRoom.members_synced`: instead of depending on the 
  potentially outdated room summary member count, become `True` when the 
  full member list has been fetched for the room.

[#216]: https://github.com/poljar/matrix-nio/pull/216
[[ffc4228]]: https://github.com/poljar/matrix-nio/commit/ffc42287c22a1179a9be7d4e47555693417f715d
[[c123e24]]: https://github.com/poljar/matrix-nio/commit/c123e24c8df81c55d40973470b825e78fd2f92a2

## 0.15.0 - 2020-08-21

### Added

- [[#194]] Add server discovery info (.well-known API) support to AsyncClient
- [[#206]] Add support for uploading sync filters to AsyncClient
- New [examples] and documentation improvements

### Fixed

- [[#206]] Fix `AsyncClient.room_messages()` to not accept filter IDs, using 
  one results in a server error
- [[4b6ea92]] Fix the `SqliteMemoryStore` constructor
- [[4654c7a]] Wait for current session sharing operation to finish before
  starting a new one
- [[fc9f5e3]] Fix `OverflowError` occuring in 
  `AsyncClient.get_timeout_retry_wait_time()` after a thousand retries

[#194]: https://github.com/poljar/matrix-nio/pull/194
[#206]: https://github.com/poljar/matrix-nio/pull/206
[4b6ea92]: https://github.com/poljar/matrix-nio/commit/4b6ea92cb69e445bb39bbfd83948b40adb8a23a5
[4654c7a]: https://github.com/poljar/matrix-nio/commit/4654c7a1a7e39b496b107337977421aeb5953974
[fc9f5e3]: https://github.com/poljar/matrix-nio/commit/fc9f5e3eda25ad65936aeb95412a26af73cedf6a
[examples]: https://matrix-nio.readthedocs.io/en/latest/examples.html

## 0.14.1 - 2020-06-26

### Fixed

- [[238b6ad]] Fix the schema for the devices response.

[238b6ad]: https://github.com/poljar/matrix-nio/commit/238b6addaaa85b994552e00007638b0170c47c43

## 0.14.0 - 2020-06-21

### Added

- [[#166]] Add a method to restore the login with an access token.

### Changed

- [[#159]] Allow whitespace in HTTP headers in the HttpClient.
- [[42e70de]] Fix the creation of PresenceGetError responses.
- [[bf60bd1]] Split out the bulk of the key verification events into a common module.
- [[9a01396]] Don't require the presence dict to be in the sync response.


### Removed

- [[cc789f6]] Remove the PartialSyncResponse. This is a breaking change, but
  hopefully nobody used this.

[#166]: https://github.com/poljar/matrix-nio/pull/166
[#159]: https://github.com/poljar/matrix-nio/pull/159
[42e70de]: https://github.com/poljar/matrix-nio/commit/42e70dea945ae97b69b41d49cb57f64c3b6bd1c4
[cc789f6]: https://github.com/poljar/matrix-nio/commit/cc789f665063b38be5b4146855e5204e9bc5bdb6
[bf60bd1]: https://github.com/poljar/matrix-nio/commit/bf60bd19a15429dc03616b9be11c3a205768e5ad
[9a01396]: https://github.com/poljar/matrix-nio/commit/9a0139673329fb82abc59496025d78a34b419b77

## 0.13.0 - 2020-06-05

### Added

- [[#145]] Added the `room_get_event()` method to `AsyncClient`.
- [[#151]] Added the `add_presence_callback` method to base `Client`.
- [[#151]] Added the `get_presence()` and `set_presence()` methods
  to `AsyncClient`.
- [[#151]] Added the `presence`, `last_active_ago`, `currently_active` and
  `status_msg` attributes to `MatrixUser`
- [[#152]] Added a docker container with E2E dependencies pre-installed.
- [[#153]] Added the `add_room_account_data_callback` method to base `Client`.
- [[#153]] Added the `fully_read_marker` and `tags` attributes to `MatrixRoom`.
- [[#156]] Added the `update_receipt_marker()` method to `AsyncClient`.
- [[#156]] Added the `unread_notifications` and `unread_highlights` attributes
  to `MatrixRoom`.

### Changed

- [[#141]] Improved the upload method to accept file objects directly.

[#141]: https://github.com/poljar/matrix-nio/pull/141
[#145]: https://github.com/poljar/matrix-nio/pull/145
[#151]: https://github.com/poljar/matrix-nio/pull/151
[#152]: https://github.com/poljar/matrix-nio/pull/152
[#153]: https://github.com/poljar/matrix-nio/pull/153
[#156]: https://github.com/poljar/matrix-nio/pull/156

## 0.12.0 - 2020-05-21

### Added

- [[#140]] Added the `update_device()` method to the `AsyncClient`.
- [[#143]] Added the `login_info()` method to the `AsyncClient`.
- [[c4f460f]] Added support for the new SAS key agreement protocol.

### Fixed

- [[#146]] Fix room summary updates when new summary doesn't have any
  attributes.
- [[#147]] Added missing requirements to the test requirements file.

[#140]: https://github.com/poljar/matrix-nio/pull/140
[#143]: https://github.com/poljar/matrix-nio/pull/143
[#146]: https://github.com/poljar/matrix-nio/pull/146
[#147]: https://github.com/poljar/matrix-nio/pull/147
[c4f460f]: https://github.com/poljar/matrix-nio/commit/c4f460f62c9543a76eaf1dad4be8ff5ae9312243

## 0.11.2 - 2020-05-11

### Fixed

- Fixed support to run nio without python-olm.
- Fixed an incorrect raise in the group sessions sharing logic.
- Handle 429 errors correctly even if they don't contain a json response.

## 0.11.1 - 2020-05-10

### Fixed

- Fix a wrong assertion resulting in errors when trying to send a message.

## 0.11.0 - 2020-05-10

### Added

- Kick, ban, unban support to the AsyncClient.
- Read receipt sending support in the AsyncClient.
- Read receipt parsing and emitting.
- Support token login in the AsyncClient login method.
- Support for user registration in the BaseClient and AsyncClient.
- Support for ID based filters for the sync and room_messages methods.
- Support filter uploading.

### Changed

- Convert attrs classes to dataclasses.
- Fire the `synced` asyncio event only in the sync forever loop.

### Fixed

- Don't encrypt reactions.
- Properly put event relationships into the unencrypted content.
- Catch Too Many Requests errors more reliably.
- Better room name calculation, now using the room summary.

### Removed

- Removed the legacy store.
