# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase.aio import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtExascaleDbStorageVaultsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_get(self, resource_group):
        response = await self.client.exascale_db_storage_vaults.get(
            resource_group_name=resource_group.name,
            exascale_db_storage_vault_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_begin_create(self, resource_group):
        response = await (
            await self.client.exascale_db_storage_vaults.begin_create(
                resource_group_name=resource_group.name,
                exascale_db_storage_vault_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "displayName": "str",
                        "highCapacityDatabaseStorageInput": {"totalSizeInGbs": 0},
                        "additionalFlashCacheInPercent": 0,
                        "attachedShapeAttributes": ["str"],
                        "description": "str",
                        "exadataInfrastructureId": "str",
                        "highCapacityDatabaseStorage": {"availableSizeInGbs": 0, "totalSizeInGbs": 0},
                        "lifecycleDetails": "str",
                        "lifecycleState": "str",
                        "ociUrl": "str",
                        "ocid": "str",
                        "provisioningState": "str",
                        "timeZone": "str",
                        "vmClusterCount": 0,
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_begin_update(self, resource_group):
        response = await (
            await self.client.exascale_db_storage_vaults.begin_update(
                resource_group_name=resource_group.name,
                exascale_db_storage_vault_name="str",
                properties={"tags": {"str": "str"}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_begin_delete(self, resource_group):
        response = await (
            await self.client.exascale_db_storage_vaults.begin_delete(
                resource_group_name=resource_group.name,
                exascale_db_storage_vault_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_list_by_resource_group(self, resource_group):
        response = self.client.exascale_db_storage_vaults.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exascale_db_storage_vaults_list_by_subscription(self, resource_group):
        response = self.client.exascale_db_storage_vaults.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
