/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.SaxFilterMaker;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.sax.XMLProcessorImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.tr.ActionDebugTarget;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.Sheet;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLProcessorImpl
implements XSLProcessor,
Cloneable,
ParameterSet {
    private XMLProcessorEx sourceLoader;
    private XMLProcessorEx sheetLoader;
    private boolean engineMatchesSheetLoader = false;
    private Parser sheetParser;
    private Parser sourceParser;
    private Sheet sheet;
    private Engine engine;
    private InputSource sheetSource;
    private Result result;
    private OutputMethodHandler outputMethodHandler;
    private DocumentHandler documentHandler;
    private ContentHandler _contentHandler = null;
    private ErrorHandler errorHandler;
    private Hashtable params = new Hashtable();
    private SaxFilterMaker _xrap = null;
    private ActionDebugTarget _debugger = null;

    public void setParser(Parser sourceParser, Parser sheetParser) {
        this.sourceParser = sourceParser;
        this.sheetParser = sheetParser;
        this.sourceLoader = new XMLProcessorImpl(sourceParser);
        this.sheetLoader = sourceParser == sheetParser ? this.sourceLoader : new XMLProcessorImpl(sheetParser);
        this.engineMatchesSheetLoader = false;
    }

    public void setParser(XMLProcessorEx loader) {
        this.sourceParser = null;
        this.sheetParser = null;
        this.sourceLoader = loader;
        this.sheetLoader = loader;
        this.engineMatchesSheetLoader = false;
    }

    public void setParser(Parser parser) {
        this.setParser(parser, parser);
    }

    public void setLocale(Locale locale) throws SAXException {
        if (this.sheetParser != null) {
            this.sheetParser.setLocale(locale);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setLocale(locale);
        }
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (this.sheetParser != null) {
            this.sheetParser.setEntityResolver(resolver);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setEntityResolver(resolver);
        }
    }

    public void setOutputMethodHandler(OutputMethodHandler handler) {
        this.outputMethodHandler = handler;
        this._contentHandler = null;
        this.documentHandler = null;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        this._contentHandler = null;
        this.outputMethodHandler = null;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
        this.outputMethodHandler = null;
        this.documentHandler = null;
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (this.sheetParser != null) {
            this.sheetParser.setErrorHandler(handler);
        }
        if (this.sourceParser != null) {
            this.sourceParser.setErrorHandler(handler);
        }
        if (this.sheetLoader != null) {
            this.sheetLoader.setErrorHandler(handler);
        }
        if (this.sourceLoader != null) {
            this.sourceLoader.setErrorHandler(handler);
        }
        this.errorHandler = handler;
    }

    public void loadStylesheet(InputSource sheetSource) throws SAXException, IOException {
        if (!this.engineMatchesSheetLoader) {
            if (this.sheetLoader == null) {
                throw new Error("loadStylesheet called before setParser");
            }
            this.engine = new EngineImpl(this.sheetLoader, new ExtensionHandlerImpl());
            this.engineMatchesSheetLoader = true;
        }
        try {
            this.phase(1);
            Node node = this.sheetLoader.load(sheetSource, 0, this.engine.getSheetLoadContext(), this.engine.getNameTable());
            this.phase(2);
            this.sheet = this._debugger != null ? this.engine.createSheet(node, this._debugger) : this.engine.createSheet(node);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    public void parse(InputSource source) throws SAXException, IOException {
        try {
            this.result = this.outputMethodHandler != null ? new MultiNamespaceResult(this.outputMethodHandler, this.errorHandler) : (this._contentHandler != null ? new com.jclark.xsl.sax2.MultiNamespaceResult(this._contentHandler, this.errorHandler) : (this.documentHandler != null ? new MultiNamespaceResult(this.documentHandler, this.errorHandler) : new MultiNamespaceResult(new HandlerBase(), this.errorHandler)));
            this.phase(3);
            Node root = this.sourceLoader.load(source, 0, this.sheet.getSourceLoadContext(), this.engine.getNameTable());
            this.phase(4);
            if (this._xrap != null) {
                this.sheet.setSaxExtensionFilter(this._xrap);
            }
            this.sheet.process(root, this.sourceLoader, this, this.result);
            this.phase(5);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    public void setSaxExtensionFilter(String name, SaxFilterMaker xrap) {
        this._xrap = xrap;
    }

    public void setDebugger(String name, ActionDebugTarget debugger) {
        this._debugger = debugger;
    }

    void handleXSLException(XSLException e) throws SAXException, IOException {
        String systemId = null;
        int lineNumber = -1;
        Node node = e.getNode();
        if (node != null) {
            URL url = node.getURL();
            if (url != null) {
                systemId = url.toString();
            }
            lineNumber = node.getLineNumber();
        }
        Exception wrapped = (Exception)e.getException();
        String message = e.getMessage();
        if (systemId != null || lineNumber != -1) {
            throw new SAXParseException(message, null, systemId, lineNumber, -1, wrapped);
        }
        if (message == null) {
            if (wrapped instanceof SAXException) {
                throw (SAXException)wrapped;
            }
            if (wrapped instanceof IOException) {
                throw (IOException)wrapped;
            }
        }
        throw new SAXException(message, wrapped);
    }

    void phase(int n) {
    }

    public Object clone() {
        try {
            XSLProcessorImpl cloned = (XSLProcessorImpl)super.clone();
            cloned.params = new Hashtable();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Object getParameter(Name name) {
        String nameString = name.getNamespace();
        nameString = nameString == null ? name.getLocalPart() : nameString + '^' + name.getLocalPart();
        return this.params.get(nameString);
    }

    public void setParameter(String name, Object obj) {
        this.params.put(name, obj);
    }
}

