/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

public class CloneableNodeIteratorImpl
implements CloneableNodeIterator {
    private final NodeList list;
    private int i;

    public Object clone() {
        return new CloneableNodeIteratorImpl(this.list, this.i);
    }

    public CloneableNodeIteratorImpl(NodeIterator iter) {
        this.list = new NodeList(iter);
        this.i = 0;
    }

    private CloneableNodeIteratorImpl(NodeList list, int i) {
        this.list = list;
        this.i = i;
    }

    public Node next() throws XSLException {
        Node tem = this.list.nodeAt(this.i);
        if (tem != null) {
            ++this.i;
        }
        return tem;
    }

    public void bind() throws XSLException {
        int i = 0;
        while (this.list.nodeAt(i) != null) {
            ++i;
        }
    }

    static class NodeList {
        final NodeIterator iter;
        Node[] nodes = null;
        int len = 0;

        NodeList(NodeIterator iter) {
            this.iter = iter;
        }

        Node nodeAt(int i) throws XSLException {
            if (i >= this.len) {
                if (this.nodes == null) {
                    this.nodes = new Node[i + 4];
                } else if (i >= this.nodes.length) {
                    Node[] oldNodes = this.nodes;
                    this.nodes = new Node[oldNodes.length * 2];
                    System.arraycopy(oldNodes, 0, this.nodes, 0, oldNodes.length);
                }
                while (this.len <= i) {
                    this.nodes[this.len] = this.iter.next();
                    if (this.nodes[this.len] == null) {
                        return null;
                    }
                    ++this.len;
                }
            }
            return this.nodes[i];
        }
    }
}

