/*--------------------------------------------------------------------------+
$Id: TargetlinkDataResolverTest.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.targetlink;

import java.io.StringReader;
import java.util.Map;

import java_cup.runtime.Symbol;
import edu.tum.cs.simulink.model.SimulinkBlock;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.testutils.SimulinkTestBase;

/**
 * Test for Targetlink support facility.
 * <p>
 * The test specified here are far from complete but meant as basis to
 * conveniently add more tests.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: B23CD549893DF27E16A40D836DA1FA86
 */
public class TargetlinkDataResolverTest extends SimulinkTestBase {

	/** Test parser. */
	public void testParser() throws Exception {
		SimulinkModel model = loadModel("tl_blocklib.mdl");
		SimulinkBlock block = model.getBlock("tl_blocklib/Abs");
		String data = block.getParameter("data");

		TargetlinkDataScanner scanner = new TargetlinkDataScanner(
				new StringReader(data));
		TargetlinkDataParser parser = new TargetlinkDataParser(scanner);
		Symbol sym = parser.parse();
		TargetlinkStruct struct = (TargetlinkStruct) sym.value;

		Map<String, String> values = struct.getParameters();
		assertEquals(32, values.size());
	}

}