/*--------------------------------------------------------------------------+
$Id: SimulinkBlockTypeConstraint.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.constraints;

import edu.tum.cs.commons.constraint.ConstraintViolationException;
import edu.tum.cs.commons.constraint.ILocalConstraint;
import edu.tum.cs.commons.string.StringUtils;
import edu.tum.cs.simulink.model.SimulinkBlock;

/**
 * This constraint checks if a Simulink block has a defined type. This is a
 * mandatory constraint.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 7E2938021C2F2CF1ABD161AFABFB4FBC
 */
public class SimulinkBlockTypeConstraint implements
		ILocalConstraint<SimulinkBlock> {

	/** See class comment. */
	public void checkLocalConstraint(SimulinkBlock element)
			throws ConstraintViolationException {
		if (StringUtils.isEmpty(element.getType())) {
			throw new ConstraintViolationException("Block " + element
					+ " has no type.", element);
		}
	}
}