/*--------------------------------------------------------------------------+
$Id: UndoStack.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.string;

import java.util.List;

/**
 * Helper class used by {@link StringUndoStackBaseTest}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: D4AAE66656E4DDE5AC09C1D27724B826
 */
/* package */class UndoStack extends StringUndoStackBase {

	/**
	 * Records number of changes to the stack to test
	 * {@link StringUndoStackBase#fireStackChanged()}.
	 */
	private int stackChangeCounter = 0;

	/** Simple string serves as model. */
	private final StringBuilder model = new StringBuilder();

	/** Create new stack. */
	public UndoStack(String initialString) {
		super(initialString);
		model.append(initialString);
	}

	/** Inc change counter. */
	@Override
	protected void fireStackChanged() {
		stackChangeCounter++;
	}

	/** Join by line. */
	@Override
	protected String join(List<String> parts) {
		return StringUtils.concat(parts, StringUtils.CR);
	}

	/** Split by line. */
	@Override
	protected List<String> split(String s) {
		return StringUtils.splitLinesAsList(s);
	}

	/** Set model. */
	@Override
	protected void setModelFromString(String s) {
		model.setLength(0);
		model.append(s);
	}

	/** Get model content. */
	public String getModel() {
		return model.toString();
	}

	/** Add new line to the model. */
	public void addLine(String line) {
		if (model.length() > 0) {
			model.append(StringUtils.CR);
		}
		model.append(line);
		insertNewVersion(model.toString());
	}

	/** Get stack change count. */
	public int getStackChangeCount() {
		return stackChangeCounter;
	}

}