/*--------------------------------------------------------------------------+
$Id: SimpleLogger.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.logging;

import static edu.tum.cs.commons.string.StringUtils.obtainStackTrace;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Simple logger that writes all messages to a stream or print writer.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 74D659BE8CEFA9291421EE8E3BC41B76
 */
public class SimpleLogger implements ILogger {

	/** The writer used for output. */
	private final PrintWriter writer;

	/** Create logger that logs to {@link System#out}. */
	public SimpleLogger() {
		this(System.out);
	}

	/** Create logger that logs to a stream. */
	public SimpleLogger(OutputStream stream) {
		writer = new PrintWriter(stream, true);
	}

	/** Create logger that logs to a writer. */
	public SimpleLogger(PrintWriter writer) {
		this.writer = writer;
	}

	/** {@inheritDoc} */
	public void debug(Object message) {
		writer.println("DEBUG: " + message);
	}

	/** {@inheritDoc} */
	public void debug(Object message, Throwable throwable) {
		debug(message + ": " + obtainStackTrace(throwable));
	}

	/** {@inheritDoc} */
	public void error(Object message) {
		writer.println("ERROR: " + message);

	}

	/** {@inheritDoc} */
	public void error(Object message, Throwable throwable) {
		error(message + ": " + obtainStackTrace(throwable));
	}

	/** {@inheritDoc} */
	public void info(Object message) {
		writer.println("INFO : " + message);
	}

	/** {@inheritDoc} */
	public void info(Object message, Throwable throwable) {
		info(message + ": " + obtainStackTrace(throwable));
	}

	/** {@inheritDoc} */
	public void warn(Object message) {
		writer.println("WARN : " + message);
	}

	/** {@inheritDoc} */
	public void warn(Object message, Throwable throwable) {
		warn(message + ": " + obtainStackTrace(throwable));
	}

}