/*--------------------------------------------------------------------------+
$Id: IEquator.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.equals;

/**
 * Compares two elements for equality.
 * <p>
 * This interface externalizes the notion of equality. This way, different
 * notions of equality can be applied to the same object in different contexts.
 * 
 * @author Elmar Juergens
 * @author $Author: juergens $
 * 
 * @version $Revision: 26283 $
 * @levd.rating GREEN Hash: 3B8AE0E21829588480F73AD24647C588
 */
public interface IEquator<T> {

	/**
	 * Returns <code>true</code>, if the elements are equal,
	 * <code>false</code> if not.
	 */
	public boolean equals(T element1, T element2);

}