/*--------------------------------------------------------------------------+
$Id: Digester.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.error.EnvironmentError;
import edu.tum.cs.commons.string.StringUtils;

/**
 * Utility functions for creation of digests.
 * 
 * @author juergens
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: 3CB40A00577C76D6DEA0297E30EEA8F7
 */
public class Digester {

	/** Digester used to create Digester hashes. */
	private static MessageDigest digester = getMD5();

	/**
	 * Computes an MD5 hash for a string. The fingerprint is the digester hash
	 * of the string. It is always 32 characters long and only uses characters
	 * from [0-9A-F].
	 */
	public static String createMD5Digest(String base) {
		digester.reset();
		digester.update(base.getBytes());

		return StringUtils.encodeAsHex(digester.digest());
	}

	/**
	 * Computes an MD5 hash for a collection of strings. The strings are sorted
	 * before MD5 computation, so that the resulting MD5 hash is independent of
	 * the order of the strings in the collection.
	 */
	public static String createMD5Digest(Collection<String> bases) {
		List<String> sortedBases = CollectionUtils.sort(bases);
		return createMD5Digest(StringUtils.concat(sortedBases,
				StringUtils.EMPTY_STRING));
	}

	/**
	 * Returns Digester digester or throws an AssertionError if the Digester
	 * could not be located.
	 */
	public static MessageDigest getMD5() {
		try {
			return MessageDigest.getInstance("MD5");
		} catch (NoSuchAlgorithmException e) {
			throw new EnvironmentError(
					"MD5 algorithm found. Please check your JRE installation",
					e);
		}

	}

}