/*--------------------------------------------------------------------------+
$Id: ILocalConstraint.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.constraint;

/**
 * Interface of a constraint checking a local property, i.e. one that can be
 * verified by only seeing one object. A constraint usually should be stateless.
 * 
 * @param <T>
 *            the type of object being checked by the constraint.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 92D35FD04ECF2EB71E20CF1FA5E2CD24
 */
public interface ILocalConstraint<T> {

	/**
	 * Checks this constraint and throws an exception only if the constraint is
	 * violated for the object.
	 * 
	 * @param object
	 *            the object to be checked by this constraint.
	 * 
	 * @throws ConstraintViolationException
	 *             if the constraint was violated.
	 */
	void checkLocalConstraint(T object) throws ConstraintViolationException;
}