/*--------------------------------------------------------------------------+
$Id: ConstraintViolationException.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.constraint;

/**
 * Exception to be thrown in case of constraint violations.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: B3315A0FB8B06699B4D79370C23C4AD9
 */
public class ConstraintViolationException extends Exception {

	/** The object that violated the constraint. */
	private final Object violator;

	/** Constructor. */
	public ConstraintViolationException(String message, Object violator) {
		super(message);
		this.violator = violator;
	}

	/** Constructor. */
	public ConstraintViolationException(String message, Object violator,
			Throwable t) {
		super(message, t);
		this.violator = violator;
	}

	/** Get object that violated the constraint. */
	public Object getViolator() {
		return violator;
	}
}