/* KRegularity.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.simple;

import org.grinvin.factories.FactoryParameterException;
import org.grinvin.graphs.GraphBundleView;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantFactory;
import org.grinvin.invariants.computers.AbstractInvariantComputerFactory;
import org.grinvin.invariants.values.BooleanValue;

/**
 * Factory for an invariant computer which counts the number of vertices of a
 * given degree.
 */
public class KRegularity extends AbstractInvariantComputerFactory {
    
    //
    private static class KRegularityComputer extends Computer<BooleanValue> {
        
        private KRegularityComputer () {
            // prevents creation of access class
        }
        
        //
        public int degree;
        
        public BooleanValue compute (GraphBundleView bundle) {
            for (int[] neighbours : bundle.adjacencyList ())
                if (neighbours.length != degree)
                    return new BooleanValue (false, this);
            return new BooleanValue (true, this);
        }
    }
    
    public InvariantComputer createInvariantComputer (InvariantFactory invFactory) throws FactoryParameterException {
        
        assert invFactory.getId ().equals (getInvariantId ());
        
        int degree = ((Integer)invFactory.getParameterValues ()[0]).intValue();
        if (degree < 0)
            throw new  FactoryParameterException ("Degree should be positive");
        
        KRegularityComputer computer = new KRegularityComputer();
        computer.degree = degree;
        computer.id = getClass().getName () + "(" + degree + ")";
        computer.invariantId = getInvariantId() + "?degree=" + degree;
        computer.version = getVersion ();
        return computer;
    }
    
    public String getInvariantId () {
        return "org.grinvin.invariants.KRegularity";
    }

}
