/* PathFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;
import org.grinvin.graphs.Annotation;
import org.grinvin.graphs.Embedding;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.Vertex;

/**
 * Factory that creates path graphs of given length.
 */
public class PathFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding, Annotation annotation) {
        int order = ((Integer)values[0]).intValue();
        if(order == 1){
            Vertex vertex = graph.addNewVertex();
            embedding.setDimension(2);
            double[] coords = {0,0};
            embedding.setCoordinates(vertex, coords);
        } else {
            int length = order - 1;
            Vertex[] vertices = createPath(graph, embedding, length);
            for (int i=0; i <length ; i++)
                graph.addNewEdge(vertices[i], vertices[i+1]);
        }
    }
    
    // implements AbstractGraphFactory
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        int order = ((Integer)values[0]).intValue();
        if (order < 1)
            throw new FactoryParameterException("order should be at least 1");
    }
    
}
