% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decor.R
\name{cpp_decorations}
\alias{cpp_decorations}
\title{Decorations in a `C++` file}
\usage{
cpp_decorations(pkg = ".", files = cpp_files(pkg = pkg), is_attribute = FALSE)
}
\arguments{
\item{pkg}{The path to a package's root directory.}

\item{files}{Paths to `C++` files. If given, `pkg` will not be used.}

\item{is_attribute}{If `TRUE` the decorations are C++11 attributes, if `FALSE` they are comments.}
}
\value{
A tibble with the decorations found, containing fields:
- file - The filename for the decoration
- line - The line the decoration was found
- decoration - The name of the decoration
- params - Any parameters given with the decoration
- context - The text of the decoration line and all lines until the next decoration (or the end of the file).
}
\description{
Decorations in a `C++` file
}
\examples{
# Setup
f <- tempfile()
writeLines("[[cpp11::register]] int fun(int x = 1) { return x + 1; }", f)

# Retrieve the decorations in the file
cpp_decorations(files = f, is_attribute = TRUE)

# Cleanup
unlink(f)
}
