/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};


static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			_tmp13_ = _arg_index;
			_arg_index = _tmp13_ + 1;
			_tmp14_ = _arg_index;
			_tmp15_ = _arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _arg_list;
			_tmp17_ = _arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			arg = (ValaExpression*) _tmp18_;
			_tmp19_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _init_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _init_index = 0;
		_tmp20_ = self->priv->object_initializer;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_init_list = _tmp21_;
		_tmp22_ = _init_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_init_size = _tmp24_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaMemberInitializer* _tmp31_;
			_tmp25_ = _init_index;
			_init_index = _tmp25_ + 1;
			_tmp26_ = _init_index;
			_tmp27_ = _init_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _init_list;
			_tmp29_ = _init_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			init = (ValaMemberInitializer*) _tmp30_;
			_tmp31_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gint _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp1_ = index;
	if (_tmp1_ >= 0) {
		ValaList* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = index;
		vala_list_set (_tmp2_, _tmp3_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_tmp10_ = _arg_index;
			_arg_index = _tmp10_ + 1;
			_tmp11_ = _arg_index;
			_tmp12_ = _arg_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = _arg_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			if (!vala_expression_is_accessible (_tmp16_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _init_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_init_list = _tmp18_;
		_tmp19_ = _init_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_init_size = _tmp21_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaMemberInitializer* _tmp28_;
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			_tmp22_ = _init_index;
			_init_index = _tmp22_ + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = _init_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			init = (ValaMemberInitializer*) _tmp27_;
			_tmp28_ = init;
			_tmp29_ = vala_member_initializer_get_initializer (_tmp28_);
			_tmp30_ = _tmp29_;
			if (!vala_expression_is_accessible (_tmp30_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	ValaList* _tmp118_;
	ValaList* _tmp119_;
	gint _tmp120_;
	gint _tmp121_;
	gint _tmp122_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp123_;
	gint _tmp248_;
	gint _tmp249_;
	gboolean _tmp256_ = FALSE;
	ValaSymbol* _tmp257_;
	ValaSymbol* _tmp258_;
	ValaSymbol* _tmp270_;
	ValaSymbol* _tmp271_;
	gboolean _tmp517_;
	gboolean _tmp570_;
	gboolean _tmp571_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp55_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		type_args = _tmp30_;
		_tmp31_ = constructor_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp36_;
			ValaMethod* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp46_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp47_;
			ValaMemberAccess* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp32_ = constructor_sym;
			_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _vala_code_node_ref0 (_tmp34_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp35_;
			_tmp36_ = constructor_sym;
			_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp37_;
			_tmp38_ = constructor_sym;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_CREATION_METHOD)) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMethod* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = constructor;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("`%s' is not a creation method", _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp46_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp46_);
			_tmp47_ = vala_object_creation_expression_get_member_name (self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_member_access_get_inner (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp50_) : NULL);
			ma = _tmp51_;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp54_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp55_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = type_sym;
			_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp57_;
			_tmp58_ = type;
			_tmp59_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_CLASS, ValaClass));
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaErrorType* _tmp63_;
				ValaErrorType* _tmp64_;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_error_type_new (NULL, NULL, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp64_);
				_vala_code_node_unref0 (_tmp64_);
			} else {
				ValaTypeSymbol* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaObjectType* _tmp67_;
				_tmp65_ = type;
				_tmp66_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			}
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_STRUCT)) {
				ValaSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaStructValueType* _tmp72_;
				ValaStructValueType* _tmp73_;
				_tmp69_ = type_sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp70_;
				_tmp71_ = type;
				_tmp72_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp73_ = _tmp72_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp73_);
				_vala_code_node_unref0 (_tmp73_);
			} else {
				ValaSymbol* _tmp74_;
				_tmp74_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaErrorType* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaSymbol* _tmp83_;
					_tmp75_ = type_sym;
					_tmp76_ = vala_symbol_get_parent_symbol (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp80_);
					_tmp82_ = _tmp81_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp82_);
					_vala_code_node_unref0 (_tmp82_);
					_tmp83_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp83_);
				} else {
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaSymbol* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_full_name (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp85_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp91_;
			ValaList* _tmp92_;
			gint _type_arg_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _type_arg_index = 0;
			_tmp91_ = type_args;
			_tmp92_ = _vala_iterable_ref0 (_tmp91_);
			_type_arg_list = _tmp92_;
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_type_arg_size = _tmp95_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				_tmp96_ = _type_arg_index;
				_type_arg_index = _tmp96_ + 1;
				_tmp97_ = _type_arg_index;
				_tmp98_ = _type_arg_size;
				if (!(_tmp97_ < _tmp98_)) {
					break;
				}
				_tmp99_ = _type_arg_list;
				_tmp100_ = _type_arg_index;
				_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
				type_arg = (ValaDataType*) _tmp101_;
				_tmp102_ = vala_object_creation_expression_get_type_reference (self);
				_tmp103_ = _tmp102_;
				_tmp104_ = type_arg;
				vala_data_type_add_type_argument (_tmp103_, _tmp104_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		_tmp105_ = vala_object_creation_expression_get_type_reference (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_data_type_get_data_type (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = _vala_code_node_ref0 (_tmp108_);
		_vala_code_node_unref0 (type);
		type = _tmp109_;
	}
	_tmp110_ = vala_object_creation_expression_get_type_reference (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_data_type_copy (_tmp111_);
	_tmp113_ = _tmp112_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp113_);
	_vala_code_node_unref0 (_tmp113_);
	_tmp114_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp115_ = _tmp114_;
	vala_data_type_set_value_owned (_tmp115_, TRUE);
	may_throw = FALSE;
	_tmp116_ = vala_object_creation_expression_get_type_reference (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_data_type_get_type_arguments (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _tmp121_;
	_vala_iterable_unref0 (_tmp119_);
	given_num_type_args = _tmp122_;
	expected_num_type_args = 0;
	_tmp123_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp124_;
		ValaClass* _tmp125_;
		ValaClass* _tmp126_;
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gboolean _tmp131_;
		ValaClass* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		ValaSymbol* _tmp144_;
		ValaSymbol* _tmp145_;
		gboolean _tmp166_ = FALSE;
		ValaSymbol* _tmp167_;
		ValaSymbol* _tmp168_;
		_tmp124_ = type;
		_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp125_;
		_tmp126_ = cl;
		_tmp127_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		expected_num_type_args = _tmp130_;
		_vala_iterable_unref0 (_tmp128_);
		_tmp131_ = self->priv->_struct_creation;
		if (_tmp131_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp133_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp134_ = cl;
		_tmp135_ = vala_class_get_is_abstract (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaClass* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = cl;
			_tmp140_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp138_, _tmp143_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp145_ = _tmp144_;
		if (_tmp145_ == NULL) {
			ValaClass* _tmp146_;
			ValaCreationMethod* _tmp147_;
			ValaCreationMethod* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			ValaVersionAttribute* _tmp162_;
			ValaVersionAttribute* _tmp163_;
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			_tmp146_ = cl;
			_tmp147_ = vala_class_get_default_construction_method (_tmp146_);
			_tmp148_ = _tmp147_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp148_);
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			if (_tmp150_ == NULL) {
				ValaSourceReference* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaClass* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = cl;
				_tmp154_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp155_);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp152_, _tmp157_);
				_g_free0 (_tmp157_);
				_g_free0 (_tmp155_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			vala_symbol_set_used (_tmp159_, TRUE);
			_tmp160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_symbol_get_version (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			vala_version_attribute_check (_tmp163_, _tmp165_);
		}
		_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp168_ = _tmp167_;
		if (_tmp168_ != NULL) {
			gboolean _tmp169_ = FALSE;
			ValaSymbol* _tmp170_;
			ValaSymbol* _tmp171_;
			ValaSymbolAccessibility _tmp172_;
			ValaSymbolAccessibility _tmp173_;
			_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_symbol_get_access (_tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp169_ = TRUE;
			} else {
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbolAccessibility _tmp176_;
				ValaSymbolAccessibility _tmp177_;
				_tmp174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_symbol_get_access (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp169_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp166_ = _tmp169_;
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp191_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp178_;
				ValaSemanticAnalyzer* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				_tmp178_ = vala_code_context_get_analyzer (context);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_semantic_analyzer_get_current_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = _vala_code_node_ref0 (_tmp181_);
				this_symbol = _tmp182_;
				{
					gboolean _tmp183_ = FALSE;
					_tmp183_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp188_;
						ValaSymbol* _tmp189_;
						ValaClass* _tmp190_;
						if (!_tmp183_) {
							ValaSymbol* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							_tmp184_ = this_symbol;
							_tmp185_ = vala_symbol_get_parent_symbol (_tmp184_);
							_tmp186_ = _tmp185_;
							_tmp187_ = _vala_code_node_ref0 (_tmp186_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp187_;
						}
						_tmp183_ = FALSE;
						_tmp188_ = this_symbol;
						if (!(_tmp188_ != NULL)) {
							break;
						}
						_tmp189_ = this_symbol;
						_tmp190_ = cl;
						if (_tmp189_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp191_ = in_target_type;
			if (!_tmp191_) {
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				ValaSymbol* _tmp194_;
				ValaSymbol* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				gchar* _tmp198_;
				gchar* _tmp199_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_full_name (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp197_);
				_tmp199_ = _tmp198_;
				vala_report_error (_tmp193_, _tmp199_);
				_g_free0 (_tmp199_);
				_g_free0 (_tmp197_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp200_;
			ValaClass* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gboolean _tmp204_;
			ValaClass* _tmp207_;
			ValaClass* _tmp208_;
			ValaClass* _tmp209_;
			ValaClass* _tmp210_;
			_tmp200_ = cl;
			if (!(_tmp200_ != NULL)) {
				break;
			}
			_tmp201_ = cl;
			_tmp202_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp201_, "CCode", "ref_sink_function", NULL);
			_tmp203_ = _tmp202_;
			_tmp204_ = _tmp203_ != NULL;
			_g_free0 (_tmp203_);
			if (_tmp204_) {
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				_tmp205_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp206_ = _tmp205_;
				vala_data_type_set_floating_reference (_tmp206_, TRUE);
				break;
			}
			_tmp207_ = cl;
			_tmp208_ = vala_class_get_base_class (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = _vala_code_node_ref0 (_tmp209_);
			_vala_code_node_unref0 (cl);
			cl = _tmp210_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp211_;
		_tmp211_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp212_;
			ValaStruct* _tmp213_;
			ValaStruct* _tmp214_;
			ValaList* _tmp215_;
			ValaList* _tmp216_;
			gint _tmp217_;
			gint _tmp218_;
			gboolean _tmp219_ = FALSE;
			gboolean _tmp220_;
			ValaSymbol* _tmp225_;
			ValaSymbol* _tmp226_;
			gboolean _tmp230_ = FALSE;
			gboolean _tmp231_ = FALSE;
			gboolean _tmp232_ = FALSE;
			ValaProfile _tmp233_;
			ValaProfile _tmp234_;
			_tmp212_ = type;
			_tmp213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp212_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp213_;
			_tmp214_ = st;
			_tmp215_ = vala_struct_get_type_parameters (_tmp214_);
			_tmp216_ = _tmp215_;
			_tmp217_ = vala_collection_get_size ((ValaCollection*) _tmp216_);
			_tmp218_ = _tmp217_;
			expected_num_type_args = _tmp218_;
			_vala_iterable_unref0 (_tmp216_);
			_tmp220_ = self->priv->_struct_creation;
			if (!_tmp220_) {
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp221_ = vala_code_context_get_deprecated (context);
				_tmp222_ = _tmp221_;
				_tmp219_ = !_tmp222_;
			} else {
				_tmp219_ = FALSE;
			}
			if (_tmp219_) {
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				vala_report_warning (_tmp224_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp226_ = _tmp225_;
			if (_tmp226_ == NULL) {
				ValaStruct* _tmp227_;
				ValaMethod* _tmp228_;
				ValaMethod* _tmp229_;
				_tmp227_ = st;
				_tmp228_ = vala_struct_get_default_construction_method (_tmp227_);
				_tmp229_ = _tmp228_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp229_);
			}
			_tmp233_ = vala_code_context_get_profile (context);
			_tmp234_ = _tmp233_;
			if (_tmp234_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp235_;
				_tmp235_ = st;
				_tmp232_ = vala_struct_is_simple_type (_tmp235_);
			} else {
				_tmp232_ = FALSE;
			}
			if (_tmp232_) {
				ValaSymbol* _tmp236_;
				ValaSymbol* _tmp237_;
				_tmp236_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp237_ = _tmp236_;
				_tmp231_ = _tmp237_ == NULL;
			} else {
				_tmp231_ = FALSE;
			}
			if (_tmp231_) {
				ValaList* _tmp238_;
				gint _tmp239_;
				gint _tmp240_;
				_tmp238_ = self->priv->object_initializer;
				_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
				_tmp240_ = _tmp239_;
				_tmp230_ = _tmp240_ == 0;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSourceReference* _tmp241_;
				ValaSourceReference* _tmp242_;
				ValaStruct* _tmp243_;
				gchar* _tmp244_;
				gchar* _tmp245_;
				gchar* _tmp246_;
				gchar* _tmp247_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp242_ = _tmp241_;
				_tmp243_ = st;
				_tmp244_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp245_);
				_tmp247_ = _tmp246_;
				vala_report_error (_tmp242_, _tmp247_);
				_g_free0 (_tmp247_);
				_g_free0 (_tmp245_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp248_ = expected_num_type_args;
	_tmp249_ = given_num_type_args;
	if (_tmp248_ > _tmp249_) {
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp251_ = _tmp250_;
		vala_report_error (_tmp251_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp252_;
		gint _tmp253_;
		_tmp252_ = expected_num_type_args;
		_tmp253_ = given_num_type_args;
		if (_tmp252_ < _tmp253_) {
			ValaSourceReference* _tmp254_;
			ValaSourceReference* _tmp255_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp255_ = _tmp254_;
			vala_report_error (_tmp255_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp257_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp258_ = _tmp257_;
	if (_tmp258_ == NULL) {
		ValaList* _tmp259_;
		ValaList* _tmp260_;
		gint _tmp261_;
		gint _tmp262_;
		_tmp259_ = vala_object_creation_expression_get_argument_list (self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
		_tmp262_ = _tmp261_;
		_tmp256_ = _tmp262_ != 0;
		_vala_iterable_unref0 (_tmp260_);
	} else {
		_tmp256_ = FALSE;
	}
	if (_tmp256_) {
		ValaSourceReference* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaTypeSymbol* _tmp265_;
		gchar* _tmp266_;
		gchar* _tmp267_;
		gchar* _tmp268_;
		gchar* _tmp269_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = type;
		_tmp266_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp267_);
		_tmp269_ = _tmp268_;
		vala_report_error (_tmp264_, _tmp269_);
		_g_free0 (_tmp269_);
		_g_free0 (_tmp267_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp270_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp271_ = _tmp270_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp271_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp272_;
		ValaSymbol* _tmp273_;
		ValaMethod* _tmp274_;
		gboolean _tmp275_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp294_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp295_;
		ValaIterator* _tmp296_;
		ValaMethod* _tmp329_;
		gboolean _tmp330_;
		gboolean _tmp331_;
		ValaSemanticAnalyzer* _tmp396_;
		ValaSemanticAnalyzer* _tmp397_;
		ValaMethod* _tmp398_;
		ValaMethodType* _tmp399_;
		ValaMethodType* _tmp400_;
		ValaMethod* _tmp401_;
		ValaList* _tmp402_;
		ValaList* _tmp403_;
		ValaList* _tmp404_;
		_tmp272_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp274_;
		_tmp275_ = self->priv->_is_yield_expression;
		if (_tmp275_) {
			ValaMethod* _tmp276_;
			gboolean _tmp277_;
			gboolean _tmp278_;
			gboolean _tmp281_ = FALSE;
			ValaSemanticAnalyzer* _tmp282_;
			ValaSemanticAnalyzer* _tmp283_;
			ValaMethod* _tmp284_;
			ValaMethod* _tmp285_;
			_tmp276_ = m;
			_tmp277_ = vala_method_get_coroutine (_tmp276_);
			_tmp278_ = _tmp277_;
			if (!_tmp278_) {
				ValaSourceReference* _tmp279_;
				ValaSourceReference* _tmp280_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp280_ = _tmp279_;
				vala_report_error (_tmp280_, "yield expression requires async method");
			}
			_tmp282_ = vala_code_context_get_analyzer (context);
			_tmp283_ = _tmp282_;
			_tmp284_ = vala_semantic_analyzer_get_current_method (_tmp283_);
			_tmp285_ = _tmp284_;
			if (_tmp285_ == NULL) {
				_tmp281_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp286_;
				ValaSemanticAnalyzer* _tmp287_;
				ValaMethod* _tmp288_;
				ValaMethod* _tmp289_;
				gboolean _tmp290_;
				gboolean _tmp291_;
				_tmp286_ = vala_code_context_get_analyzer (context);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_semantic_analyzer_get_current_method (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_method_get_coroutine (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp281_ = !_tmp291_;
			}
			if (_tmp281_) {
				ValaSourceReference* _tmp292_;
				ValaSourceReference* _tmp293_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp293_ = _tmp292_;
				vala_report_error (_tmp293_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp294_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp294_;
		_tmp295_ = args;
		_tmp296_ = vala_iterable_iterator ((ValaIterable*) _tmp295_);
		arg_it = _tmp296_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp297_;
			ValaList* _tmp298_;
			gint _param_size = 0;
			ValaList* _tmp299_;
			gint _tmp300_;
			gint _tmp301_;
			gint _param_index = 0;
			_tmp297_ = m;
			_tmp298_ = vala_callable_get_parameters ((ValaCallable*) _tmp297_);
			_param_list = _tmp298_;
			_tmp299_ = _param_list;
			_tmp300_ = vala_collection_get_size ((ValaCollection*) _tmp299_);
			_tmp301_ = _tmp300_;
			_param_size = _tmp301_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp302_;
				gint _tmp303_;
				gint _tmp304_;
				ValaParameter* param = NULL;
				ValaList* _tmp305_;
				gint _tmp306_;
				gpointer _tmp307_;
				ValaParameter* _tmp308_;
				ValaParameter* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				ValaIterator* _tmp312_;
				_tmp302_ = _param_index;
				_param_index = _tmp302_ + 1;
				_tmp303_ = _param_index;
				_tmp304_ = _param_size;
				if (!(_tmp303_ < _tmp304_)) {
					break;
				}
				_tmp305_ = _param_list;
				_tmp306_ = _param_index;
				_tmp307_ = vala_list_get (_tmp305_, _tmp306_);
				param = (ValaParameter*) _tmp307_;
				_tmp308_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp308_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp309_ = param;
				_tmp310_ = vala_parameter_get_ellipsis (_tmp309_);
				_tmp311_ = _tmp310_;
				if (_tmp311_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp312_ = arg_it;
				if (vala_iterator_next (_tmp312_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp313_;
					gpointer _tmp314_;
					ValaExpression* _tmp315_;
					ValaParameter* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaExpression* _tmp319_;
					ValaExpression* _tmp320_;
					ValaDataType* _tmp321_;
					ValaDataType* _tmp322_;
					ValaDataType* _tmp323_;
					ValaDataType* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaExpression* _tmp327_;
					ValaExpression* _tmp328_;
					_tmp313_ = arg_it;
					_tmp314_ = vala_iterator_get (_tmp313_);
					arg = (ValaExpression*) _tmp314_;
					_tmp315_ = arg;
					_tmp316_ = param;
					_tmp317_ = vala_variable_get_variable_type ((ValaVariable*) _tmp316_);
					_tmp318_ = _tmp317_;
					vala_expression_set_formal_target_type (_tmp315_, _tmp318_);
					_tmp319_ = arg;
					_tmp320_ = arg;
					_tmp321_ = vala_expression_get_formal_target_type (_tmp320_);
					_tmp322_ = _tmp321_;
					_tmp323_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_data_type_get_actual_type (_tmp322_, _tmp324_, NULL, (ValaCodeNode*) self);
					_tmp326_ = _tmp325_;
					vala_expression_set_target_type (_tmp319_, _tmp326_);
					_vala_code_node_unref0 (_tmp326_);
					_tmp327_ = arg;
					_tmp328_ = _vala_code_node_ref0 (_tmp327_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp328_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp329_ = m;
		_tmp330_ = vala_method_get_printf_format (_tmp329_);
		_tmp331_ = _tmp330_;
		if (_tmp331_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp332_;
			ValaStringLiteral* _tmp375_;
			format_literal = NULL;
			_tmp332_ = last_arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp332_, VALA_TYPE_NULL_LITERAL)) {
			} else {
				ValaExpression* _tmp333_;
				_tmp333_ = last_arg;
				if (_tmp333_ != NULL) {
					ValaExpression* _tmp334_;
					ValaStringLiteral* _tmp335_;
					gboolean _tmp336_ = FALSE;
					ValaStringLiteral* _tmp337_;
					_tmp334_ = last_arg;
					_tmp335_ = vala_string_literal_get_format_literal (_tmp334_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp335_;
					_tmp337_ = format_literal;
					if (_tmp337_ == NULL) {
						ValaList* _tmp338_;
						gint _tmp339_;
						gint _tmp340_;
						ValaMethod* _tmp341_;
						ValaList* _tmp342_;
						ValaList* _tmp343_;
						gint _tmp344_;
						gint _tmp345_;
						_tmp338_ = args;
						_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = m;
						_tmp342_ = vala_callable_get_parameters ((ValaCallable*) _tmp341_);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_collection_get_size ((ValaCollection*) _tmp343_);
						_tmp345_ = _tmp344_;
						_tmp336_ = _tmp340_ == (_tmp345_ - 1);
						_vala_iterable_unref0 (_tmp343_);
					} else {
						_tmp336_ = FALSE;
					}
					if (_tmp336_) {
						ValaStringLiteral* _tmp346_;
						ValaStringLiteral* _tmp347_;
						ValaSemanticAnalyzer* _tmp348_;
						ValaSemanticAnalyzer* _tmp349_;
						ValaDataType* _tmp350_;
						ValaDataType* _tmp351_;
						ValaDataType* _tmp352_;
						ValaList* _tmp353_;
						ValaList* _tmp354_;
						gint _tmp355_;
						gint _tmp356_;
						ValaStringLiteral* _tmp357_;
						ValaList* _tmp358_;
						ValaIterator* _tmp359_;
						_tmp346_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp346_;
						_tmp347_ = format_literal;
						_tmp348_ = vala_code_context_get_analyzer (context);
						_tmp349_ = _tmp348_;
						_tmp350_ = _tmp349_->string_type;
						_tmp351_ = vala_data_type_copy (_tmp350_);
						_tmp352_ = _tmp351_;
						vala_expression_set_target_type ((ValaExpression*) _tmp347_, _tmp352_);
						_vala_code_node_unref0 (_tmp352_);
						_tmp353_ = self->priv->argument_list;
						_tmp354_ = args;
						_tmp355_ = vala_collection_get_size ((ValaCollection*) _tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = format_literal;
						vala_list_insert (_tmp353_, _tmp356_ - 1, (ValaExpression*) _tmp357_);
						_tmp358_ = self->priv->argument_list;
						_tmp359_ = vala_iterable_iterator ((ValaIterable*) _tmp358_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp359_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp360_;
							ValaList* _tmp361_;
							gint _param_size = 0;
							ValaList* _tmp362_;
							gint _tmp363_;
							gint _tmp364_;
							gint _param_index = 0;
							_tmp360_ = m;
							_tmp361_ = vala_callable_get_parameters ((ValaCallable*) _tmp360_);
							_param_list = _tmp361_;
							_tmp362_ = _param_list;
							_tmp363_ = vala_collection_get_size ((ValaCollection*) _tmp362_);
							_tmp364_ = _tmp363_;
							_param_size = _tmp364_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp365_;
								gint _tmp366_;
								gint _tmp367_;
								ValaParameter* param = NULL;
								ValaList* _tmp368_;
								gint _tmp369_;
								gpointer _tmp370_;
								ValaParameter* _tmp371_;
								gboolean _tmp372_;
								gboolean _tmp373_;
								ValaIterator* _tmp374_;
								_tmp365_ = _param_index;
								_param_index = _tmp365_ + 1;
								_tmp366_ = _param_index;
								_tmp367_ = _param_size;
								if (!(_tmp366_ < _tmp367_)) {
									break;
								}
								_tmp368_ = _param_list;
								_tmp369_ = _param_index;
								_tmp370_ = vala_list_get (_tmp368_, _tmp369_);
								param = (ValaParameter*) _tmp370_;
								_tmp371_ = param;
								_tmp372_ = vala_parameter_get_ellipsis (_tmp371_);
								_tmp373_ = _tmp372_;
								if (_tmp373_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp374_ = arg_it;
								vala_iterator_next (_tmp374_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp375_ = format_literal;
			if (_tmp375_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp376_;
				gchar* _tmp377_;
				ValaSemanticAnalyzer* _tmp378_;
				ValaSemanticAnalyzer* _tmp379_;
				const gchar* _tmp380_;
				ValaIterator* _tmp381_;
				ValaSourceReference* _tmp382_;
				ValaSourceReference* _tmp383_;
				_tmp376_ = format_literal;
				_tmp377_ = vala_string_literal_eval (_tmp376_);
				format = _tmp377_;
				_tmp378_ = vala_code_context_get_analyzer (context);
				_tmp379_ = _tmp378_;
				_tmp380_ = format;
				_tmp381_ = arg_it;
				_tmp382_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp383_ = _tmp382_;
				if (!vala_semantic_analyzer_check_print_format (_tmp379_, _tmp380_, _tmp381_, _tmp383_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp384_;
			ValaList* _tmp385_;
			gint _arg_size = 0;
			ValaList* _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gint _arg_index = 0;
			_tmp384_ = args;
			_tmp385_ = _vala_iterable_ref0 (_tmp384_);
			_arg_list = _tmp385_;
			_tmp386_ = _arg_list;
			_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
			_tmp388_ = _tmp387_;
			_arg_size = _tmp388_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp389_;
				gint _tmp390_;
				gint _tmp391_;
				ValaExpression* arg = NULL;
				ValaList* _tmp392_;
				gint _tmp393_;
				gpointer _tmp394_;
				ValaExpression* _tmp395_;
				_tmp389_ = _arg_index;
				_arg_index = _tmp389_ + 1;
				_tmp390_ = _arg_index;
				_tmp391_ = _arg_size;
				if (!(_tmp390_ < _tmp391_)) {
					break;
				}
				_tmp392_ = _arg_list;
				_tmp393_ = _arg_index;
				_tmp394_ = vala_list_get (_tmp392_, _tmp393_);
				arg = (ValaExpression*) _tmp394_;
				_tmp395_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp396_ = vala_code_context_get_analyzer (context);
		_tmp397_ = _tmp396_;
		_tmp398_ = m;
		_tmp399_ = vala_method_type_new (_tmp398_);
		_tmp400_ = _tmp399_;
		_tmp401_ = m;
		_tmp402_ = vala_callable_get_parameters ((ValaCallable*) _tmp401_);
		_tmp403_ = _tmp402_;
		_tmp404_ = args;
		vala_semantic_analyzer_check_arguments (_tmp397_, (ValaExpression*) self, (ValaDataType*) _tmp400_, _tmp403_, _tmp404_);
		_vala_iterable_unref0 (_tmp403_);
		_vala_code_node_unref0 (_tmp400_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp405_;
			ValaList* _tmp406_;
			gint _error_type_size = 0;
			ValaList* _tmp407_;
			gint _tmp408_;
			gint _tmp409_;
			gint _error_type_index = 0;
			_tmp405_ = m;
			_tmp406_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp405_);
			_error_type_list = _tmp406_;
			_tmp407_ = _error_type_list;
			_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
			_tmp409_ = _tmp408_;
			_error_type_size = _tmp409_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp410_;
				gint _tmp411_;
				gint _tmp412_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp413_;
				gint _tmp414_;
				gpointer _tmp415_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp416_;
				ValaDataType* _tmp417_;
				ValaDataType* _tmp418_;
				ValaSourceReference* _tmp419_;
				ValaSourceReference* _tmp420_;
				ValaDataType* _tmp421_;
				_tmp410_ = _error_type_index;
				_error_type_index = _tmp410_ + 1;
				_tmp411_ = _error_type_index;
				_tmp412_ = _error_type_size;
				if (!(_tmp411_ < _tmp412_)) {
					break;
				}
				_tmp413_ = _error_type_list;
				_tmp414_ = _error_type_index;
				_tmp415_ = vala_list_get (_tmp413_, _tmp414_);
				error_type = (ValaDataType*) _tmp415_;
				may_throw = TRUE;
				_tmp416_ = error_type;
				_tmp417_ = vala_data_type_copy (_tmp416_);
				call_error_type = _tmp417_;
				_tmp418_ = call_error_type;
				_tmp419_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp420_ = _tmp419_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp418_, _tmp420_);
				_tmp421_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp421_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp422_;
		ValaDataType* _tmp423_;
		_tmp422_ = vala_object_creation_expression_get_type_reference (self);
		_tmp423_ = _tmp422_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp423_, VALA_TYPE_ERROR_TYPE)) {
			ValaDataType* _tmp424_;
			ValaDataType* _tmp425_;
			ValaMemberAccess* _tmp428_;
			ValaMemberAccess* _tmp429_;
			ValaList* _tmp456_;
			ValaList* _tmp457_;
			gint _tmp458_;
			gint _tmp459_;
			gboolean _tmp460_;
			_tmp424_ = vala_object_creation_expression_get_type_reference (self);
			_tmp425_ = _tmp424_;
			if (_tmp425_ != NULL) {
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				_tmp426_ = vala_object_creation_expression_get_type_reference (self);
				_tmp427_ = _tmp426_;
				vala_code_node_check ((ValaCodeNode*) _tmp427_, context);
			}
			_tmp428_ = vala_object_creation_expression_get_member_name (self);
			_tmp429_ = _tmp428_;
			if (_tmp429_ != NULL) {
				ValaMemberAccess* _tmp430_;
				ValaMemberAccess* _tmp431_;
				_tmp430_ = vala_object_creation_expression_get_member_name (self);
				_tmp431_ = _tmp430_;
				vala_code_node_check ((ValaCodeNode*) _tmp431_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp432_;
				ValaList* _tmp433_;
				gint _arg_size = 0;
				ValaList* _tmp434_;
				gint _tmp435_;
				gint _tmp436_;
				gint _arg_index = 0;
				_tmp432_ = self->priv->argument_list;
				_tmp433_ = _vala_iterable_ref0 (_tmp432_);
				_arg_list = _tmp433_;
				_tmp434_ = _arg_list;
				_tmp435_ = vala_collection_get_size ((ValaCollection*) _tmp434_);
				_tmp436_ = _tmp435_;
				_arg_size = _tmp436_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp437_;
					gint _tmp438_;
					gint _tmp439_;
					ValaExpression* arg = NULL;
					ValaList* _tmp440_;
					gint _tmp441_;
					gpointer _tmp442_;
					ValaExpression* _tmp443_;
					_tmp437_ = _arg_index;
					_arg_index = _tmp437_ + 1;
					_tmp438_ = _arg_index;
					_tmp439_ = _arg_size;
					if (!(_tmp438_ < _tmp439_)) {
						break;
					}
					_tmp440_ = _arg_list;
					_tmp441_ = _arg_index;
					_tmp442_ = vala_list_get (_tmp440_, _tmp441_);
					arg = (ValaExpression*) _tmp442_;
					_tmp443_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp443_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp444_;
				ValaList* _tmp445_;
				gint _init_size = 0;
				ValaList* _tmp446_;
				gint _tmp447_;
				gint _tmp448_;
				gint _init_index = 0;
				_tmp444_ = self->priv->object_initializer;
				_tmp445_ = _vala_iterable_ref0 (_tmp444_);
				_init_list = _tmp445_;
				_tmp446_ = _init_list;
				_tmp447_ = vala_collection_get_size ((ValaCollection*) _tmp446_);
				_tmp448_ = _tmp447_;
				_init_size = _tmp448_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp449_;
					gint _tmp450_;
					gint _tmp451_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp452_;
					gint _tmp453_;
					gpointer _tmp454_;
					ValaMemberInitializer* _tmp455_;
					_tmp449_ = _init_index;
					_init_index = _tmp449_ + 1;
					_tmp450_ = _init_index;
					_tmp451_ = _init_size;
					if (!(_tmp450_ < _tmp451_)) {
						break;
					}
					_tmp452_ = _init_list;
					_tmp453_ = _init_index;
					_tmp454_ = vala_list_get (_tmp452_, _tmp453_);
					init = (ValaMemberInitializer*) _tmp454_;
					_tmp455_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp455_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp456_ = vala_object_creation_expression_get_argument_list (self);
			_tmp457_ = _tmp456_;
			_tmp458_ = vala_collection_get_size ((ValaCollection*) _tmp457_);
			_tmp459_ = _tmp458_;
			_tmp460_ = _tmp459_ == 0;
			_vala_iterable_unref0 (_tmp457_);
			if (_tmp460_) {
				ValaSourceReference* _tmp461_;
				ValaSourceReference* _tmp462_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp462_ = _tmp461_;
				vala_report_error (_tmp462_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp463_;
				ValaList* _tmp464_;
				ValaIterator* _tmp465_;
				ValaIterator* _tmp466_;
				ValaIterator* _tmp467_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp468_;
				gpointer _tmp469_;
				gboolean _tmp470_ = FALSE;
				ValaExpression* _tmp471_;
				ValaDataType* _tmp472_;
				ValaDataType* _tmp473_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp482_;
				ValaStringLiteral* _tmp483_;
				ValaStringLiteral* _tmp484_;
				ValaList* _tmp493_;
				ValaList* _tmp494_;
				ValaIterator* _tmp495_;
				ValaIterator* _tmp496_;
				ValaSemanticAnalyzer* _tmp497_;
				ValaSemanticAnalyzer* _tmp498_;
				ValaIterator* _tmp499_;
				ValaSourceReference* _tmp500_;
				ValaSourceReference* _tmp501_;
				_tmp463_ = vala_object_creation_expression_get_argument_list (self);
				_tmp464_ = _tmp463_;
				_tmp465_ = vala_iterable_iterator ((ValaIterable*) _tmp464_);
				_tmp466_ = _tmp465_;
				_vala_iterable_unref0 (_tmp464_);
				arg_it = _tmp466_;
				_tmp467_ = arg_it;
				vala_iterator_next (_tmp467_);
				_tmp468_ = arg_it;
				_tmp469_ = vala_iterator_get (_tmp468_);
				ex = (ValaExpression*) _tmp469_;
				_tmp471_ = ex;
				_tmp472_ = vala_expression_get_value_type (_tmp471_);
				_tmp473_ = _tmp472_;
				if (_tmp473_ == NULL) {
					_tmp470_ = TRUE;
				} else {
					ValaExpression* _tmp474_;
					ValaDataType* _tmp475_;
					ValaDataType* _tmp476_;
					ValaSemanticAnalyzer* _tmp477_;
					ValaSemanticAnalyzer* _tmp478_;
					ValaDataType* _tmp479_;
					_tmp474_ = ex;
					_tmp475_ = vala_expression_get_value_type (_tmp474_);
					_tmp476_ = _tmp475_;
					_tmp477_ = vala_code_context_get_analyzer (context);
					_tmp478_ = _tmp477_;
					_tmp479_ = _tmp478_->string_type;
					_tmp470_ = !vala_data_type_compatible (_tmp476_, _tmp479_);
				}
				if (_tmp470_) {
					ValaSourceReference* _tmp480_;
					ValaSourceReference* _tmp481_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp481_ = _tmp480_;
					vala_report_error (_tmp481_, "Invalid type for argument 1");
				}
				_tmp482_ = ex;
				_tmp483_ = vala_string_literal_get_format_literal (_tmp482_);
				format_literal = _tmp483_;
				_tmp484_ = format_literal;
				if (_tmp484_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp485_;
					gchar* _tmp486_;
					ValaSemanticAnalyzer* _tmp487_;
					ValaSemanticAnalyzer* _tmp488_;
					const gchar* _tmp489_;
					ValaIterator* _tmp490_;
					ValaSourceReference* _tmp491_;
					ValaSourceReference* _tmp492_;
					_tmp485_ = format_literal;
					_tmp486_ = vala_string_literal_eval (_tmp485_);
					format = _tmp486_;
					_tmp487_ = vala_code_context_get_analyzer (context);
					_tmp488_ = _tmp487_;
					_tmp489_ = format;
					_tmp490_ = arg_it;
					_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp492_ = _tmp491_;
					if (!vala_semantic_analyzer_check_print_format (_tmp488_, _tmp489_, _tmp490_, _tmp492_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp493_ = vala_object_creation_expression_get_argument_list (self);
				_tmp494_ = _tmp493_;
				_tmp495_ = vala_iterable_iterator ((ValaIterable*) _tmp494_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp495_;
				_vala_iterable_unref0 (_tmp494_);
				_tmp496_ = arg_it;
				vala_iterator_next (_tmp496_);
				_tmp497_ = vala_code_context_get_analyzer (context);
				_tmp498_ = _tmp497_;
				_tmp499_ = arg_it;
				_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp501_ = _tmp500_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp498_, _tmp499_, 1, _tmp501_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp502_;
		gint _init_size = 0;
		ValaList* _tmp503_;
		gint _tmp504_;
		gint _tmp505_;
		gint _init_index = 0;
		_tmp502_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp502_;
		_tmp503_ = _init_list;
		_tmp504_ = vala_collection_get_size ((ValaCollection*) _tmp503_);
		_tmp505_ = _tmp504_;
		_init_size = _tmp505_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp506_;
			gint _tmp507_;
			gint _tmp508_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp509_;
			gint _tmp510_;
			gpointer _tmp511_;
			ValaSemanticAnalyzer* _tmp512_;
			ValaSemanticAnalyzer* _tmp513_;
			ValaMemberInitializer* _tmp514_;
			ValaDataType* _tmp515_;
			ValaDataType* _tmp516_;
			_tmp506_ = _init_index;
			_init_index = _tmp506_ + 1;
			_tmp507_ = _init_index;
			_tmp508_ = _init_size;
			if (!(_tmp507_ < _tmp508_)) {
				break;
			}
			_tmp509_ = _init_list;
			_tmp510_ = _init_index;
			_tmp511_ = vala_list_get (_tmp509_, _tmp510_);
			init = (ValaMemberInitializer*) _tmp511_;
			_tmp512_ = vala_code_context_get_analyzer (context);
			_tmp513_ = _tmp512_;
			_tmp514_ = init;
			_tmp515_ = vala_object_creation_expression_get_type_reference (self);
			_tmp516_ = _tmp515_;
			vala_semantic_analyzer_visit_member_initializer (_tmp513_, _tmp514_, _tmp516_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp517_ = may_throw;
	if (_tmp517_) {
		gboolean _tmp518_ = FALSE;
		ValaCodeNode* _tmp519_;
		ValaCodeNode* _tmp520_;
		_tmp519_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp520_ = _tmp519_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp518_ = TRUE;
		} else {
			ValaCodeNode* _tmp521_;
			ValaCodeNode* _tmp522_;
			_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp522_ = _tmp521_;
			_tmp518_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp522_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp518_) {
		} else {
			ValaSemanticAnalyzer* _tmp523_;
			ValaSemanticAnalyzer* _tmp524_;
			ValaSymbol* _tmp525_;
			ValaSymbol* _tmp526_;
			_tmp523_ = vala_code_context_get_analyzer (context);
			_tmp524_ = _tmp523_;
			_tmp525_ = vala_semantic_analyzer_get_current_symbol (_tmp524_);
			_tmp526_ = _tmp525_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp526_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp527_;
				ValaSourceReference* _tmp528_;
				_tmp527_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp528_ = _tmp527_;
				vala_report_error (_tmp528_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp529_;
				ValaCodeNode* _tmp530_;
				ValaCodeNode* _tmp531_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp532_;
				ValaDataType* _tmp533_;
				ValaDataType* _tmp534_;
				ValaDataType* _tmp535_;
				gchar* _tmp536_;
				gchar* _tmp537_;
				ValaSourceReference* _tmp538_;
				ValaSourceReference* _tmp539_;
				ValaLocalVariable* _tmp540_;
				ValaLocalVariable* _tmp541_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp542_;
				ValaSourceReference* _tmp543_;
				ValaSourceReference* _tmp544_;
				ValaDeclarationStatement* _tmp545_;
				ValaSemanticAnalyzer* _tmp546_;
				ValaSemanticAnalyzer* _tmp547_;
				ValaBlock* _tmp548_;
				ValaDeclarationStatement* _tmp549_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp550_;
				ValaDataType* _tmp551_;
				ValaDataType* _tmp552_;
				ValaExpression* _tmp553_;
				ValaLocalVariable* _tmp554_;
				ValaDeclarationStatement* _tmp555_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp556_;
				ValaSemanticAnalyzer* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp559_;
				ValaBlock* _tmp560_;
				ValaBlock* _tmp561_;
				ValaLocalVariable* _tmp562_;
				ValaSemanticAnalyzer* _tmp563_;
				ValaSemanticAnalyzer* _tmp564_;
				ValaBlock* _tmp565_;
				ValaLocalVariable* _tmp566_;
				ValaCodeNode* _tmp567_;
				ValaExpression* _tmp568_;
				ValaExpression* _tmp569_;
				_tmp529_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp530_ = _tmp529_;
				_tmp531_ = _vala_code_node_ref0 (_tmp530_);
				old_parent_node = _tmp531_;
				_tmp532_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp533_ = _tmp532_;
				_tmp534_ = vala_data_type_copy (_tmp533_);
				_tmp535_ = _tmp534_;
				_tmp536_ = vala_code_node_get_temp_name ();
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp539_ = _tmp538_;
				_tmp540_ = vala_local_variable_new (_tmp535_, _tmp537_, NULL, _tmp539_);
				_tmp541_ = _tmp540_;
				_g_free0 (_tmp537_);
				_vala_code_node_unref0 (_tmp535_);
				local = _tmp541_;
				_tmp542_ = local;
				_tmp543_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_declaration_statement_new ((ValaSymbol*) _tmp542_, _tmp544_);
				decl = _tmp545_;
				_tmp546_ = vala_code_context_get_analyzer (context);
				_tmp547_ = _tmp546_;
				_tmp548_ = _tmp547_->insert_block;
				_tmp549_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp548_, (ValaStatement*) _tmp549_);
				_tmp550_ = local;
				_tmp551_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp552_ = _tmp551_;
				_tmp553_ = vala_semantic_analyzer_create_temp_access (_tmp550_, _tmp552_);
				temp_access = _tmp553_;
				_tmp554_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp554_, (ValaExpression*) self);
				_tmp555_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp555_, context);
				_tmp556_ = vala_code_context_get_analyzer (context);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_semantic_analyzer_get_current_symbol (_tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp559_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp560_;
				_tmp561_ = block;
				_tmp562_ = local;
				vala_block_remove_local_variable (_tmp561_, _tmp562_);
				_tmp563_ = vala_code_context_get_analyzer (context);
				_tmp564_ = _tmp563_;
				_tmp565_ = _tmp564_->insert_block;
				_tmp566_ = local;
				vala_block_add_local_variable (_tmp565_, _tmp566_);
				_tmp567_ = old_parent_node;
				_tmp568_ = temp_access;
				vala_code_node_replace_expression (_tmp567_, (ValaExpression*) self, _tmp568_);
				_tmp569_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp569_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp570_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp571_ = _tmp570_;
	result = !_tmp571_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp23_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp23_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



