/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosprefs_account.h"

UosPrefsAccount *uos_prefs_account_new(void){
     return prefs_account_new();
}

UosPrefsAccount *uos_prefs_account_get_tmp_prefs(void){
    return prefs_account_get_tmp_prefs();
}

void uos_prefs_account_set_tmp_prefs(UosPrefsAccount *ac_prefs){
    prefs_account_set_tmp_prefs(ac_prefs);
}

void uos_prefs_account_apply_tmp_prefs(UosPrefsAccount *ac_prefs){
    prefs_account_apply_tmp_prefs(ac_prefs);
}

UosPrefParam *uos_prefs_account_get_params(void){
    return prefs_account_get_params();
}


void uos_prefs_account_read_config(UosPrefsAccount *ac_prefs,
                               const gchar *label){
    prefs_account_read_config(ac_prefs,label);
}

void uos_prefs_account_write_config_all(GList *account_list){
    prefs_account_write_config_all(account_list);
}


void uos_account_free(UosPrefsAccount *ap){
    account_free(ap);
}

void uos_prefs_account_free(UosPrefsAccount *ac_prefs){
    prefs_account_free(ac_prefs);
}

