#ifndef COMPAT_H
#define COMPAT_H

#if HAVE_CONFIG_H
# include "config.h"
#endif

// TEMP_FAILURE_RETRY is a GNUism
#ifndef TEMP_FAILURE_RETRY
# define TEMP_FAILURE_RETRY(expr) \
	({ \
		long int _result; \
		do _result = (long int) (expr); \
		while (_result == -1L && errno == EINTR); \
		_result; \
	})
#endif
// GNU's and the above TEMP_FAILURE_RETRY both need errno.h
#include <errno.h>

#ifdef NOTIFY_INOTIFY
# ifdef HAVE_SYS_INOTIFY_H
#  include <sys/inotify.h>
# else
#  include "inotify.h"
#  include "inotify-syscalls.h"
# endif
#endif

#endif // COMPAT_H
