# Contributing to SFCGAL

First off, thank you for considering contributing to SFCGAL! Your help is greatly appreciated.

## How to Contribute

### Reporting Bugs

If you find a bug, please report it by [creating an issue](https://gitlab.com/sfcgal/SFCGAL/-/issues) in our issue tracker. Before doing so, please check if the issue has already been reported.

When reporting a bug, please include:
- A clear and descriptive title.
- A detailed description of the problem.
- Steps to reproduce the issue.
- Any relevant logs or screenshots.
- The version of SFCGAL you are using.

### Suggesting Enhancements

If you have an idea for an enhancement, please [open an issue](https://gitlab.com/sfcgal/SFCGAL/-/issues) with the following details:
- A clear and descriptive title.
- A detailed description of the proposed enhancement.
- Any relevant use cases or examples.
- Why you believe this enhancement would be beneficial.

### Pull Requests

We welcome pull requests for bug fixes, new features, and documentation improvements. To submit a pull request:

1. Fork the repository.
2. Create a new branch (`git checkout -b feature/YourFeature`).
3. Make your changes.
4. Commit your changes (`git commit -am 'Add new feature'`).
5. Push to the branch (`git push origin feature/YourFeature`).
6. Create a new pull request.

### Coding Standards

Please follow these guidelines to ensure consistency and quality across the codebase:
- Write clear, concise, and meaningful commit messages.
- Adhere to the existing coding style and conventions.
- Include comments and documentation where appropriate.
- Write tests for new features and bug fixes.

### Commit linter

We use the linter [commitizen](https://github.com/commitizen-tools/commitizen) with the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) configuration (the default one).

The commit message writing process can be guided by using `cz commit` instead of `git commit`.

### Code of Conduct

By participating in this project, you agree to abide by our [Code of Conduct](./CODE_OF_CONDUCT.md). Please be respectful and considerate in your interactions with others.

### Getting Help

If you need help or have any questions, feel free to reach out by [opening an issue](https://gitlab.com/sfcgal/SFCGAL/-/issues) or joining our community discussions on IRC #sfcgal channel on [libera.chat](https://libera.chat/guides/connect) server or via the [webchat](https://web.libera.chat/#sfcgal).

## Additional Resources

- [Documentation](https://sfcgal.gitlab.io/SFCGAL/)
- [Issue Tracker](https://gitlab.com/sfcgal/SFCGAL/-/issues)
- [Source Code](https://gitlab.com/sfcgal/SFCGAL)

Thank you for contributing to SFCGAL!
