/* automatically generated by rust-bindgen, manually modified */

extern "C" {
    #[link_name = "\u{1}NK_PWS_SLOT_COUNT"]
    pub static mut NK_PWS_SLOT_COUNT: u8;
}
pub const MAXIMUM_STR_REPLY_LENGTH: ::std::os::raw::c_int = 8192;
/// Use, if no supported device is connected
pub const NK_device_model_NK_DISCONNECTED: NK_device_model = 0;
/// Nitrokey Pro.
pub const NK_device_model_NK_PRO: NK_device_model = 1;
/// Nitrokey Storage.
pub const NK_device_model_NK_STORAGE: NK_device_model = 2;
/// The Nitrokey device models supported by the API.
pub type NK_device_model = u32;
/// The connection info for a Nitrokey device as a linked list.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_device_info {
    /// The model of the Nitrokey device.
    pub model: NK_device_model,
    /// The USB device path for NK_connect_with_path.
    pub path: *mut ::std::os::raw::c_char,
    /// The serial number.
    pub serial_number: *mut ::std::os::raw::c_char,
    /// The pointer to the next element of the linked list or null
    /// if this is the last element in the list.
    pub next: *mut NK_device_info,
}
#[test]
fn bindgen_test_layout_NK_device_info() {
    assert_eq!(
        ::std::mem::size_of::<NK_device_info>(),
        32usize,
        concat!("Size of: ", stringify!(NK_device_info))
    );
    assert_eq!(
        ::std::mem::align_of::<NK_device_info>(),
        8usize,
        concat!("Alignment of ", stringify!(NK_device_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_device_info>())).model as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_device_info),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_device_info>())).path as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_device_info),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_device_info>())).serial_number as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_device_info),
            "::",
            stringify!(serial_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_device_info>())).next as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_device_info),
            "::",
            stringify!(next)
        )
    );
}
/// Stores the common device status for all Nitrokey devices.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_status {
    /// The major firmware version, e. g. 0 in v0.40.
    pub firmware_version_major: u8,
    /// The minor firmware version, e. g. 40 in v0.40.
    pub firmware_version_minor: u8,
    /// The serial number of the smart card.
    pub serial_number_smart_card: u32,
    /// The HOTP slot to generate a password from if the numlock
    /// key is pressed twice (slot 0-1, or any other value to
    /// disable the function).
    pub config_numlock: u8,
    /// The HOTP slot to generate a password from if the capslock
    /// key is pressed twice (slot 0-1, or any other value to
    /// disable the function).
    pub config_capslock: u8,
    /// The HOTP slot to generate a password from if the scrolllock
    /// key is pressed twice (slot 0-1, or any other value to
    /// disable the function).
    pub config_scrolllock: u8,
    /// Indicates whether the user password is required to generate
    /// an OTP value.
    pub otp_user_password: bool,
}
#[test]
fn bindgen_test_layout_NK_status() {
    assert_eq!(
        ::std::mem::size_of::<NK_status>(),
        12usize,
        concat!("Size of: ", stringify!(NK_status))
    );
    assert_eq!(
        ::std::mem::align_of::<NK_status>(),
        4usize,
        concat!("Alignment of ", stringify!(NK_status))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_status>())).firmware_version_major as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(firmware_version_major)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_status>())).firmware_version_minor as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(firmware_version_minor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_status>())).serial_number_smart_card as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(serial_number_smart_card)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_status>())).config_numlock as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(config_numlock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_status>())).config_capslock as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(config_capslock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_status>())).config_scrolllock as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(config_scrolllock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<NK_status>())).otp_user_password as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_status),
            "::",
            stringify!(otp_user_password)
        )
    );
}
/// Stores the status of a Storage device.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_storage_status {
    /// Indicates whether the unencrypted volume is read-only.
    pub unencrypted_volume_read_only: bool,
    /// Indicates whether the unencrypted volume is active.
    pub unencrypted_volume_active: bool,
    /// Indicates whether the encrypted volume is read-only.
    pub encrypted_volume_read_only: bool,
    /// Indicates whether the encrypted volume is active.
    pub encrypted_volume_active: bool,
    /// Indicates whether the hidden volume is read-only.
    pub hidden_volume_read_only: bool,
    /// Indicates whether the hidden volume is active.
    pub hidden_volume_active: bool,
    /// The major firmware version, e. g. 0 in v0.40.
    pub firmware_version_major: u8,
    /// The minor firmware version, e. g. 40 in v0.40.
    pub firmware_version_minor: u8,
    /// Indicates whether the firmware is locked.
    pub firmware_locked: bool,
    /// The serial number of the SD card in the Storage stick.
    pub serial_number_sd_card: u32,
    /// The serial number of the smart card in the Storage stick.
    pub serial_number_smart_card: u32,
    /// The number of remaining login attempts for the user PIN.
    pub user_retry_count: u8,
    /// The number of remaining login attempts for the admin PIN.
    pub admin_retry_count: u8,
    /// Indicates whether a new SD card was found.
    pub new_sd_card_found: bool,
    /// Indicates whether the SD card is filled with random characters.
    pub filled_with_random: bool,
    /// Indicates whether the stick has been initialized by generating
    /// the AES keys.
    pub stick_initialized: bool,
}
#[test]
fn bindgen_test_layout_NK_storage_status() {
    assert_eq!(
        ::std::mem::size_of::<NK_storage_status>(),
        28usize,
        concat!("Size of: ", stringify!(NK_storage_status))
    );
    assert_eq!(
        ::std::mem::align_of::<NK_storage_status>(),
        4usize,
        concat!("Alignment of ", stringify!(NK_storage_status))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).unencrypted_volume_read_only as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(unencrypted_volume_read_only)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).unencrypted_volume_active as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(unencrypted_volume_active)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).encrypted_volume_read_only as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(encrypted_volume_read_only)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).encrypted_volume_active as *const _
                as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(encrypted_volume_active)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).hidden_volume_read_only as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(hidden_volume_read_only)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).hidden_volume_active as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(hidden_volume_active)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).firmware_version_major as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(firmware_version_major)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).firmware_version_minor as *const _
                as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(firmware_version_minor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).firmware_locked as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(firmware_locked)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).serial_number_sd_card as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(serial_number_sd_card)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).serial_number_smart_card as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(serial_number_smart_card)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).user_retry_count as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(user_retry_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).admin_retry_count as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(admin_retry_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).new_sd_card_found as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(new_sd_card_found)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).filled_with_random as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(filled_with_random)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_status>())).stick_initialized as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_status),
            "::",
            stringify!(stick_initialized)
        )
    );
}
/// Data about the usage of the SD card.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_SD_usage_data {
    /// The minimum write level, as a percentage of the total card
    /// size.
    pub write_level_min: u8,
    /// The maximum write level, as a percentage of the total card
    /// size.
    pub write_level_max: u8,
}
#[test]
fn bindgen_test_layout_NK_SD_usage_data() {
    assert_eq!(
        ::std::mem::size_of::<NK_SD_usage_data>(),
        2usize,
        concat!("Size of: ", stringify!(NK_SD_usage_data))
    );
    assert_eq!(
        ::std::mem::align_of::<NK_SD_usage_data>(),
        1usize,
        concat!("Alignment of ", stringify!(NK_SD_usage_data))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_SD_usage_data>())).write_level_min as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_SD_usage_data),
            "::",
            stringify!(write_level_min)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_SD_usage_data>())).write_level_max as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_SD_usage_data),
            "::",
            stringify!(write_level_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NK_storage_ProductionTest {
    pub FirmwareVersion_au8: [u8; 2usize],
    pub FirmwareVersionInternal_u8: u8,
    pub SD_Card_Size_u8: u8,
    pub CPU_CardID_u32: u32,
    pub SmartCardID_u32: u32,
    pub SD_CardID_u32: u32,
    pub SC_UserPwRetryCount: u8,
    pub SC_AdminPwRetryCount: u8,
    pub SD_Card_ManufacturingYear_u8: u8,
    pub SD_Card_ManufacturingMonth_u8: u8,
    pub SD_Card_OEM_u16: u16,
    pub SD_WriteSpeed_u16: u16,
    pub SD_Card_Manufacturer_u8: u8,
}
#[test]
fn bindgen_test_layout_NK_storage_ProductionTest() {
    assert_eq!(
        ::std::mem::size_of::<NK_storage_ProductionTest>(),
        28usize,
        concat!("Size of: ", stringify!(NK_storage_ProductionTest))
    );
    assert_eq!(
        ::std::mem::align_of::<NK_storage_ProductionTest>(),
        4usize,
        concat!("Alignment of ", stringify!(NK_storage_ProductionTest))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).FirmwareVersion_au8 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(FirmwareVersion_au8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).FirmwareVersionInternal_u8
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(FirmwareVersionInternal_u8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_Card_Size_u8 as *const _
                as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_Card_Size_u8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).CPU_CardID_u32 as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(CPU_CardID_u32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SmartCardID_u32 as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SmartCardID_u32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_CardID_u32 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_CardID_u32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SC_UserPwRetryCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SC_UserPwRetryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SC_AdminPwRetryCount as *const _
                as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SC_AdminPwRetryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_Card_ManufacturingYear_u8
                as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_Card_ManufacturingYear_u8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_Card_ManufacturingMonth_u8
                as *const _ as usize
        },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_Card_ManufacturingMonth_u8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_Card_OEM_u16 as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_Card_OEM_u16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_WriteSpeed_u16 as *const _
                as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_WriteSpeed_u16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NK_storage_ProductionTest>())).SD_Card_Manufacturer_u8
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NK_storage_ProductionTest),
            "::",
            stringify!(SD_Card_Manufacturer_u8)
        )
    );
}
extern "C" {
    pub fn NK_get_storage_production_info(
        out: *mut NK_storage_ProductionTest,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Set debug level of messages written on stderr
    /// @param state state=True - most messages, state=False - only errors level
    pub fn NK_set_debug(state: bool);
}
extern "C" {
    /// Set debug level of messages written on stderr
    /// @param level (int) 0-lowest verbosity, 5-highest verbosity
    pub fn NK_set_debug_level(level: ::std::os::raw::c_int);
}
extern "C" {
    /// Get the major library version, e. g. the 3 in v3.2.
    /// @return the major library version
    pub fn NK_get_major_library_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    /// Get the minor library version, e. g. the 2 in v3.2.
    /// @return the minor library version
    pub fn NK_get_minor_library_version() -> ::std::os::raw::c_uint;
}
extern "C" {
    /// Get the library version as a string.  This is the output of
    /// `git describe --always` at compile time, for example "v3.3" or
    /// "v3.3-19-gaee920b".
    /// The return value is a string literal and must not be freed.
    /// @return the library version as a string
    pub fn NK_get_library_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    /// Connect to device of given model. Currently library can be connected only to one device at once.
    /// @param device_model char 'S': Nitrokey Storage, 'P': Nitrokey Pro
    /// @return 1 if connected, 0 if wrong model or cannot connect
    pub fn NK_login(device_model: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Connect to device of given model. Currently library can be connected only to one device at once.
    /// @param device_model NK_device_model: NK_PRO: Nitrokey Pro, NK_STORAGE: Nitrokey Storage
    /// @return 1 if connected, 0 if wrong model or cannot connect
    pub fn NK_login_enum(device_model: NK_device_model) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Connect to first available device, starting checking from Pro 1st to Storage 2nd.
    /// @return 1 if connected, 0 if wrong model or cannot connect
    pub fn NK_login_auto() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Disconnect from the device.
    /// @return command processing error code
    pub fn NK_logout() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Query the model of the connected device.
    /// Returns the model of the connected device or NK_DISCONNECTED.
    ///
    /// @return true if a device is connected and the out argument has been set
    pub fn NK_get_device_model() -> NK_device_model;
}
extern "C" {
    /// Return the debug status string. Debug purposes.  This function is
    /// deprecated in favor of NK_get_status_as_string.
    /// @return string representation of the status or an empty string
    /// if the command failed
    #[deprecated(since = "3.5.0", note="use `NK_get_status_as_string` instead")]
    pub fn NK_status() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Return the debug status string. Debug purposes.
    /// @return string representation of the status or an empty string
    /// if the command failed
    pub fn NK_get_status_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get the stick status common to all Nitrokey devices and return the
    /// command processing error code.  If the code is zero, i. e. the
    /// command was successful, the storage status is written to the output
    /// pointer's target.  The output pointer must not be null.
    ///
    /// @param out the output pointer for the status
    /// @return command processing error code
    pub fn NK_get_status(out: *mut NK_status) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Return the device's serial number string in hex.
    /// @return string device's serial number in hex
    pub fn NK_device_serial_number() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get last command processing status. Useful for commands which returns the results of their own and could not return
    /// an error code.
    /// @return previous command processing error code
    pub fn NK_get_last_command_status() -> u8;
}
extern "C" {
    /// Lock device - cancel any user device unlocking.
    /// @return command processing error code
    pub fn NK_lock_device() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Authenticates the user on USER privilages with user_password and sets user's temporary password on device to user_temporary_password.
    /// @param user_password char[25] current user password
    /// @param user_temporary_password char[25] user temporary password to be set on device for further communication (authentication command)
    /// @return command processing error code
    pub fn NK_user_authenticate(
        user_password: *const ::std::os::raw::c_char,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Authenticates the user on ADMIN privilages with admin_password and sets user's temporary password on device to admin_temporary_password.
    /// @param admin_password char[25] current administrator PIN
    /// @param admin_temporary_password char[25] admin temporary password to be set on device for further communication (authentication command)
    /// @return command processing error code
    pub fn NK_first_authenticate(
        admin_password: *const ::std::os::raw::c_char,
        admin_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Execute a factory reset.
    /// @param admin_password char[20] current administrator PIN
    /// @return command processing error code
    pub fn NK_factory_reset(admin_password: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    /// Generates AES key on the device
    /// @param admin_password char[20] current administrator PIN
    /// @return command processing error code
    pub fn NK_build_aes_key(admin_password: *const ::std::os::raw::c_char)
        -> ::std::os::raw::c_int;
}
extern "C" {
    /// Unlock user PIN locked after 3 incorrect codes tries.
    /// @param admin_password char[20] current administrator PIN
    /// @return command processing error code
    pub fn NK_unlock_user_password(
        admin_password: *const ::std::os::raw::c_char,
        new_user_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Write general config to the device
    /// @param numlock set value in range [0-1] to send HOTP code from slot 'numlock' after double pressing numlock
    /// or outside the range to disable this function
    /// @param capslock similar to numlock but with capslock
    /// @param scrolllock similar to numlock but with scrolllock
    /// @param enable_user_password set True to enable OTP PIN protection (require PIN each OTP code request)
    /// @param delete_user_password (unused)
    /// @param admin_temporary_password current admin temporary password
    /// @return command processing error code
    pub fn NK_write_config(
        numlock: u8,
        capslock: u8,
        scrolllock: u8,
        enable_user_password: bool,
        delete_user_password: bool,
        admin_temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get currently set config - status of function Numlock/Capslock/Scrollock OTP sending and is enabled PIN protected OTP
    /// @see NK_write_config
    /// @return  uint8_t general_config[5]:
    /// uint8_t numlock;
    /// uint8_t capslock;
    /// uint8_t scrolllock;
    /// uint8_t enable_user_password;
    /// uint8_t delete_user_password;
    pub fn NK_read_config() -> *mut u8;
}
extern "C" {
    /// Get name of given TOTP slot
    /// @param slot_number TOTP slot number, slot_number<15
    /// @return char[20] the name of the slot
    pub fn NK_get_totp_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// @param slot_number HOTP slot number, slot_number<3
    /// @return char[20] the name of the slot
    pub fn NK_get_hotp_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Erase HOTP slot data from the device
    /// @param slot_number HOTP slot number, slot_number<3
    /// @param temporary_password admin temporary password
    /// @return command processing error code
    pub fn NK_erase_hotp_slot(
        slot_number: u8,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Erase TOTP slot data from the device
    /// @param slot_number TOTP slot number, slot_number<15
    /// @param temporary_password admin temporary password
    /// @return command processing error code
    pub fn NK_erase_totp_slot(
        slot_number: u8,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Write HOTP slot data to the device
    /// @param slot_number HOTP slot number, slot_number<3, 0-numbered
    /// @param slot_name char[15] desired slot name. C string (requires ending '\0'; 16 bytes).
    /// @param secret char[40] 160-bit or 320-bit (currently Pro v0.8 only) secret as a hex string. C string (requires ending '\0'; 41 bytes).
    /// See NitrokeyManager::is_320_OTP_secret_supported.
    /// @param hotp_counter uint32_t starting value of HOTP counter
    /// @param use_8_digits should returned codes be 6 (false) or 8 digits (true)
    /// @param use_enter press ENTER key after sending OTP code using double-pressed scroll/num/capslock
    /// @param use_tokenID @see token_ID
    /// @param token_ID @see https://openauthentication.org/token-specs/, 'Class A' section
    /// @param temporary_password char[25] admin temporary password
    /// @return command processing error code
    pub fn NK_write_hotp_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        secret: *const ::std::os::raw::c_char,
        hotp_counter: u64,
        use_8_digits: bool,
        use_enter: bool,
        use_tokenID: bool,
        token_ID: *const ::std::os::raw::c_char,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Write TOTP slot data to the device
    /// @param slot_number TOTP slot number, slot_number<15, 0-numbered
    /// @param slot_name char[15] desired slot name. C string (requires ending '\0'; 16 bytes).
    /// @param secret char[40] 160-bit or 320-bit (currently Pro v0.8 only) secret as a hex string. C string (requires ending '\0'; 41 bytes).
    /// See NitrokeyManager::is_320_OTP_secret_supported.
    /// @param time_window uint16_t time window for this TOTP
    /// @param use_8_digits should returned codes be 6 (false) or 8 digits (true)
    /// @param use_enter press ENTER key after sending OTP code using double-pressed scroll/num/capslock
    /// @param use_tokenID @see token_ID
    /// @param token_ID @see https://openauthentication.org/token-specs/, 'Class A' section
    /// @param temporary_password char[20] admin temporary password
    /// @return command processing error code
    pub fn NK_write_totp_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        secret: *const ::std::os::raw::c_char,
        time_window: u16,
        use_8_digits: bool,
        use_enter: bool,
        use_tokenID: bool,
        token_ID: *const ::std::os::raw::c_char,
        temporary_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get HOTP code from the device
    /// @param slot_number HOTP slot number, slot_number<3
    /// @return HOTP code
    pub fn NK_get_hotp_code(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get HOTP code from the device (PIN protected)
    /// @param slot_number HOTP slot number, slot_number<3
    /// @param user_temporary_password char[25] user temporary password if PIN protected OTP codes are enabled,
    /// otherwise should be set to empty string - ''
    /// @return HOTP code
    pub fn NK_get_hotp_code_PIN(
        slot_number: u8,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get TOTP code from the device
    /// @param slot_number TOTP slot number, slot_number<15
    /// @param challenge TOTP challenge -- unused
    /// @param last_totp_time last time -- unused
    /// @param last_interval last interval --unused
    /// @return TOTP code
    pub fn NK_get_totp_code(
        slot_number: u8,
        challenge: u64,
        last_totp_time: u64,
        last_interval: u8,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get TOTP code from the device (PIN protected)
    /// @param slot_number TOTP slot number, slot_number<15
    /// @param challenge TOTP challenge -- unused
    /// @param last_totp_time last time -- unused
    /// @param last_interval last interval -- unused
    /// @param user_temporary_password char[25] user temporary password if PIN protected OTP codes are enabled,
    /// otherwise should be set to empty string - ''
    /// @return TOTP code
    pub fn NK_get_totp_code_PIN(
        slot_number: u8,
        challenge: u64,
        last_totp_time: u64,
        last_interval: u8,
        user_temporary_password: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Set time on the device (for TOTP requests)
    /// @param time seconds in unix epoch (from 01.01.1970)
    /// @return command processing error code
    pub fn NK_totp_set_time(time: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Set the device time used for TOTP to the given time.  Contrary to
    /// {@code set_time(uint64_t)}, this command fails if {@code old_time}
    /// &gt; {@code time} or if {@code old_time} is zero (where {@code
    /// old_time} is the current time on the device).
    ///
    /// @param time new device time as Unix timestamp (seconds since
    /// 1970-01-01)
    /// @return command processing error code
    pub fn NK_totp_set_time_soft(time: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[deprecated(since = "3.4.0", note="use `NK_totp_set_time_soft` instead")]
    pub fn NK_totp_get_time() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Change administrator PIN
    /// @param current_PIN char[25] current PIN
    /// @param new_PIN char[25] new PIN
    /// @return command processing error code
    pub fn NK_change_admin_PIN(
        current_PIN: *const ::std::os::raw::c_char,
        new_PIN: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Change user PIN
    /// @param current_PIN char[25] current PIN
    /// @param new_PIN char[25] new PIN
    /// @return command processing error code
    pub fn NK_change_user_PIN(
        current_PIN: *const ::std::os::raw::c_char,
        new_PIN: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get retry count of user PIN
    /// @return user PIN retry count
    pub fn NK_get_user_retry_count() -> u8;
}
extern "C" {
    /// Get retry count of admin PIN
    /// @return admin PIN retry count
    pub fn NK_get_admin_retry_count() -> u8;
}
extern "C" {
    /// Enable password safe access
    /// @param user_pin char[30] current user PIN
    /// @return command processing error code
    pub fn NK_enable_password_safe(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get password safe slots' status
    /// @return uint8_t[16] slot statuses - each byte represents one slot with 0 (not programmed) and 1 (programmed)
    pub fn NK_get_password_safe_slot_status() -> *mut u8;
}
extern "C" {
    /// Get password safe slot name
    /// @param slot_number password safe slot number, slot_number<16
    /// @return slot name
    pub fn NK_get_password_safe_slot_name(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get password safe slot login
    /// @param slot_number password safe slot number, slot_number<16
    /// @return login from the PWS slot
    pub fn NK_get_password_safe_slot_login(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get the password safe slot password
    /// @param slot_number password safe slot number, slot_number<16
    /// @return password from the PWS slot
    pub fn NK_get_password_safe_slot_password(slot_number: u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Write password safe data to the slot
    /// @param slot_number password safe slot number, slot_number<16
    /// @param slot_name char[11] name of the slot
    /// @param slot_login char[32] login string
    /// @param slot_password char[20] password string
    /// @return command processing error code
    pub fn NK_write_password_safe_slot(
        slot_number: u8,
        slot_name: *const ::std::os::raw::c_char,
        slot_login: *const ::std::os::raw::c_char,
        slot_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Erase the password safe slot from the device
    /// @param slot_number password safe slot number, slot_number<16
    /// @return command processing error code
    pub fn NK_erase_password_safe_slot(slot_number: u8) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Check whether AES is supported by the device
    /// @return 0 for no and 1 for yes
    pub fn NK_is_AES_supported(
        user_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get device's major firmware version
    /// @return major part of the version number (e.g. 0 from 0.48, 0 from 0.7 etc.)
    pub fn NK_get_major_firmware_version() -> u8;
}
extern "C" {
    /// Get device's minor firmware version
    /// @return minor part of the version number (e.g. 7 from 0.7, 48 from 0.48 etc.)
    pub fn NK_get_minor_firmware_version() -> u8;
}
extern "C" {
    /// Function to determine unencrypted volume PIN type
    /// @param minor_firmware_version
    /// @return Returns 1, if set unencrypted volume ro/rw pin type is User, 0 otherwise.
    pub fn NK_set_unencrypted_volume_rorw_pin_type_user() -> ::std::os::raw::c_int;
}
extern "C" {
    /// This command is typically run to initiate
    /// communication with the device (altough not required).
    /// It sets time on device and returns its current status
    /// - a combination of set_time and get_status_storage commands
    /// Storage only
    /// @param seconds_from_epoch date and time expressed in seconds
    pub fn NK_send_startup(seconds_from_epoch: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Unlock encrypted volume.
    /// Storage only
    /// @param user_pin user pin 20 characters
    /// @return command processing error code
    pub fn NK_unlock_encrypted_volume(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Locks encrypted volume
    /// @return command processing error code
    pub fn NK_lock_encrypted_volume() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Unlock hidden volume and lock encrypted volume.
    /// Requires encrypted volume to be unlocked.
    /// Storage only
    /// @param hidden_volume_password 20 characters
    /// @return command processing error code
    pub fn NK_unlock_hidden_volume(
        hidden_volume_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Locks hidden volume
    /// @return command processing error code
    pub fn NK_lock_hidden_volume() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Create hidden volume.
    /// Requires encrypted volume to be unlocked.
    /// Storage only
    /// @param slot_nr slot number in range 0-3
    /// @param start_percent volume begin expressed in percent of total available storage, int in range 0-99
    /// @param end_percent volume end expressed in percent of total available storage, int in range 1-100
    /// @param hidden_volume_password 20 characters
    /// @return command processing error code
    pub fn NK_create_hidden_volume(
        slot_nr: u8,
        start_percent: u8,
        end_percent: u8,
        hidden_volume_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make unencrypted volume read-only.
    /// Device hides unencrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Does nothing if firmware version is not matched
    /// Firmware range: Storage v0.50, v0.48 and below
    /// Storage only
    /// @param user_pin 20 characters User PIN
    /// @return command processing error code
    pub fn NK_set_unencrypted_read_only(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make unencrypted volume read-write.
    /// Device hides unencrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Does nothing if firmware version is not matched
    /// Firmware range: Storage v0.50, v0.48 and below
    /// Storage only
    /// @param user_pin 20 characters User PIN
    /// @return command processing error code
    pub fn NK_set_unencrypted_read_write(
        user_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make unencrypted volume read-only.
    /// Device hides unencrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Does nothing if firmware version is not matched
    /// Firmware range: Storage v0.49, v0.51+
    /// Storage only
    /// @param admin_pin 20 characters Admin PIN
    /// @return command processing error code
    pub fn NK_set_unencrypted_read_only_admin(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make unencrypted volume read-write.
    /// Device hides unencrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Does nothing if firmware version is not matched
    /// Firmware range: Storage v0.49, v0.51+
    /// Storage only
    /// @param admin_pin 20 characters Admin PIN
    /// @return command processing error code
    pub fn NK_set_unencrypted_read_write_admin(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make encrypted volume read-only.
    /// Device hides encrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Firmware range: v0.49 only, future (see firmware release notes)
    /// Storage only
    /// @param admin_pin 20 characters
    /// @return command processing error code
    pub fn NK_set_encrypted_read_only(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Make encrypted volume read-write.
    /// Device hides encrypted volume for a second therefore make sure
    /// buffers are flushed before running.
    /// Firmware range: v0.49 only, future (see firmware release notes)
    /// Storage only
    /// @param admin_pin 20 characters
    /// @return command processing error code
    pub fn NK_set_encrypted_read_write(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Exports device's firmware to unencrypted volume.
    /// Storage only
    /// @param admin_pin 20 characters
    /// @return command processing error code
    pub fn NK_export_firmware(admin_pin: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Clear new SD card notification. It is set after factory reset.
    /// Storage only
    /// @param admin_pin 20 characters
    /// @return command processing error code
    pub fn NK_clear_new_sd_card_warning(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Fill SD card with random data.
    /// Should be done on first stick initialization after creating keys.
    /// Storage only
    /// @param admin_pin 20 characters
    /// @return command processing error code
    pub fn NK_fill_SD_card_with_random_data(
        admin_pin: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Change update password.
    /// Update password is used for entering update mode, where firmware
    /// could be uploaded using dfu-programmer or other means.
    /// Storage only
    /// @param current_update_password 20 characters
    /// @param new_update_password 20 characters
    /// @return command processing error code
    pub fn NK_change_update_password(
        current_update_password: *const ::std::os::raw::c_char,
        new_update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Enter update mode. Needs update password.
    /// When device is in update mode it no longer accepts any HID commands until
    /// firmware is launched (regardless of being updated or not).
    /// Smartcard (through CCID interface) and its all volumes are not visible as well.
    /// Its VID and PID are changed to factory-default (03eb:2ff1 Atmel Corp.)
    /// to be detected by flashing software. Result of this command can be reversed
    /// by using 'launch' command.
    /// For dfu-programmer it would be: 'dfu-programmer at32uc3a3256s launch'.
    /// Storage only
    /// @param update_password 20 characters
    /// @return command processing error code
    pub fn NK_enable_firmware_update(
        update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get Storage stick status as string.
    /// Storage only
    /// @return string with devices attributes
    pub fn NK_get_status_storage_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get the Storage stick status and return the command processing
    /// error code.  If the code is zero, i. e. the command was successful,
    /// the storage status is written to the output pointer's target.
    /// The output pointer must not be null.
    ///
    /// @param out the output pointer for the storage status
    /// @return command processing error code
    pub fn NK_get_status_storage(out: *mut NK_storage_status) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get SD card usage attributes. Usable during hidden volumes creation.
    /// If the command was successful (return value 0), the usage data is
    /// written to the output pointer’s target.  The output pointer must
    /// not be null.
    /// Storage only
    /// @param out the output pointer for the usage data
    /// @return command processing error code
    pub fn NK_get_SD_usage_data(out: *mut NK_SD_usage_data) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Get SD card usage attributes as string.
    /// Usable during hidden volumes creation.
    /// Storage only
    /// @return string with SD card usage attributes
    pub fn NK_get_SD_usage_data_as_string() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Get progress value of current long operation.
    /// Storage only
    /// @return int in range 0-100 or -1 if device is not busy or -2 if an
    /// error occured
    pub fn NK_get_progress_bar_value() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Returns a list of connected devices' id's, delimited by ';' character. Empty string is returned on no device found.
    /// Each ID could consist of:
    /// 1. SC_id:SD_id_p_path (about 40 bytes)
    /// 2. path (about 10 bytes)
    /// where 'path' is USB path (bus:num), 'SC_id' is smartcard ID, 'SD_id' is storage card ID and
    /// '_p_' and ':' are field delimiters.
    /// Case 2 (USB path only) is used, when the device cannot be asked about its status data (e.g. during a long operation,
    /// like clearing SD card.
    /// Internally connects to all available devices and creates a map between ids and connection objects.
    /// Side effects: changes active device to last detected Storage device.
    /// Storage only
    /// @example Example of returned data: '00005d19:dacc2cb4_p_0001:0010:02;000037c7:4cf12445_p_0001:000f:02;0001:000c:02'
    /// @return string delimited id's of connected devices
    pub fn NK_list_devices_by_cpuID() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    /// Returns a linked list of all connected devices, or null if no devices
    /// are connected or an error occured.  The linked list must be freed by
    /// calling NK_free_device_info.
    /// @return a linked list of all connected devices
    pub fn NK_list_devices() -> *mut NK_device_info;
}
extern "C" {
    /// Free a linked list returned by NK_list_devices.
    /// @param the linked list to free or null
    pub fn NK_free_device_info(device_info: *mut NK_device_info);
}
extern "C" {
    /// Connects to the device with given ID. ID's list could be created with NK_list_devices_by_cpuID.
    /// Requires calling to NK_list_devices_by_cpuID first. Connecting to arbitrary ID/USB path is not handled.
    /// On connection requests status from device and disconnects it / removes from map on connection failure.
    /// Storage only
    /// @param id Target device ID (example: '00005d19:dacc2cb4_p_0001:0010:02')
    /// @return 1 on successful connection, 0 otherwise
    pub fn NK_connect_with_ID(id: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Connects to a device with the given path.  The path is a USB device
    /// path as returned by hidapi.
    /// @param path the device path
    /// @return 1 on successful connection, 0 otherwise
    pub fn NK_connect_with_path(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Blink red and green LED alternatively and infinitely (until device is reconnected).
    /// @return command processing error code
    pub fn NK_wink() -> ::std::os::raw::c_int;
}
extern "C" {
    /// Enable update mode on Nitrokey Pro.
    /// Supported from v0.11.
    /// @param update_password 20 bytes update password
    /// @return command processing error code
    pub fn NK_enable_firmware_update_pro(
        update_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    /// Change update-mode password on Nitrokey Pro.
    /// Supported from v0.11.
    /// @param current_firmware_password 20 bytes update password
    /// @param new_firmware_password 20 bytes update password
    /// @return command processing error code
    pub fn NK_change_firmware_password_pro(
        current_firmware_password: *const ::std::os::raw::c_char,
        new_firmware_password: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReadSlot_t {
    pub slot_name: [u8; 15usize],
    pub _slot_config: u8,
    pub slot_token_id: [u8; 13usize],
    pub slot_counter: u64,
}
#[test]
fn bindgen_test_layout_ReadSlot_t() {
    assert_eq!(
        ::std::mem::size_of::<ReadSlot_t>(),
        40usize,
        concat!("Size of: ", stringify!(ReadSlot_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ReadSlot_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ReadSlot_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ReadSlot_t>())).slot_name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ReadSlot_t),
            "::",
            stringify!(slot_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ReadSlot_t>()))._slot_config as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(ReadSlot_t),
            "::",
            stringify!(_slot_config)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ReadSlot_t>())).slot_token_id as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ReadSlot_t),
            "::",
            stringify!(slot_token_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ReadSlot_t>())).slot_counter as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ReadSlot_t),
            "::",
            stringify!(slot_counter)
        )
    );
}
extern "C" {
    pub fn NK_read_HOTP_slot(slot_num: u8, out: *mut ReadSlot_t) -> ::std::os::raw::c_int;
}
