# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AADProfileProperties(_model_base.Model):
    """The AAD Profile.

    :ivar server_id: The arc ingress gateway server app id. Required.
    :vartype server_id: str
    :ivar tenant_id: The target resource home tenant id. Required.
    :vartype tenant_id: str
    """

    server_id: str = rest_field(name="serverId", visibility=["read", "create", "update", "delete", "query"])
    """The arc ingress gateway server app id. Required."""
    tenant_id: str = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The target resource home tenant id. Required."""

    @overload
    def __init__(
        self,
        *,
        server_id: str,
        tenant_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AwsCloudProfile(_model_base.Model):
    """cloud profile for AWS.

    :ivar account_id: Account id for the AWS account. Required.
    :vartype account_id: str
    :ivar excluded_accounts: List of AWS accounts which need to be excluded.
    :vartype excluded_accounts: list[str]
    :ivar is_organizational_account: Boolean value that indicates whether the account is
     organizational or not. True represents organization account, whereas false represents a single
     account.
    :vartype is_organizational_account: bool
    """

    account_id: str = rest_field(name="accountId", visibility=["read", "create"])
    """Account id for the AWS account. Required."""
    excluded_accounts: Optional[List[str]] = rest_field(
        name="excludedAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of AWS accounts which need to be excluded."""
    is_organizational_account: Optional[bool] = rest_field(
        name="isOrganizationalAccount", visibility=["read", "create"]
    )
    """Boolean value that indicates whether the account is organizational or not. True represents
     organization account, whereas false represents a single account."""

    @overload
    def __init__(
        self,
        *,
        account_id: str,
        excluded_accounts: Optional[List[str]] = None,
        is_organizational_account: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AwsCloudProfileUpdate(_model_base.Model):
    """cloud profile for AWS.

    :ivar excluded_accounts: List of AWS accounts which need to be excluded.
    :vartype excluded_accounts: list[str]
    """

    excluded_accounts: Optional[List[str]] = rest_field(
        name="excludedAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of AWS accounts which need to be excluded."""

    @overload
    def __init__(
        self,
        *,
        excluded_accounts: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointAccessResource(_model_base.Model):
    """The endpoint access for the target resource.

    :ivar relay: Azure relay hybrid connection access properties.
    :vartype relay: ~azure.mgmt.hybridconnectivity.models.RelayNamespaceAccessProperties
    """

    relay: Optional["_models.RelayNamespaceAccessProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure relay hybrid connection access properties."""

    __flattened_items = [
        "namespace_name",
        "namespace_name_suffix",
        "hybrid_connection_name",
        "access_key",
        "expires_on",
        "service_configuration_token",
    ]

    @overload
    def __init__(
        self,
        *,
        relay: Optional["_models.RelayNamespaceAccessProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.relay is None:
                return None
            return getattr(self.relay, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.relay is None:
                self.relay = self._attr_to_rest_field["relay"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class EndpointProperties(_model_base.Model):
    """Endpoint details.

    :ivar type: The type of endpoint. Required. Known values are: "default" and "custom".
    :vartype type: str or ~azure.mgmt.hybridconnectivity.models.Type
    :ivar resource_id: The resource Id of the connectivity endpoint (optional).
    :vartype resource_id: str
    :ivar provisioning_state: The resource provisioning state.
    :vartype provisioning_state: str
    """

    type: Union[str, "_models.Type"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of endpoint. Required. Known values are: \"default\" and \"custom\"."""
    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the connectivity endpoint (optional)."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The resource provisioning state."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.Type"],
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ExtensionResource(Resource):
    """The base extension resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    """


class EndpointResource(ExtensionResource):
    """The endpoint for the target resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The endpoint properties.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.EndpointProperties
    """

    properties: Optional["_models.EndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The endpoint properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridconnectivity.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridconnectivity.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridconnectivity.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GenerateAwsTemplateRequest(_model_base.Model):
    """ConnectorId and SolutionTypes and their properties to Generate AWS CFT Template.

    :ivar connector_id: The name of public cloud connector. Required.
    :vartype connector_id: str
    :ivar solution_types: The list of solution types and their settings.
    :vartype solution_types: list[~azure.mgmt.hybridconnectivity.models.SolutionTypeSettings]
    """

    connector_id: str = rest_field(name="connectorId", visibility=["read", "create", "update", "delete", "query"])
    """The name of public cloud connector. Required."""
    solution_types: Optional[List["_models.SolutionTypeSettings"]] = rest_field(
        name="solutionTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of solution types and their settings."""

    @overload
    def __init__(
        self,
        *,
        connector_id: str,
        solution_types: Optional[List["_models.SolutionTypeSettings"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IngressGatewayResource(_model_base.Model):
    """The ingress gateway access credentials.

    :ivar relay: Azure relay hybrid connection access properties.
    :vartype relay: ~azure.mgmt.hybridconnectivity.models.RelayNamespaceAccessProperties
    :ivar ingress: Ingress gateway profile.
    :vartype ingress: ~azure.mgmt.hybridconnectivity.models.IngressProfileProperties
    """

    relay: Optional["_models.RelayNamespaceAccessProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure relay hybrid connection access properties."""
    ingress: Optional["_models.IngressProfileProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Ingress gateway profile."""

    __flattened_items = [
        "namespace_name",
        "namespace_name_suffix",
        "hybrid_connection_name",
        "access_key",
        "expires_on",
        "service_configuration_token",
    ]

    @overload
    def __init__(
        self,
        *,
        relay: Optional["_models.RelayNamespaceAccessProperties"] = None,
        ingress: Optional["_models.IngressProfileProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.relay is None:
                return None
            return getattr(self.relay, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.relay is None:
                self.relay = self._attr_to_rest_field["relay"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class IngressProfileProperties(_model_base.Model):
    """Ingress gateway profile.

    :ivar hostname: The ingress hostname. Required.
    :vartype hostname: str
    :ivar aad_profile: The AAD Profile. Required.
    :vartype aad_profile: ~azure.mgmt.hybridconnectivity.models.AADProfileProperties
    """

    hostname: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ingress hostname. Required."""
    aad_profile: "_models.AADProfileProperties" = rest_field(
        name="aadProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The AAD Profile. Required."""

    __flattened_items = ["server_id", "tenant_id"]

    @overload
    def __init__(
        self,
        *,
        hostname: str,
        aad_profile: "_models.AADProfileProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.aad_profile is None:
                return None
            return getattr(self.aad_profile, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.aad_profile is None:
                self.aad_profile = self._attr_to_rest_field["aad_profile"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class InventoryProperties(_model_base.Model):
    """Definition of inventory.

    :ivar cloud_native_type: Gets or sets the cloud native resource type. "ec2"
    :vartype cloud_native_type: str or ~azure.mgmt.hybridconnectivity.models.CloudNativeType
    :ivar cloud_native_resource_id: Gets or sets the cloud native resource name.
    :vartype cloud_native_resource_id: str
    :ivar azure_resource_id: Gets or sets the mapped azure resource id.
    :vartype azure_resource_id: str
    :ivar status: Gets or sets the status of the inventory. Known values are: "New", "InProgress",
     "Completed", and "Failed".
    :vartype status: str or ~azure.mgmt.hybridconnectivity.models.SolutionConfigurationStatus
    :ivar status_details: Gets or sets the status details.
    :vartype status_details: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridconnectivity.models.ResourceProvisioningState
    """

    cloud_native_type: Optional[Union[str, "_models.CloudNativeType"]] = rest_field(
        name="cloudNativeType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the cloud native resource type. \"ec2\""""
    cloud_native_resource_id: Optional[str] = rest_field(
        name="cloudNativeResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the cloud native resource name."""
    azure_resource_id: Optional[str] = rest_field(
        name="azureResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the mapped azure resource id."""
    status: Optional[Union[str, "_models.SolutionConfigurationStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the status of the inventory. Known values are: \"New\", \"InProgress\",
     \"Completed\", and \"Failed\"."""
    status_details: Optional[str] = rest_field(
        name="statusDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets or sets the status details."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        cloud_native_type: Optional[Union[str, "_models.CloudNativeType"]] = None,
        cloud_native_resource_id: Optional[str] = None,
        azure_resource_id: Optional[str] = None,
        status: Optional[Union[str, "_models.SolutionConfigurationStatus"]] = None,
        status_details: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    """


class InventoryResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.InventoryProperties
    """

    properties: Optional["_models.InventoryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.InventoryProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListCredentialsRequest(_model_base.Model):
    """The details of the service for which credentials needs to be returned.

    :ivar service_name: The name of the service. If not provided, the request will by pass the
     generation of service configuration token. Known values are: "SSH" and "WAC".
    :vartype service_name: str or ~azure.mgmt.hybridconnectivity.models.ServiceName
    """

    service_name: Optional[Union[str, "_models.ServiceName"]] = rest_field(
        name="serviceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the service. If not provided, the request will by pass the generation of service
     configuration token. Known values are: \"SSH\" and \"WAC\"."""

    @overload
    def __init__(
        self,
        *,
        service_name: Optional[Union[str, "_models.ServiceName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListIngressGatewayCredentialsRequest(_model_base.Model):
    """Represent ListIngressGatewayCredentials Request object.

    :ivar service_name: The name of the service. If not provided, the request will by pass the
     generation of service configuration token. Known values are: "SSH" and "WAC".
    :vartype service_name: str or ~azure.mgmt.hybridconnectivity.models.ServiceName
    """

    service_name: Optional[Union[str, "_models.ServiceName"]] = rest_field(
        name="serviceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the service. If not provided, the request will by pass the generation of service
     configuration token. Known values are: \"SSH\" and \"WAC\"."""

    @overload
    def __init__(
        self,
        *,
        service_name: Optional[Union[str, "_models.ServiceName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedProxyRequest(_model_base.Model):
    """Represent ManageProxy Request object.

    :ivar service: The name of the service. Required.
    :vartype service: str
    :ivar hostname: The target host name.
    :vartype hostname: str
    :ivar service_name: The name of the service. It is an optional property, if not provided,
     service configuration tokens issue code would be by passed. Known values are: "SSH" and "WAC".
    :vartype service_name: str or ~azure.mgmt.hybridconnectivity.models.ServiceName
    """

    service: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the service. Required."""
    hostname: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target host name."""
    service_name: Optional[Union[str, "_models.ServiceName"]] = rest_field(
        name="serviceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the service. It is an optional property, if not provided, service configuration
     tokens issue code would be by passed. Known values are: \"SSH\" and \"WAC\"."""

    @overload
    def __init__(
        self,
        *,
        service: str,
        hostname: Optional[str] = None,
        service_name: Optional[Union[str, "_models.ServiceName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedProxyResource(_model_base.Model):
    """Managed Proxy.

    :ivar proxy: The short lived proxy name. Required.
    :vartype proxy: str
    :ivar expires_on: The expiration time of short lived proxy name in unix epoch. Required.
    :vartype expires_on: int
    """

    proxy: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The short lived proxy name. Required."""
    expires_on: int = rest_field(name="expiresOn", visibility=["read", "create", "update", "delete", "query"])
    """The expiration time of short lived proxy name in unix epoch. Required."""

    @overload
    def __init__(
        self,
        *,
        proxy: str,
        expires_on: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.hybridconnectivity.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.hybridconnectivity.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.hybridconnectivity.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperationStatusResult(_model_base.Model):
    """The current status of an async operation.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.hybridconnectivity.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.hybridconnectivity.models.ErrorDetail
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fully qualified ID for the async operation."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the async operation."""
    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation status. Required."""
    percent_complete: Optional[float] = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """Percent of the operation that is complete."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the operation."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the operation."""
    operations: Optional[List["_models.OperationStatusResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The operations list."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If present, details of the operation error."""
    resource_id: Optional[str] = rest_field(name="resourceId", visibility=["read"])
    """Fully qualified ID of the resource against which the original async operation was started."""

    @overload
    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicCloudConnector(TrackedResource):
    """Public Cloud Connector.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.PublicCloudConnectorProperties
    """

    properties: Optional["_models.PublicCloudConnectorProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PublicCloudConnectorProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicCloudConnectorProperties(_model_base.Model):
    """Properties of public cloud connectors.

    :ivar aws_cloud_profile: Cloud profile for AWS. Required.
    :vartype aws_cloud_profile: ~azure.mgmt.hybridconnectivity.models.AwsCloudProfile
    :ivar host_type: Host cloud the public cloud connector. Required. "AWS"
    :vartype host_type: str or ~azure.mgmt.hybridconnectivity.models.HostType
    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridconnectivity.models.ResourceProvisioningState
    :ivar connector_primary_identifier: Connector primary identifier.
    :vartype connector_primary_identifier: str
    """

    aws_cloud_profile: "_models.AwsCloudProfile" = rest_field(
        name="awsCloudProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cloud profile for AWS. Required."""
    host_type: Union[str, "_models.HostType"] = rest_field(name="hostType", visibility=["read", "create"])
    """Host cloud the public cloud connector. Required. \"AWS\""""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    connector_primary_identifier: Optional[str] = rest_field(name="connectorPrimaryIdentifier", visibility=["read"])
    """Connector primary identifier."""

    @overload
    def __init__(
        self,
        *,
        aws_cloud_profile: "_models.AwsCloudProfile",
        host_type: Union[str, "_models.HostType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicCloudConnectorPropertiesUpdate(_model_base.Model):
    """Properties of public cloud connectors.

    :ivar aws_cloud_profile: Cloud profile for AWS.
    :vartype aws_cloud_profile: ~azure.mgmt.hybridconnectivity.models.AwsCloudProfileUpdate
    """

    aws_cloud_profile: Optional["_models.AwsCloudProfileUpdate"] = rest_field(
        name="awsCloudProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cloud profile for AWS."""

    @overload
    def __init__(
        self,
        *,
        aws_cloud_profile: Optional["_models.AwsCloudProfileUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResourceUpdate(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PublicCloudConnectorUpdate(TrackedResourceUpdate):
    """Public Cloud Connector.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.PublicCloudConnectorPropertiesUpdate
    """

    properties: Optional["_models.PublicCloudConnectorPropertiesUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PublicCloudConnectorPropertiesUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RelayNamespaceAccessProperties(_model_base.Model):
    """Azure relay hybrid connection access properties.

    :ivar namespace_name: The namespace name. Required.
    :vartype namespace_name: str
    :ivar namespace_name_suffix: The suffix domain name of relay namespace. Required.
    :vartype namespace_name_suffix: str
    :ivar hybrid_connection_name: Azure Relay hybrid connection name for the resource. Required.
    :vartype hybrid_connection_name: str
    :ivar access_key: Access key for hybrid connection.
    :vartype access_key: str
    :ivar expires_on: The expiration of access key in unix time.
    :vartype expires_on: int
    :ivar service_configuration_token: The token to access the enabled service.
    :vartype service_configuration_token: str
    """

    namespace_name: str = rest_field(name="namespaceName", visibility=["read", "create", "update", "delete", "query"])
    """The namespace name. Required."""
    namespace_name_suffix: str = rest_field(
        name="namespaceNameSuffix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The suffix domain name of relay namespace. Required."""
    hybrid_connection_name: str = rest_field(
        name="hybridConnectionName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Relay hybrid connection name for the resource. Required."""
    access_key: Optional[str] = rest_field(name="accessKey", visibility=["read"])
    """Access key for hybrid connection."""
    expires_on: Optional[int] = rest_field(name="expiresOn", visibility=["read", "create", "update", "delete", "query"])
    """The expiration of access key in unix time."""
    service_configuration_token: Optional[str] = rest_field(
        name="serviceConfigurationToken", visibility=["read", "create", "update", "delete", "query"]
    )
    """The token to access the enabled service."""

    @overload
    def __init__(
        self,
        *,
        namespace_name: str,
        namespace_name_suffix: str,
        hybrid_connection_name: str,
        expires_on: Optional[int] = None,
        service_configuration_token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceConfigurationProperties(_model_base.Model):
    """Service configuration details.

    :ivar service_name: Name of the service. Required. Known values are: "SSH" and "WAC".
    :vartype service_name: str or ~azure.mgmt.hybridconnectivity.models.ServiceName
    :ivar resource_id: The resource Id of the connectivity endpoint (optional).
    :vartype resource_id: str
    :ivar port: The port on which service is enabled.
    :vartype port: int
    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Creating", "Updating", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.hybridconnectivity.models.ProvisioningState
    """

    service_name: Union[str, "_models.ServiceName"] = rest_field(
        name="serviceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the service. Required. Known values are: \"SSH\" and \"WAC\"."""
    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the connectivity endpoint (optional)."""
    port: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The port on which service is enabled."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Creating\", \"Updating\",
     \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        service_name: Union[str, "_models.ServiceName"],
        resource_id: Optional[str] = None,
        port: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceConfigurationPropertiesPatch(_model_base.Model):
    """Service configuration details.

    :ivar port: The port on which service is enabled.
    :vartype port: int
    """

    port: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The port on which service is enabled."""

    @overload
    def __init__(
        self,
        *,
        port: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceConfigurationResource(ExtensionResource):
    """The service configuration details associated with the target resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The service configuration properties.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.ServiceConfigurationProperties
    """

    properties: Optional["_models.ServiceConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The service configuration properties."""

    __flattened_items = ["service_name", "resource_id", "port", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ServiceConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ServiceConfigurationResourcePatch(_model_base.Model):
    """The service details under service configuration for the target endpoint resource.

    :ivar properties: The service configuration properties.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.ServiceConfigurationPropertiesPatch
    """

    properties: Optional["_models.ServiceConfigurationPropertiesPatch"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The service configuration properties."""

    __flattened_items = ["port"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ServiceConfigurationPropertiesPatch"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SolutionConfiguration(ExtensionResource):
    """Solution Configuration.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.SolutionConfigurationProperties
    """

    properties: Optional["_models.SolutionConfigurationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionConfigurationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionConfigurationProperties(_model_base.Model):
    """Solution configuration resource.

    :ivar provisioning_state: The resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridconnectivity.models.ResourceProvisioningState
    :ivar solution_type: The type of the solution. Required.
    :vartype solution_type: str
    :ivar solution_settings: Solution settings.
    :vartype solution_settings: ~azure.mgmt.hybridconnectivity.models.SolutionSettings
    :ivar status: The status of solution configurations. Known values are: "New", "InProgress",
     "Completed", and "Failed".
    :vartype status: str or ~azure.mgmt.hybridconnectivity.models.SolutionConfigurationStatus
    :ivar status_details: The detailed message of status details.
    :vartype status_details: str
    :ivar last_sync_time: The last time resources were inventoried.
    :vartype last_sync_time: ~datetime.datetime
    """

    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and \"Canceled\"."""
    solution_type: str = rest_field(name="solutionType", visibility=["read", "create", "update", "delete", "query"])
    """The type of the solution. Required."""
    solution_settings: Optional["_models.SolutionSettings"] = rest_field(
        name="solutionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution settings."""
    status: Optional[Union[str, "_models.SolutionConfigurationStatus"]] = rest_field(visibility=["read"])
    """The status of solution configurations. Known values are: \"New\", \"InProgress\",
     \"Completed\", and \"Failed\"."""
    status_details: Optional[str] = rest_field(name="statusDetails", visibility=["read"])
    """The detailed message of status details."""
    last_sync_time: Optional[datetime.datetime] = rest_field(name="lastSyncTime", visibility=["read"], format="rfc3339")
    """The last time resources were inventoried."""

    @overload
    def __init__(
        self,
        *,
        solution_type: str,
        solution_settings: Optional["_models.SolutionSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionConfigurationPropertiesUpdate(_model_base.Model):
    """Solution configuration resource.

    :ivar solution_type: The type of the solution.
    :vartype solution_type: str
    :ivar solution_settings: Solution settings.
    :vartype solution_settings: ~azure.mgmt.hybridconnectivity.models.SolutionSettings
    """

    solution_type: Optional[str] = rest_field(
        name="solutionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the solution."""
    solution_settings: Optional["_models.SolutionSettings"] = rest_field(
        name="solutionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution settings."""

    @overload
    def __init__(
        self,
        *,
        solution_type: Optional[str] = None,
        solution_settings: Optional["_models.SolutionSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionConfigurationUpdate(ProxyResource):
    """Solution Configuration.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.hybridconnectivity.models.SolutionConfigurationPropertiesUpdate
    """

    properties: Optional["_models.SolutionConfigurationPropertiesUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionConfigurationPropertiesUpdate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionSettings(_model_base.Model):
    """Solution settings."""


class SolutionTypeProperties(_model_base.Model):
    """Definition of Solution type resource.

    :ivar solution_type: The name of the solution type.
    :vartype solution_type: str
    :ivar description: Short description of solution type.
    :vartype description: str
    :ivar supported_azure_regions: The locations this solution is supported in.
    :vartype supported_azure_regions: list[str]
    :ivar solution_settings: Array of solution settings and its description.
    :vartype solution_settings:
     list[~azure.mgmt.hybridconnectivity.models.SolutionTypeSettingsProperties]
    """

    solution_type: Optional[str] = rest_field(
        name="solutionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the solution type."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Short description of solution type."""
    supported_azure_regions: Optional[List[str]] = rest_field(
        name="supportedAzureRegions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The locations this solution is supported in."""
    solution_settings: Optional[List["_models.SolutionTypeSettingsProperties"]] = rest_field(
        name="solutionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of solution settings and its description."""

    @overload
    def __init__(
        self,
        *,
        solution_type: Optional[str] = None,
        description: Optional[str] = None,
        supported_azure_regions: Optional[List[str]] = None,
        solution_settings: Optional[List["_models.SolutionTypeSettingsProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTypeResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridconnectivity.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.hybridconnectivity.models.SolutionTypeProperties
    """

    properties: Optional["_models.SolutionTypeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SolutionTypeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTypeSettings(_model_base.Model):
    """The properties of Solution Type.

    :ivar solution_type: The type of the solution. Required.
    :vartype solution_type: str
    :ivar solution_settings: Solution settings.
    :vartype solution_settings: ~azure.mgmt.hybridconnectivity.models.SolutionSettings
    """

    solution_type: str = rest_field(name="solutionType", visibility=["read", "create", "update", "delete", "query"])
    """The type of the solution. Required."""
    solution_settings: Optional["_models.SolutionSettings"] = rest_field(
        name="solutionSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Solution settings."""

    @overload
    def __init__(
        self,
        *,
        solution_type: str,
        solution_settings: Optional["_models.SolutionSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SolutionTypeSettingsProperties(_model_base.Model):
    """Represent Solution settings properties description array.

    :ivar name: The name of the solution setting property. Required.
    :vartype name: str
    :ivar display_name: The UI friendly name of the solution setting property. Required.
    :vartype display_name: str
    :ivar type: Type of the solution setting property, represented as a string. Required.
    :vartype type: str
    :ivar description: Description of solution setting property. Required.
    :vartype description: str
    :ivar allowed_values: Array of allowed values for this solution settings property. Required.
    :vartype allowed_values: list[str]
    :ivar default_value: Default value for this solution settings property. Required.
    :vartype default_value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the solution setting property. Required."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """The UI friendly name of the solution setting property. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of the solution setting property, represented as a string. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of solution setting property. Required."""
    allowed_values: List[str] = rest_field(
        name="allowedValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of allowed values for this solution settings property. Required."""
    default_value: str = rest_field(name="defaultValue", visibility=["read", "create", "update", "delete", "query"])
    """Default value for this solution settings property. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        display_name: str,
        type: str,
        description: str,
        allowed_values: List[str],
        default_value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hybridconnectivity.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hybridconnectivity.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
