/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Stdlib includes
#include <limits>
#include <vector>
#include <memory>

/////////////////////// Qt includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/IsotopicData.hpp"
#include "MsXpS/libXpertMassCore/IsotopicDataBaseHandler.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC IsotopicDataLibraryHandler : public IsotopicDataBaseHandler
{

  public:
  IsotopicDataLibraryHandler();
  IsotopicDataLibraryHandler(IsotopicDataSPtr isotopic_data_sp);

  virtual ~IsotopicDataLibraryHandler();

  virtual qsizetype loadData(const QString &filename = QString()) override;
  virtual qsizetype loadData(qsizetype &count_non_isotope_skipped_items);

  virtual qsizetype writeData(const QString &file_name = QString()) override;

  protected:
  virtual qsizetype checkConsistency() override;
};

typedef std::shared_ptr<IsotopicDataLibraryHandler>
  IsotopicDataLibraryHandlerSPtr;
typedef std::shared_ptr<const IsotopicDataLibraryHandler>
  IsotopicDataLibraryHandlerCstSPtr;

} // namespace libXpertMassCore

} // namespace MsXpS
