
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStackedLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStackedLayout>
#include <QChildEvent>
#include <QEvent>
#include <QLayout>
#include <QLayoutItem>
#include <QMargins>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QSpacerItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStackedLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStackedLayout::staticMetaObject);
}


// void QStackedLayout::addItem(QLayoutItem *item)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = gsi::arg_reader<QLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout *)cls)->addItem (arg1);
}


// int QStackedLayout::addWidget(QWidget *w)


static void _init_f_addWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  ret.write<int > ((int)((QStackedLayout *)cls)->addWidget (arg1));
}


// int QStackedLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStackedLayout *)cls)->count ());
}


// int QStackedLayout::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStackedLayout *)cls)->currentIndex ());
}


// QWidget *QStackedLayout::currentWidget()


static void _init_f_currentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_currentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->currentWidget ());
}


// bool QStackedLayout::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStackedLayout *)cls)->hasHeightForWidth ());
}


// int QStackedLayout::heightForWidth(int width)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QStackedLayout *)cls)->heightForWidth (arg1));
}


// int QStackedLayout::insertWidget(int index, QWidget *w)


static void _init_f_insertWidget_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_insertWidget_1974 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  ret.write<int > ((int)((QStackedLayout *)cls)->insertWidget (arg1, arg2));
}


// QLayoutItem *QStackedLayout::itemAt(int)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout *)cls)->itemAt (arg1));
}


// QSize QStackedLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStackedLayout *)cls)->minimumSize ());
}


// void QStackedLayout::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout *)cls)->setCurrentIndex (arg1);
}


// void QStackedLayout::setCurrentWidget(QWidget *w)


static void _init_f_setCurrentWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout *)cls)->setCurrentWidget (arg1);
}


// void QStackedLayout::setGeometry(const QRect &rect)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout *)cls)->setGeometry (arg1);
}


// void QStackedLayout::setStackingMode(QStackedLayout::StackingMode stackingMode)


static void _init_f_setStackingMode_3183 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stackingMode");
  decl->add_arg<const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStackingMode_3183 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStackedLayout::StackingMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout *)cls)->setStackingMode (qt_gsi::QtToCppAdaptor<QStackedLayout::StackingMode>(arg1).cref());
}


// QSize QStackedLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStackedLayout *)cls)->sizeHint ());
}


// QStackedLayout::StackingMode QStackedLayout::stackingMode()


static void _init_f_stackingMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStackedLayout::StackingMode>::target_type > ();
}

static void _call_f_stackingMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QStackedLayout::StackingMode>::target_type > ((qt_gsi::Converter<QStackedLayout::StackingMode>::target_type)qt_gsi::CppToQtAdaptor<QStackedLayout::StackingMode>(((QStackedLayout *)cls)->stackingMode ()));
}


// QLayoutItem *QStackedLayout::takeAt(int)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout *)cls)->takeAt (arg1));
}


// QWidget *QStackedLayout::widget()


static void _init_f_widget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->widget ());
}


// QWidget *QStackedLayout::widget(int)


static void _init_f_widget_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QStackedLayout *)cls)->widget (arg1));
}


// static QString QStackedLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStackedLayout::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QStackedLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QStackedLayout::addItem(QLayoutItem *item)\nThis is a reimplementation of QLayout::addItem", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
  methods += new qt_gsi::GenericMethod ("addWidget", "@brief Method int QStackedLayout::addWidget(QWidget *w)\n", false, &_init_f_addWidget_1315, &_call_f_addWidget_1315);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method int QStackedLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QStackedLayout::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod (":currentWidget", "@brief Method QWidget *QStackedLayout::currentWidget()\n", true, &_init_f_currentWidget_c0, &_call_f_currentWidget_c0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QStackedLayout::hasHeightForWidth()\nThis is a reimplementation of QLayoutItem::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QStackedLayout::heightForWidth(int width)\nThis is a reimplementation of QLayoutItem::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
  methods += new qt_gsi::GenericMethod ("insertWidget", "@brief Method int QStackedLayout::insertWidget(int index, QWidget *w)\n", false, &_init_f_insertWidget_1974, &_call_f_insertWidget_1974);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QStackedLayout::itemAt(int)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QStackedLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QStackedLayout::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
  methods += new qt_gsi::GenericMethod ("setCurrentWidget|currentWidget=", "@brief Method void QStackedLayout::setCurrentWidget(QWidget *w)\n", false, &_init_f_setCurrentWidget_1315, &_call_f_setCurrentWidget_1315);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QStackedLayout::setGeometry(const QRect &rect)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
  methods += new qt_gsi::GenericMethod ("setStackingMode|stackingMode=", "@brief Method void QStackedLayout::setStackingMode(QStackedLayout::StackingMode stackingMode)\n", false, &_init_f_setStackingMode_3183, &_call_f_setStackingMode_3183);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QStackedLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":stackingMode", "@brief Method QStackedLayout::StackingMode QStackedLayout::stackingMode()\n", true, &_init_f_stackingMode_c0, &_call_f_stackingMode_c0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QStackedLayout::takeAt(int)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Method QWidget *QStackedLayout::widget()\nThis is a reimplementation of QLayoutItem::widget", true, &_init_f_widget_c0, &_call_f_widget_c0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Method QWidget *QStackedLayout::widget(int)\n", true, &_init_f_widget_c767, &_call_f_widget_c767);
  methods += gsi::qt_signal<int > ("currentChanged(int)", "currentChanged", gsi::arg("index"), "@brief Signal declaration for QStackedLayout::currentChanged(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QStackedLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QStackedLayout::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("widgetRemoved(int)", "widgetRemoved", gsi::arg("index"), "@brief Signal declaration for QStackedLayout::widgetRemoved(int index)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStackedLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QLayout> &qtdecl_QLayout ();

qt_gsi::QtNativeClass<QStackedLayout> decl_QStackedLayout (qtdecl_QLayout (), "QtWidgets", "QStackedLayout_Native",
  methods_QStackedLayout (),
  "@hide\n@alias QStackedLayout");

GSI_QTWIDGETS_PUBLIC gsi::Class<QStackedLayout> &qtdecl_QStackedLayout () { return decl_QStackedLayout; }

}


class QStackedLayout_Adaptor : public QStackedLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStackedLayout_Adaptor();

  //  [adaptor ctor] QStackedLayout::QStackedLayout()
  QStackedLayout_Adaptor() : QStackedLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStackedLayout::QStackedLayout(QWidget *parent)
  QStackedLayout_Adaptor(QWidget *parent) : QStackedLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStackedLayout::QStackedLayout(QLayout *parentLayout)
  QStackedLayout_Adaptor(QLayout *parentLayout) : QStackedLayout(parentLayout)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QStackedLayout::addChildLayout(QLayout *l)
  void fp_QStackedLayout_addChildLayout_1341 (QLayout *l) {
    QStackedLayout::addChildLayout(l);
  }

  //  [expose] void QStackedLayout::addChildWidget(QWidget *w)
  void fp_QStackedLayout_addChildWidget_1315 (QWidget *w) {
    QStackedLayout::addChildWidget(w);
  }

  //  [expose] bool QStackedLayout::adoptLayout(QLayout *layout)
  bool fp_QStackedLayout_adoptLayout_1341 (QLayout *layout) {
    return QStackedLayout::adoptLayout(layout);
  }

  //  [expose] QRect QStackedLayout::alignmentRect(const QRect &)
  QRect fp_QStackedLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QStackedLayout::alignmentRect(arg1);
  }

  //  [expose] bool QStackedLayout::isSignalConnected(const QMetaMethod &signal)
  bool fp_QStackedLayout_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QStackedLayout::isSignalConnected(signal);
  }

  //  [expose] int QStackedLayout::receivers(const char *signal)
  int fp_QStackedLayout_receivers_c1731 (const char *signal) const {
    return QStackedLayout::receivers(signal);
  }

  //  [expose] QObject *QStackedLayout::sender()
  QObject * fp_QStackedLayout_sender_c0 () const {
    return QStackedLayout::sender();
  }

  //  [expose] int QStackedLayout::senderSignalIndex()
  int fp_QStackedLayout_senderSignalIndex_c0 () const {
    return QStackedLayout::senderSignalIndex();
  }

  //  [expose] void QStackedLayout::widgetEvent(QEvent *)
  void fp_QStackedLayout_widgetEvent_1217 (QEvent *arg1) {
    QStackedLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QStackedLayout::addItem(QLayoutItem *item)
  void cbs_addItem_1740_0(QLayoutItem *item)
  {
    QStackedLayout::addItem(item);
  }

  virtual void addItem(QLayoutItem *item)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QStackedLayout_Adaptor, QLayoutItem *>(&QStackedLayout_Adaptor::cbs_addItem_1740_0, item);
    } else {
      QStackedLayout::addItem(item);
    }
  }

  //  [adaptor impl] QFlags<QSizePolicy::ControlType> QStackedLayout::controlTypes()
  QFlags<QSizePolicy::ControlType> cbs_controlTypes_c0_0() const
  {
    return QStackedLayout::controlTypes();
  }

  virtual QFlags<QSizePolicy::ControlType> controlTypes() const
  {
    if (cb_controlTypes_c0_0.can_issue()) {
      return cb_controlTypes_c0_0.issue<QStackedLayout_Adaptor, QFlags<QSizePolicy::ControlType> >(&QStackedLayout_Adaptor::cbs_controlTypes_c0_0);
    } else {
      return QStackedLayout::controlTypes();
    }
  }

  //  [adaptor impl] int QStackedLayout::count()
  int cbs_count_c0_0() const
  {
    return QStackedLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QStackedLayout_Adaptor, int>(&QStackedLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QStackedLayout::count();
    }
  }

  //  [emitter impl] void QStackedLayout::currentChanged(int index)
  void emitter_QStackedLayout_currentChanged_767(int index)
  {
    emit QStackedLayout::currentChanged(index);
  }

  //  [emitter impl] void QStackedLayout::destroyed(QObject *)
  void emitter_QStackedLayout_destroyed_1302(QObject *arg1)
  {
    emit QStackedLayout::destroyed(arg1);
  }

  //  [adaptor impl] bool QStackedLayout::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QStackedLayout::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStackedLayout_Adaptor, bool, QEvent *>(&QStackedLayout_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QStackedLayout::event(_event);
    }
  }

  //  [adaptor impl] bool QStackedLayout::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QStackedLayout::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStackedLayout_Adaptor, bool, QObject *, QEvent *>(&QStackedLayout_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QStackedLayout::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QStackedLayout::expandingDirections()
  QFlags<Qt::Orientation> cbs_expandingDirections_c0_0() const
  {
    return QStackedLayout::expandingDirections();
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return cb_expandingDirections_c0_0.issue<QStackedLayout_Adaptor, QFlags<Qt::Orientation> >(&QStackedLayout_Adaptor::cbs_expandingDirections_c0_0);
    } else {
      return QStackedLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QStackedLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QStackedLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QStackedLayout_Adaptor, QRect>(&QStackedLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QStackedLayout::geometry();
    }
  }

  //  [adaptor impl] bool QStackedLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QStackedLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QStackedLayout_Adaptor, bool>(&QStackedLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QStackedLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QStackedLayout::heightForWidth(int width)
  int cbs_heightForWidth_c767_0(int width) const
  {
    return QStackedLayout::heightForWidth(width);
  }

  virtual int heightForWidth(int width) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QStackedLayout_Adaptor, int, int>(&QStackedLayout_Adaptor::cbs_heightForWidth_c767_0, width);
    } else {
      return QStackedLayout::heightForWidth(width);
    }
  }

  //  [adaptor impl] int QStackedLayout::indexOf(const QWidget *)
  int cbs_indexOf_c2010_0(const QWidget *arg1) const
  {
    return QStackedLayout::indexOf(arg1);
  }

  virtual int indexOf(const QWidget *arg1) const
  {
    if (cb_indexOf_c2010_0.can_issue()) {
      return cb_indexOf_c2010_0.issue<QStackedLayout_Adaptor, int, const QWidget *>(&QStackedLayout_Adaptor::cbs_indexOf_c2010_0, arg1);
    } else {
      return QStackedLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] int QStackedLayout::indexOf(const QLayoutItem *)
  int cbs_indexOf_c2435_0(const QLayoutItem *arg1) const
  {
    return QStackedLayout::indexOf(arg1);
  }

  virtual int indexOf(const QLayoutItem *arg1) const
  {
    if (cb_indexOf_c2435_0.can_issue()) {
      return cb_indexOf_c2435_0.issue<QStackedLayout_Adaptor, int, const QLayoutItem *>(&QStackedLayout_Adaptor::cbs_indexOf_c2435_0, arg1);
    } else {
      return QStackedLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QStackedLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QStackedLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QStackedLayout_Adaptor>(&QStackedLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QStackedLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QStackedLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QStackedLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QStackedLayout_Adaptor, bool>(&QStackedLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QStackedLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QStackedLayout::itemAt(int)
  QLayoutItem * cbs_itemAt_c767_0(int arg1) const
  {
    return QStackedLayout::itemAt(arg1);
  }

  virtual QLayoutItem * itemAt(int arg1) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QStackedLayout_Adaptor, QLayoutItem *, int>(&QStackedLayout_Adaptor::cbs_itemAt_c767_0, arg1);
    } else {
      return QStackedLayout::itemAt(arg1);
    }
  }

  //  [adaptor impl] QLayout *QStackedLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QStackedLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QStackedLayout_Adaptor, QLayout *>(&QStackedLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QStackedLayout::layout();
    }
  }

  //  [adaptor impl] QSize QStackedLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QStackedLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QStackedLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QStackedLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QStackedLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QStackedLayout_Adaptor, int, int>(&QStackedLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QStackedLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QStackedLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QStackedLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QStackedLayout::minimumSize();
    }
  }

  //  [emitter impl] void QStackedLayout::objectNameChanged(const QString &objectName)
  void emitter_QStackedLayout_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QStackedLayout::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QLayoutItem *QStackedLayout::replaceWidget(QWidget *from, QWidget *to, QFlags<Qt::FindChildOption> options)
  QLayoutItem * cbs_replaceWidget_5361_1(QWidget *from, QWidget *to, QFlags<Qt::FindChildOption> options)
  {
    return QStackedLayout::replaceWidget(from, to, options);
  }

  virtual QLayoutItem * replaceWidget(QWidget *from, QWidget *to, QFlags<Qt::FindChildOption> options)
  {
    if (cb_replaceWidget_5361_1.can_issue()) {
      return cb_replaceWidget_5361_1.issue<QStackedLayout_Adaptor, QLayoutItem *, QWidget *, QWidget *, QFlags<Qt::FindChildOption> >(&QStackedLayout_Adaptor::cbs_replaceWidget_5361_1, from, to, options);
    } else {
      return QStackedLayout::replaceWidget(from, to, options);
    }
  }

  //  [adaptor impl] void QStackedLayout::setGeometry(const QRect &rect)
  void cbs_setGeometry_1792_0(const QRect &rect)
  {
    QStackedLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRect &rect)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QStackedLayout_Adaptor, const QRect &>(&QStackedLayout_Adaptor::cbs_setGeometry_1792_0, rect);
    } else {
      QStackedLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] void QStackedLayout::setSpacing(int)
  void cbs_setSpacing_767_0(int arg1)
  {
    QStackedLayout::setSpacing(arg1);
  }

  virtual void setSpacing(int arg1)
  {
    if (cb_setSpacing_767_0.can_issue()) {
      cb_setSpacing_767_0.issue<QStackedLayout_Adaptor, int>(&QStackedLayout_Adaptor::cbs_setSpacing_767_0, arg1);
    } else {
      QStackedLayout::setSpacing(arg1);
    }
  }

  //  [adaptor impl] QSize QStackedLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QStackedLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QStackedLayout_Adaptor, QSize>(&QStackedLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QStackedLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QStackedLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QStackedLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QStackedLayout_Adaptor, QSpacerItem *>(&QStackedLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QStackedLayout::spacerItem();
    }
  }

  //  [adaptor impl] int QStackedLayout::spacing()
  int cbs_spacing_c0_0() const
  {
    return QStackedLayout::spacing();
  }

  virtual int spacing() const
  {
    if (cb_spacing_c0_0.can_issue()) {
      return cb_spacing_c0_0.issue<QStackedLayout_Adaptor, int>(&QStackedLayout_Adaptor::cbs_spacing_c0_0);
    } else {
      return QStackedLayout::spacing();
    }
  }

  //  [adaptor impl] QLayoutItem *QStackedLayout::takeAt(int)
  QLayoutItem * cbs_takeAt_767_0(int arg1)
  {
    return QStackedLayout::takeAt(arg1);
  }

  virtual QLayoutItem * takeAt(int arg1)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QStackedLayout_Adaptor, QLayoutItem *, int>(&QStackedLayout_Adaptor::cbs_takeAt_767_0, arg1);
    } else {
      return QStackedLayout::takeAt(arg1);
    }
  }

  //  [adaptor impl] QWidget *QStackedLayout::widget()
  QWidget * cbs_widget_c0_0() const
  {
    return QStackedLayout::widget();
  }

  virtual QWidget * widget() const
  {
    if (cb_widget_c0_0.can_issue()) {
      return cb_widget_c0_0.issue<QStackedLayout_Adaptor, QWidget *>(&QStackedLayout_Adaptor::cbs_widget_c0_0);
    } else {
      return QStackedLayout::widget();
    }
  }

  //  [emitter impl] void QStackedLayout::widgetRemoved(int index)
  void emitter_QStackedLayout_widgetRemoved_767(int index)
  {
    emit QStackedLayout::widgetRemoved(index);
  }

  //  [adaptor impl] void QStackedLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QStackedLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStackedLayout_Adaptor, QChildEvent *>(&QStackedLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QStackedLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QStackedLayout::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QStackedLayout::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStackedLayout_Adaptor, QEvent *>(&QStackedLayout_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QStackedLayout::customEvent(event);
    }
  }

  //  [adaptor impl] void QStackedLayout::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QStackedLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QStackedLayout_Adaptor, const QMetaMethod &>(&QStackedLayout_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QStackedLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStackedLayout::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QStackedLayout::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStackedLayout_Adaptor, QTimerEvent *>(&QStackedLayout_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QStackedLayout::timerEvent(event);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_controlTypes_c0_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c2010_0;
  gsi::Callback cb_indexOf_c2435_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_replaceWidget_5361_1;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_setSpacing_767_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_spacing_c0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStackedLayout_Adaptor::~QStackedLayout_Adaptor() { }

//  Constructor QStackedLayout::QStackedLayout() (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QStackedLayout_Adaptor> ();
}

static void _call_ctor_QStackedLayout_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor ());
}


//  Constructor QStackedLayout::QStackedLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QStackedLayout_Adaptor> ();
}

static void _call_ctor_QStackedLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor (arg1));
}


//  Constructor QStackedLayout::QStackedLayout(QLayout *parentLayout) (adaptor class)

static void _init_ctor_QStackedLayout_Adaptor_1341 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parentLayout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return_new<QStackedLayout_Adaptor> ();
}

static void _call_ctor_QStackedLayout_Adaptor_1341 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<QStackedLayout_Adaptor *> (new QStackedLayout_Adaptor (arg1));
}


// exposed void QStackedLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_addChildLayout_1341 (arg1);
}


// exposed void QStackedLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_addChildWidget_1315 (arg1);
}


// void QStackedLayout::addItem(QLayoutItem *item)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = args.read<QLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}


// exposed bool QStackedLayout::adoptLayout(QLayout *layout)

static void _init_fp_adoptLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_adoptLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_adoptLayout_1341 (arg1));
}


// exposed QRect QStackedLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_alignmentRect_c1792 (arg1));
}


// void QStackedLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QFlags<QSizePolicy::ControlType> QStackedLayout::controlTypes()

static void _init_cbs_controlTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QSizePolicy::ControlType> > ();
}

static void _call_cbs_controlTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QSizePolicy::ControlType> > ((QFlags<QSizePolicy::ControlType>)((QStackedLayout_Adaptor *)cls)->cbs_controlTypes_c0_0 ());
}

static void _set_callback_cbs_controlTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_controlTypes_c0_0 = cb;
}


// int QStackedLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// emitter void QStackedLayout::currentChanged(int index)

static void _init_emitter_currentChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStackedLayout_Adaptor *)cls)->emitter_QStackedLayout_currentChanged_767 (arg1);
}


// void QStackedLayout::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QStackedLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QStackedLayout_Adaptor *)cls)->emitter_QStackedLayout_destroyed_1302 (arg1);
}


// void QStackedLayout::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QStackedLayout::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QStackedLayout::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QFlags<Qt::Orientation> QStackedLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QStackedLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}


// QRect QStackedLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QStackedLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}


// bool QStackedLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QStackedLayout::heightForWidth(int width)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// int QStackedLayout::indexOf(const QWidget *)

static void _init_cbs_indexOf_c2010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c2010_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_indexOf_c2010_0 (arg1));
}

static void _set_callback_cbs_indexOf_c2010_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_indexOf_c2010_0 = cb;
}


// int QStackedLayout::indexOf(const QLayoutItem *)

static void _init_cbs_indexOf_c2435_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QLayoutItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c2435_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLayoutItem *arg1 = args.read<const QLayoutItem * > (heap);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_indexOf_c2435_0 (arg1));
}

static void _set_callback_cbs_indexOf_c2435_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_indexOf_c2435_0 = cb;
}


// void QStackedLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// bool QStackedLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}


// exposed bool QStackedLayout::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_isSignalConnected_c2394 (arg1));
}


// QLayoutItem *QStackedLayout::itemAt(int)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// QLayout *QStackedLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLayout * > ((QLayout *)((QStackedLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}


// QSize QStackedLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}


// int QStackedLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}


// QSize QStackedLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}


// emitter void QStackedLayout::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QStackedLayout_Adaptor *)cls)->emitter_QStackedLayout_objectNameChanged_4567 (arg1);
}


// exposed int QStackedLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_receivers_c1731 (arg1));
}


// QLayoutItem *QStackedLayout::replaceWidget(QWidget *from, QWidget *to, QFlags<Qt::FindChildOption> options)

static void _init_cbs_replaceWidget_5361_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options");
  decl->add_arg<QFlags<Qt::FindChildOption> > (argspec_2);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_replaceWidget_5361_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  QWidget *arg2 = args.read<QWidget * > (heap);
  QFlags<Qt::FindChildOption> arg3 = args.read<QFlags<Qt::FindChildOption> > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout_Adaptor *)cls)->cbs_replaceWidget_5361_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_replaceWidget_5361_1 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_replaceWidget_5361_1 = cb;
}


// exposed QObject *QStackedLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_sender_c0 ());
}


// exposed int QStackedLayout::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_senderSignalIndex_c0 ());
}


// void QStackedLayout::setGeometry(const QRect &rect)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}


// void QStackedLayout::setSpacing(int)

static void _init_cbs_setSpacing_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSpacing_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_setSpacing_767_0 (arg1);
}

static void _set_callback_cbs_setSpacing_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_setSpacing_767_0 = cb;
}


// QSize QStackedLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QStackedLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// QSpacerItem *QStackedLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSpacerItem * > ((QSpacerItem *)((QStackedLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}


// int QStackedLayout::spacing()

static void _init_cbs_spacing_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_spacing_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStackedLayout_Adaptor *)cls)->cbs_spacing_c0_0 ());
}

static void _set_callback_cbs_spacing_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_spacing_c0_0 = cb;
}


// QLayoutItem *QStackedLayout::takeAt(int)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QStackedLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}


// void QStackedLayout::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QWidget *QStackedLayout::widget()

static void _init_cbs_widget_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QStackedLayout_Adaptor *)cls)->cbs_widget_c0_0 ());
}

static void _set_callback_cbs_widget_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStackedLayout_Adaptor *)cls)->cb_widget_c0_0 = cb;
}


// exposed void QStackedLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStackedLayout_Adaptor *)cls)->fp_QStackedLayout_widgetEvent_1217 (arg1);
}


// emitter void QStackedLayout::widgetRemoved(int index)

static void _init_emitter_widgetRemoved_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_widgetRemoved_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QStackedLayout_Adaptor *)cls)->emitter_QStackedLayout_widgetRemoved_767 (arg1);
}


namespace gsi
{

gsi::Class<QStackedLayout> &qtdecl_QStackedLayout ();

static gsi::Methods methods_QStackedLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout()\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_0, &_call_ctor_QStackedLayout_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout(QWidget *parent)\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_1315, &_call_ctor_QStackedLayout_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStackedLayout::QStackedLayout(QLayout *parentLayout)\nThis method creates an object of class QStackedLayout.", &_init_ctor_QStackedLayout_Adaptor_1341, &_call_ctor_QStackedLayout_Adaptor_1341);
  methods += new qt_gsi::GenericMethod ("*addChildLayout", "@brief Method void QStackedLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
  methods += new qt_gsi::GenericMethod ("*addChildWidget", "@brief Method void QStackedLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QStackedLayout::addItem(QLayoutItem *item)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("*adoptLayout", "@brief Method bool QStackedLayout::adoptLayout(QLayout *layout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adoptLayout_1341, &_call_fp_adoptLayout_1341);
  methods += new qt_gsi::GenericMethod ("*alignmentRect", "@brief Method QRect QStackedLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStackedLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@brief Virtual method QFlags<QSizePolicy::ControlType> QStackedLayout::controlTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@hide", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0, &_set_callback_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QStackedLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentChanged", "@brief Emitter for signal void QStackedLayout::currentChanged(int index)\nCall this method to emit this signal.", false, &_init_emitter_currentChanged_767, &_call_emitter_currentChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStackedLayout::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QStackedLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStackedLayout::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStackedLayout::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStackedLayout::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QStackedLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QStackedLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QStackedLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QStackedLayout::heightForWidth(int width)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QStackedLayout::indexOf(const QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c2010_0, &_call_cbs_indexOf_c2010_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c2010_0, &_call_cbs_indexOf_c2010_0, &_set_callback_cbs_indexOf_c2010_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QStackedLayout::indexOf(const QLayoutItem *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c2435_0, &_call_cbs_indexOf_c2435_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c2435_0, &_call_cbs_indexOf_c2435_0, &_set_callback_cbs_indexOf_c2435_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QStackedLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QStackedLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QStackedLayout::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QStackedLayout::itemAt(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QStackedLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QStackedLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QStackedLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QStackedLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QStackedLayout::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QStackedLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("replaceWidget", "@brief Virtual method QLayoutItem *QStackedLayout::replaceWidget(QWidget *from, QWidget *to, QFlags<Qt::FindChildOption> options)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_replaceWidget_5361_1, &_call_cbs_replaceWidget_5361_1);
  methods += new qt_gsi::GenericMethod ("replaceWidget", "@hide", false, &_init_cbs_replaceWidget_5361_1, &_call_cbs_replaceWidget_5361_1, &_set_callback_cbs_replaceWidget_5361_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QStackedLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QStackedLayout::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QStackedLayout::setGeometry(const QRect &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("setSpacing", "@brief Virtual method void QStackedLayout::setSpacing(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSpacing_767_0, &_call_cbs_setSpacing_767_0);
  methods += new qt_gsi::GenericMethod ("setSpacing", "@hide", false, &_init_cbs_setSpacing_767_0, &_call_cbs_setSpacing_767_0, &_set_callback_cbs_setSpacing_767_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QStackedLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QStackedLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("spacing", "@brief Virtual method int QStackedLayout::spacing()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_spacing_c0_0, &_call_cbs_spacing_c0_0);
  methods += new qt_gsi::GenericMethod ("spacing", "@hide", true, &_init_cbs_spacing_c0_0, &_call_cbs_spacing_c0_0, &_set_callback_cbs_spacing_c0_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QStackedLayout::takeAt(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStackedLayout::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QStackedLayout::widget()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_widget_c0_0, &_call_cbs_widget_c0_0);
  methods += new qt_gsi::GenericMethod ("widget", "@hide", true, &_init_cbs_widget_c0_0, &_call_cbs_widget_c0_0, &_set_callback_cbs_widget_c0_0);
  methods += new qt_gsi::GenericMethod ("*widgetEvent", "@brief Method void QStackedLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
  methods += new qt_gsi::GenericMethod ("emit_widgetRemoved", "@brief Emitter for signal void QStackedLayout::widgetRemoved(int index)\nCall this method to emit this signal.", false, &_init_emitter_widgetRemoved_767, &_call_emitter_widgetRemoved_767);
  return methods;
}

gsi::Class<QStackedLayout_Adaptor> decl_QStackedLayout_Adaptor (qtdecl_QStackedLayout (), "QtWidgets", "QStackedLayout",
  methods_QStackedLayout_Adaptor (),
  "@qt\n@brief Binding of QStackedLayout");

}


//  Implementation of the enum wrapper class for QStackedLayout::StackingMode
namespace qt_gsi
{

static gsi::Enum<QStackedLayout::StackingMode> decl_QStackedLayout_StackingMode_Enum ("QtWidgets", "QStackedLayout_StackingMode",
    gsi::enum_const ("StackOne", QStackedLayout::StackOne, "@brief Enum constant QStackedLayout::StackOne") +
    gsi::enum_const ("StackAll", QStackedLayout::StackAll, "@brief Enum constant QStackedLayout::StackAll"),
  "@qt\n@brief This class represents the QStackedLayout::StackingMode enum");

static gsi::QFlagsClass<QStackedLayout::StackingMode > decl_QStackedLayout_StackingMode_Enums ("QtWidgets", "QStackedLayout_QFlags_StackingMode",
  "@qt\n@brief This class represents the QFlags<QStackedLayout::StackingMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStackedLayout> inject_QStackedLayout_StackingMode_Enum_in_parent (decl_QStackedLayout_StackingMode_Enum.defs ());
static gsi::ClassExt<QStackedLayout> decl_QStackedLayout_StackingMode_Enum_as_child (decl_QStackedLayout_StackingMode_Enum, "StackingMode");
static gsi::ClassExt<QStackedLayout> decl_QStackedLayout_StackingMode_Enums_as_child (decl_QStackedLayout_StackingMode_Enums, "QFlags_StackingMode");

}

