#! /usr/bin/env python3

# Copyright 2015 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup

requires = [
    'python-dateutil',
    'python-debian',
    ]
test_requires = [
    'fixtures',
    'testtools',
    ]

setup(
    name='git-build-recipe',
    version='0.1',
    packages=['gitbuildrecipe', 'gitbuildrecipe.tests'],
    entry_points={
        'console_scripts': ['git-build-recipe = gitbuildrecipe.main:main'],
        },
    zip_safe=False,
    maintainer='Colin Watson',
    maintainer_email='cjwatson@ubuntu.com',
    description='git-build-recipe',
    license='GPL v3',
    url='https://launchpad.net/git-build-recipe',
    download_url='https://launchpad.net/git-build-recipe/+download',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3',
        'Operating System :: OS Independent',
        'Programming Language :: Python 3',
        ],
    install_requires=requires,
    tests_require=test_requires,
    extras_require={"test": test_requires},
    test_suite='gitbuildrecipe.tests',
    )
