/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.pe;

import com.kreative.pe.PEResourceData;
import com.kreative.pe.PEResourceEntry;
import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

public class PEResourceDirectory
extends PEResourceEntry {
    private static final long serialVersionUID = 1L;
    public int characteristics;
    public int timeStamp;
    public int resourceVersion;
    public List<PEResourceEntry> entries = new ArrayList<PEResourceEntry>();

    public PEResourceDirectory() {
        this.characteristics = 0;
        this.timeStamp = 0;
        this.resourceVersion = 0;
    }

    public PEResourceDirectory(int id, int chars, int time, int vers) {
        super(id);
        this.characteristics = chars;
        this.timeStamp = time;
        this.resourceVersion = vers;
    }

    public PEResourceDirectory(String name, int chars, int time, int vers) {
        super(name);
        this.characteristics = chars;
        this.timeStamp = time;
        this.resourceVersion = vers;
    }

    public PEResourceDirectory(int id, String name, int chars, int time, int vers) {
        super(id, name);
        this.characteristics = chars;
        this.timeStamp = time;
        this.resourceVersion = vers;
    }

    @Override
    public PEResourceDirectory clone() {
        PEResourceDirectory rd = new PEResourceDirectory(this.id, this.name, this.characteristics, this.timeStamp, this.resourceVersion);
        for (PEResourceEntry re : this.entries) {
            rd.entries.add(re.clone());
        }
        return rd;
    }

    private static int alignPart(int a) {
        int m = a % 16;
        if (m == 0) {
            return a;
        }
        return a - m + 16;
    }

    private static int alignResource(int a) {
        int m = a % 8;
        if (m == 0) {
            return a;
        }
        return a - m + 8;
    }

    static void subtractVA(byte[] arr, int l, int va) {
        short namedEntries = PEResourceDirectory.getShort(arr, l + 12);
        short numbdEntries = PEResourceDirectory.getShort(arr, l + 14);
        int i = 0;
        int ll = l + 16;
        while (i < namedEntries + numbdEntries) {
            int of = PEResourceDirectory.getInt(arr, ll + 4);
            if (of < 0) {
                PEResourceDirectory.subtractVA(arr, of & Integer.MAX_VALUE, va);
            } else {
                PEResourceDirectory.putInt(arr, of, PEResourceDirectory.getInt(arr, of) - va);
            }
            ++i;
            ll += 8;
        }
    }

    static void addVA(byte[] arr, int l, int va) {
        short namedEntries = PEResourceDirectory.getShort(arr, l + 12);
        short numbdEntries = PEResourceDirectory.getShort(arr, l + 14);
        int i = 0;
        int ll = l + 16;
        while (i < namedEntries + numbdEntries) {
            int of = PEResourceDirectory.getInt(arr, ll + 4);
            if (of < 0) {
                PEResourceDirectory.addVA(arr, of & Integer.MAX_VALUE, va);
            } else {
                PEResourceDirectory.putInt(arr, of, PEResourceDirectory.getInt(arr, of) + va);
            }
            ++i;
            ll += 8;
        }
    }

    public void decompile(byte[] arr, int l) {
        this.characteristics = PEResourceDirectory.getInt(arr, l + 0);
        this.timeStamp = PEResourceDirectory.getInt(arr, l + 4);
        this.resourceVersion = (PEResourceDirectory.getShort(arr, l + 8) & 0xFFFF) << 16 | PEResourceDirectory.getShort(arr, l + 10) & 0xFFFF;
        short namedEntries = PEResourceDirectory.getShort(arr, l + 12);
        short numbdEntries = PEResourceDirectory.getShort(arr, l + 14);
        this.entries.clear();
        int i = 0;
        int ll = l + 16;
        while (i < namedEntries + numbdEntries) {
            int id = PEResourceDirectory.getInt(arr, ll + 0);
            int of = PEResourceDirectory.getInt(arr, ll + 4);
            PEResourceEntry e = of < 0 ? new PEResourceDirectory() : new PEResourceData();
            e.id = id;
            if (id < 0) {
                int nl = (PEResourceDirectory.getShort(arr, id & Integer.MAX_VALUE) & 0xFFFF) << 1;
                try {
                    e.name = new String(arr, (id & Integer.MAX_VALUE) + 2, nl, "UTF-16LE");
                }
                catch (UnsupportedEncodingException ee) {
                    e.name = new String(arr, (id & Integer.MAX_VALUE) + 2, nl);
                }
            } else {
                e.name = null;
            }
            if (of < 0) {
                ((PEResourceDirectory)e).decompile(arr, of & Integer.MAX_VALUE);
            } else {
                PEResourceData de = (PEResourceData)e;
                int dof = PEResourceDirectory.getInt(arr, of + 0);
                int lof = PEResourceDirectory.getInt(arr, of + 4);
                de.data = PEResourceDirectory.copy(arr, dof, lof);
                de.codePage = PEResourceDirectory.getInt(arr, of + 8);
                de.reserved = PEResourceDirectory.getInt(arr, of + 12);
            }
            this.entries.add(e);
            ++i;
            ll += 8;
        }
    }

    private int calculateResDirLength() {
        int l = 16 + 8 * this.entries.size();
        for (PEResourceEntry e : this.entries) {
            if (!(e instanceof PEResourceDirectory)) continue;
            l += ((PEResourceDirectory)e).calculateResDirLength();
        }
        return l;
    }

    private int calculateResDataLength() {
        int l = 0;
        for (PEResourceEntry e : this.entries) {
            if (e instanceof PEResourceDirectory) {
                l += ((PEResourceDirectory)e).calculateResDataLength();
                continue;
            }
            if (!(e instanceof PEResourceData)) continue;
            l += 16;
        }
        return l;
    }

    private int calculateStringLength() {
        int l = 0;
        for (PEResourceEntry e : this.entries) {
            if (e.name != null) {
                l += PEResourceDirectory.alignResource(e.name.length() * 2 + 2);
            }
            if (!(e instanceof PEResourceDirectory)) continue;
            l += ((PEResourceDirectory)e).calculateStringLength();
        }
        return l;
    }

    private int calculateDataLength() {
        int l = 0;
        for (PEResourceEntry e : this.entries) {
            if (e instanceof PEResourceDirectory) {
                l += ((PEResourceDirectory)e).calculateDataLength();
                continue;
            }
            if (!(e instanceof PEResourceData)) continue;
            l += PEResourceDirectory.alignResource(((PEResourceData)e).data.length);
        }
        return l;
    }

    public int calculateTotalLength() {
        return PEResourceDirectory.alignPart(this.calculateResDirLength() + this.calculateResDataLength()) + PEResourceDirectory.alignPart(this.calculateStringLength()) + PEResourceDirectory.alignPart(this.calculateDataLength());
    }

    public void recompile(byte[] arr, int l) {
        int dl = this.calculateResDirLength();
        int ddl = this.calculateResDataLength();
        int sl = this.calculateStringLength();
        int[] loc = new int[]{l, l + dl, l + PEResourceDirectory.alignPart(dl + ddl), l + PEResourceDirectory.alignPart(dl + ddl) + PEResourceDirectory.alignPart(sl)};
        this.recompile(arr, loc);
    }

    private void recompile(byte[] arr, int[] l) {
        int d;
        int s;
        PEResourceData ed;
        char ch;
        StringCharacterIterator ci;
        ArrayList<PEResourceEntry> namedEntries = new ArrayList<PEResourceEntry>();
        ArrayList<PEResourceEntry> numbdEntries = new ArrayList<PEResourceEntry>();
        for (PEResourceEntry en : this.entries) {
            if (en.name != null) {
                namedEntries.add(en);
                continue;
            }
            numbdEntries.add(en);
        }
        PEResourceDirectory.putInt(arr, l[0] + 0, this.characteristics);
        PEResourceDirectory.putInt(arr, l[0] + 4, this.timeStamp);
        PEResourceDirectory.putShort(arr, l[0] + 8, (short)(this.resourceVersion >>> 16 & 0xFFFF));
        PEResourceDirectory.putShort(arr, l[0] + 10, (short)(this.resourceVersion & 0xFFFF));
        PEResourceDirectory.putShort(arr, l[0] + 12, (short)namedEntries.size());
        PEResourceDirectory.putShort(arr, l[0] + 14, (short)numbdEntries.size());
        int es = l[0] + 16;
        l[0] = l[0] + (16 + 8 * this.entries.size());
        for (PEResourceEntry en : namedEntries) {
            if (en.name != null) {
                PEResourceDirectory.putInt(arr, es + 0, l[2] | Integer.MIN_VALUE);
                PEResourceDirectory.putShort(arr, l[2], (short)en.name.length());
                l[2] = l[2] + 2;
                ci = new StringCharacterIterator(en.name);
                ch = ci.first();
                while (ch != '\uffff') {
                    PEResourceDirectory.putShort(arr, l[2], (short)ch);
                    l[2] = l[2] + 2;
                    ch = ci.next();
                }
                l[2] = PEResourceDirectory.alignResource(l[2]);
            } else {
                PEResourceDirectory.putInt(arr, es + 0, en.id);
            }
            if (en instanceof PEResourceDirectory) {
                PEResourceDirectory.putInt(arr, es + 4, l[0] | Integer.MIN_VALUE);
                ((PEResourceDirectory)en).recompile(arr, l);
            } else {
                ed = (PEResourceData)en;
                PEResourceDirectory.putInt(arr, es + 4, l[1]);
                PEResourceDirectory.putInt(arr, l[1] + 0, l[3]);
                PEResourceDirectory.putInt(arr, l[1] + 4, ed.data.length);
                PEResourceDirectory.putInt(arr, l[1] + 8, ed.codePage);
                PEResourceDirectory.putInt(arr, l[1] + 12, ed.reserved);
                s = 0;
                d = l[3];
                while (s < ed.data.length && d < arr.length) {
                    arr[d] = ed.data[s];
                    ++s;
                    ++d;
                }
                l[1] = l[1] + 16;
                l[3] = l[3] + PEResourceDirectory.alignResource(ed.data.length);
            }
            es += 8;
        }
        for (PEResourceEntry en : numbdEntries) {
            if (en.name != null) {
                PEResourceDirectory.putInt(arr, es + 0, l[2] | Integer.MIN_VALUE);
                PEResourceDirectory.putShort(arr, l[2], (short)en.name.length());
                l[2] = l[2] + 2;
                ci = new StringCharacterIterator(en.name);
                ch = ci.first();
                while (ch != '\uffff') {
                    PEResourceDirectory.putShort(arr, l[2], (short)ch);
                    ch = ci.next();
                    l[2] = l[2] + 2;
                }
                l[2] = PEResourceDirectory.alignResource(l[2]);
            } else {
                PEResourceDirectory.putInt(arr, es + 0, en.id);
            }
            if (en instanceof PEResourceDirectory) {
                PEResourceDirectory.putInt(arr, es + 4, l[0] | Integer.MIN_VALUE);
                ((PEResourceDirectory)en).recompile(arr, l);
            } else {
                ed = (PEResourceData)en;
                PEResourceDirectory.putInt(arr, es + 4, l[1]);
                PEResourceDirectory.putInt(arr, l[1] + 0, l[3]);
                PEResourceDirectory.putInt(arr, l[1] + 4, ed.data.length);
                PEResourceDirectory.putInt(arr, l[1] + 8, ed.codePage);
                PEResourceDirectory.putInt(arr, l[1] + 12, ed.reserved);
                s = 0;
                d = l[3];
                while (s < ed.data.length && d < arr.length) {
                    arr[d] = ed.data[s];
                    ++s;
                    ++d;
                }
                l[1] = l[1] + 16;
                l[3] = l[3] + PEResourceDirectory.alignResource(ed.data.length);
            }
            es += 8;
        }
    }

    private static short getShort(byte[] b, int i) {
        return (short)((b[i + 1] & 0xFF) << 8 | b[i] & 0xFF);
    }

    private static int getInt(byte[] b, int i) {
        return (b[i + 3] & 0xFF) << 24 | (b[i + 2] & 0xFF) << 16 | (b[i + 1] & 0xFF) << 8 | b[i] & 0xFF;
    }

    private static void putShort(byte[] b, int i, short s) {
        b[i + 1] = (byte)(s >> 8 & 0xFF);
        b[i] = (byte)(s & 0xFF);
    }

    private static void putInt(byte[] b, int i, int s) {
        b[i + 3] = (byte)(s >> 24 & 0xFF);
        b[i + 2] = (byte)(s >> 16 & 0xFF);
        b[i + 1] = (byte)(s >> 8 & 0xFF);
        b[i] = (byte)(s & 0xFF);
    }

    private static byte[] copy(byte[] arr, int offset, int bytesToCopy) {
        byte[] stuff = new byte[bytesToCopy];
        int s = offset;
        int d = 0;
        while (d < bytesToCopy && s < arr.length) {
            stuff[d] = arr[s];
            ++s;
            ++d;
        }
        return stuff;
    }
}

