#ifndef _trans_h
#define _trans_h

#include "typedefs.h"
#include "sbllog.h"
#define cutch(NR) strncpy(str,s+NR,2); str[2]=0;

int bintrans (char *s);
range valxy (char *s);
int iniread (char *realname);
char *vecsearch (char *serchstring);
unsigned char str2mask (const char *);
unsigned char str2val (const char *);

char varvec[200][150];
char scriptvec[200][150];
range valxy (char *s)
{
  char str[20];
  unsigned int i,first=0,token=0;
  range limit={0,0,0,0};

for(i=0;i<=strlen(s);i++)
{

if(s[i]==',' || s[i]=='-' || s[i]==0)
{

token++;
memset(str,0,sizeof(str));
strncpy(str,s+first,i-first);
first=i+1;

switch(token)
{
case 1:
limit.x1=atoi(str);
break;
case 2:
limit.y1=atoi(str);
break;
case 3:
limit.x2=atoi(str);
break;
case 4:
limit.y2=atoi(str);
break;
} // switch
} // if

} // for

  return limit;
}

int iniread (char *realname)
{
  FILE *pname;
  int scr_offset = 0;
  int i = 0;
  char row[100]="";

  pname = fopen (realname, "r");
  if (pname == NULL)
    return 0;
  while (!feof (pname))
   {
     fgets (row, 80, pname);
     if (!strncmp (row, "[script]", 8))
      {
	scr_offset = i;
	strcpy (row, "#  ");
      }

     if (row[0] != '#' && strlen (row) > 5)
      {
	if (scr_offset)
	 {
	   strcpy (scriptvec[i - scr_offset], row);
	 }
	else
	  strcpy (varvec[i], row);
	i++;
      }
     if (feof (pname))
       break;
   }
  fclose (pname);
  varvec[i][0] = 0;
  return 1;
}

char *vecsearch (char *searchstring)
{
  int i = 0, end = 0;

  strcat (searchstring, "=\0");
  do
   {
     if (strncmp (varvec[i], searchstring, strlen (searchstring)) == 0)
      {
	strcpy (searchstring, varvec[i] + strlen (searchstring));
	end = 1;
      }
     i++;
   }
  while (varvec[i][0] != 0 && !end);

  if(!end)
  {
  searchstring[0]=0;
  return searchstring;
  }
  
  if (strlen (searchstring))
    searchstring[strlen (searchstring) - 1] = 0;
  return searchstring;
}

char *script_search (char *names, char *keys, int start)
{
  unsigned int i = 0;

  if (strlen (scriptvec[start]) < 5)
   {
     names[0] = 0;
     keys[0] = 0;
     return keys;
   }

  for (i = 0; i < strlen (scriptvec[start])
       && scriptvec[start][i] != '='; i++);

  if (scriptvec[start][i] == '=')
   {
     strcpy (keys, scriptvec[start] + i + 1);
     scriptvec[start][i] = 0;
     strcpy (names, scriptvec[start]);
   }
  else
   {
     names[0] = 0;
     keys[0] = 0;
   }

  sbl_log ("ret: %s %s", names, keys);
  return keys;

}				/* script_search */
unsigned char str2mask (const char *str)
{
  unsigned char m = 0xff;
  unsigned char bit = 0x80;
  int i;

  for (i = 0; str[i] != 0; ++i, bit >>= 1)
   {
     if (str[i] == '*')
       m ^= bit;
   }
  return m;
}

unsigned char str2val (const char *str)
{
  unsigned char v = 0;
  unsigned char bit = 0x80;
  int i;

  for (i = 0; str[i] != 0; ++i, bit >>= 1)
   {
     if (str[i] == '1')
       v |= bit;
   }
  return v;
}

int bintrans (char *s)
{

  int code = 0, i;
  int tbl[8] = { 128, 64, 32, 16, 8, 4, 2, 1 };

  for (i = 0; i < 8; i++)
    if (s[i] == '1')
      code += tbl[i];

  return (code);
}

#endif
