#include <stdio.h>
#include <string.h>
#include <stdlib.h>		/* qsort() */

typedef struct
{
  int p;			/* position in spkstr */
  int w;			/* tostr[w], will be inserted at position p */
}
idx2;

/*----------------------- */

int cmpidx (const void *a, const void *b)	/* used by qsort() */
{
  int va = (*(idx2 *) a).p, vb = (*(idx2 *) b).p;

  if (va > vb)
    return 1;
  if (va < vb)
    return -1;
  return 0;
}

/*----------------------- */

#define  MM  (200)		/* max number of replacements */
static idx2 rwidx[MM];

void pridx2 (int n)	/* for debug */
{
  int k;

  for (k = 0; k < n; ++k)
   {
   }
}

/*----------------------- */

char *spkfilter (char strfrom[1000][80], char strto[1000][80], int cnt,
		 char *spkstr)
/* return a string where each occurence in spkstr of
   strfrom[i] is replace by strto[i]  where i=0...cnt-1
*/
{
  int k;
  int rcnt = 0;			/* count replaces */

#define  NN  (64*1024)		/* max length of output string */
  static char outstr[NN + 1];

  memset (outstr, 0, sizeof (outstr));

  for (k = 0; k < cnt; ++k)
   {
     char *from = strfrom[k];
     int flen = strlen (from);
     char *t;

     if (flen < 1)
       continue;		/* zero length string to replace (yuck!) */

     for (t = spkstr;;)
      {
	t = strstr (t, from);
	if (t == 0)
	  break;		/* from not found */
	rwidx[rcnt].p = (int) (t - spkstr);
	rwidx[rcnt].w = k;
	t += flen;
	++rcnt;
      }

   }

  pridx2 (rcnt);

/*    void qsort(void *base, size_t nmemb, size_t size,*/
/*              int (*compar)(const void *, const void *));*/
  qsort (rwidx, rcnt, 2 * sizeof (int), cmpidx);

  pridx2 (rcnt);

  {
    int ki, ko, r;

    for (ki = 0, ko = 0, r = 0;;)
     {
       int h = rwidx[r].p - ki;

       if (h < 0)
	{
	  r++;
	  h = 0;
	}
       else
	{
	  strncpy (outstr + ko, spkstr + ki, h);	/* copy up to next replace */
	  ki += h;
	  ko += h;

	  if (r < rcnt)
	   {

	     {
	       char *w = strto[rwidx[r].w];
	       int wlen = strlen (w);

	       strncpy (outstr + ko, w, wlen);

	       ko += wlen;
	       ki += strlen (strfrom[rwidx[r].w]);
	     }
	     ++r;
	   }

	}			/* if */

       if (r >= rcnt)
	{
	  break;
	}

     }
    if (spkstr[ki])
     {
       strcpy (outstr + ko, spkstr + ki);	/* copy rest */
     }
  }

  return outstr;
}

/*----------------------- */

/*----------------------- */
