/*
 * brass - Braille and speech server
 *
 * Copyright (C) 2001-2003 by Roger Butenuth, All rights reserved.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * $Id: speech_test.c,v 1.17 2003/05/29 16:59:02 butenuth Exp $
 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include "language.h"

#define ENGLISH_TEST 0
#define GERMAN_TEST  1

static char *lookup_string(void *context, const char *name);

/*
 * Handles for active languages.
 */
#if GERMAN_TEST
lang_t *lang_ger;
#endif

#if ENGLISH_TEST
lang_t *lang_eng;
#endif

static void number_test(char *number_string);

int main(int argc, char *argv[])
{
    int i, value;
/*    int i1;*/

#if GERMAN_TEST
    lang_ger = language_open("german", lookup_string);
    assert(lang_ger != NULL);

#if 1
    printf("parameters for german language (L_MAX = %d):\n", L_MAX);
    for (i = 0; i < L_MAX; i++) {
	lang_ger->get_param(lang_ger, i, &value);
	printf("param[%d] = %d\n", i, value);
    }
    lang_ger->synth->set_param(lang_ger->synth, S_SPEED, 2000);
    lang_ger->synth->set_param(lang_ger->synth, S_PITCH, 1000);
    lang_ger->synth->set_param(lang_ger->synth, S_VOLUME, 1000);
#endif

    printf("Hallo, wie geht es?\n");
    lang_ger->speak_string(lang_ger, "Hallo, wie geht es?\n");
    number_test("0123");
    number_test("123");
    number_test("123,45");
    number_test("12.456,0815");
    number_test("123456789012");
    number_test("123456789012,3");
    number_test(",34");
    number_test("4,x");
    number_test("20.23.2000");
    number_test("19");
    number_test("20");
    number_test("21");
    number_test("30");
    number_test("999");
    number_test("1000");
    number_test("1001");
    number_test("11111");
    number_test("20.00");
    printf("sleep a second\n");
    sleep(1);

#endif
#if 0
    /*
     * Speak some german text.
     */
    printf("german text:\n");
    lang_ger->speak_string(lang_ger,
			   "Fischers Fritz fischt frische Fische.\n");
    i1 = lang_ger->synth->index_set(lang_ger->synth);
    lang_ger->speak_string(lang_ger,
			   "Fischers Fritz fischt frische Fische.\n");
    i2 = lang_ger->synth->index_set(lang_ger->synth);
    lang_ger->synth->flush(lang_ger->synth);
    printf("wait for i1\n");
    res = lang_ger->synth->index_wait(lang_ger->synth, i1, 10000);
    printf("wait result is: %d\n", res);
#endif

#if ENGLISH_TEST
    lang_eng = english_open("english", lookup_string);
    assert(lang_eng != NULL);

    printf("parameters for english language:\n");
    for (i = 0; i < L_MAX; i++) {
	lang_eng->get_param(lang_eng, i, &value);
	printf("param[%d] = %d\n", i, value);
    }

    lang_eng->speak_string(lang_eng, "t?");
    sleep(2);
    lang_eng->speak_string(lang_eng, "?");
    sleep(2);
    lang_eng->speak_string(lang_eng,
			   "The lazy fox jumps over the tree.\n");
#if 0
    i1 = lang_eng->synth->index_set(lang_eng->synth);
    res = lang_eng->synth->index_wait(lang_eng->synth, i1, 10000);
    printf("wait result is: %d\n\n", res);
#endif
    /*
     * Now speek an english sentence.
     */
    lang_eng->speak_string(lang_eng,
			   "To be or not to be thats the question\n");
    /*
     * Give the synthesizer one second time, after that, interrupt
     * it and remove everything in the speech queue.
     */
    sleep(6);
    lang_eng->synth->clear(lang_eng->synth);
#endif

    {
        char str[100];
        printf("wait for return...\n");
        fgets(str, 100, stdin);
    }
    
    /*
     * Close both languages/synthesizers.
     */
    printf(">>> close\n");
#if GERMAN_TEST
    lang_ger->close(lang_ger);
#endif
#if ENGLISH_TEST
    lang_eng->close(lang_eng);
#endif
    printf("<<< close\n");
    return 0;
}

static void number_test(char *number_string)
{
    printf("======= %s =======\n", number_string);
    lang_ger->speak_string(lang_ger, number_string);
}

static char *lookup_string(void *context, const char *name)
{
    char *c = context;
    char *result = NULL;

    printf("lookup_string(\"%s\", \"%s\") -> ", c, name);

    if (!strcmp(c, "german")) {
        if (!strcmp(name, "language")) {
            result = "german";
        } else if (!strcmp(name, "library")) {
            result = "./stdout_synth.so";
        } else if (!strcmp(name, "phoneme_generator_directory")) {
            result = "/opt/speech/txt2pho";
        } else if (!strcmp(name, "phoneme_generator_command")) {
            result = "txt2pho -p /opt/speech/txt2pho/data/ -m";
        } else if (!strcmp(name, "synthesizer_directory")) {
            result = "/opt/speech/mbrola";
        } else if (!strcmp(name, "synthesizer_command")) {
            result = "mbrola -e de2/de2 - -";
        } else if (!strcmp(name, "samples_per_second")) {
            result = "16000";
        } else {
            result = NULL;
        }
    } else if (!strcmp(c, "english")) {
        if (!strcmp(name, "language")) {
            result = "english";
        } else if (!strcmp(name, "library")) {
            result = "./stdout_synth.so";
        } else if (!strcmp(name, "pthreads")) {
            result = "/lib/libpthread.so.0";
        } else if (!strcmp(name, "viavoice")) {
            result = "/usr/lib/libibmeci50.so";
        } else {
            result = NULL;
        }
    } else {
        result = NULL;
    }

    printf(" \"%s\"\n", result != NULL ? result : "(null)");
    return result;
}

