/*
 * brass - Braille and speech server
 *
 * Copyright (C) 2001 by Roger Butenuth, All rights reserved.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
 *
 * $Id: lang_lib.c,v 1.5 2003/02/24 20:57:04 butenuth Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include "language.h"
#include "synthesizer.h"
#include "lookup.h"

synth_t *dummy_synth_open(void);

lang_descr_t languages[LANGUAGES] = {
    { LANG_ENGLISH, "English" },
    { LANG_GERMAN, "German" },
    { LANG_DUMMY, "no language" }
};


/*
 * ----------------------------------------------------------------------
 *
 * ----------------------------------------------------------------------
 */
lang_t *language_open(void *context, lookup_string_t lookup)
{
    char *language = (*lookup)(context, "language");

//    printf("language_open, language = %s\n", language);
    if (language == NULL)
        return NULL;
    else if (!strcmp(language, "english"))
        return english_open(context, lookup);
    else if (!strcmp(language, "german"))
        return german_open(context, lookup);
    else
        return NULL;    
}


/*
 * ----------------------------------------------------------------------
 *
 * ----------------------------------------------------------------------
 */
synth_t *open_synthesizer(void *context, lookup_string_t fun)
{
    void       *handle = NULL;
    synth_t    *synth = NULL;
    const char *error;
    char       *lib_name;
    synth_t    *(*synth_open)(void *context, lookup_string_t fun);

    lib_name = (*fun)(context, "library");
    if (lib_name == NULL) {
        goto failure;
    } else {

	handle = dlopen(lib_name, RTLD_LAZY);
	if (!handle) {
	    goto failure;
	}
	synth_open = dlsym(handle, "synth_open");
	if ((error = dlerror()) != NULL)  {
	    goto failure;
	}
	synth = (*synth_open)(context, fun);
	if (synth == NULL) {
	    goto failure;
	}
    }	
    synth->lib_handle = handle;
    return synth;

 failure:
    if (handle)
	dlclose(handle);
    return NULL;
}


/*
 * ----------------------------------------------------------------------
 * Close synthesizer, close library when synthesizer is in one.
 * ----------------------------------------------------------------------
 */
int close_synthesizer(synth_t *synth)
{
    int  r = 0;
    void *handle;

    handle = synth->lib_handle;
    r = synth->close(synth);
    if (handle != NULL)
	dlclose(handle);
    
    return r;
}
