#include <stdio.h>
#include <stdarg.h>
#include "sbllog.h"

static int dbg_level = 0;
static FILE *logfile;
static int log = 0;

void sbl_open_log (int level)
{

  if (level > 0)
    dbg_level = level;
  else
    return;

  logfile = fopen (FILENAME, "w");
  log = 1;
  sbl_log ("open logfile %s\n", FILENAME);
}

void sbl_log (char *format, ...)
{
  va_list ap;

  if (!dbg_level)
    return;
  if (log)
   {
     log = 0;
     fclose (logfile);
   }
  logfile = fopen (FILENAME, "a");
  va_start (ap, format);
  vfprintf (logfile, format, ap);
  fclose (logfile);
  va_end (ap);
}

void sbl_close_log ()
{
  if (!dbg_level)
    return;
  sbl_log ("closing logfile %s\n", FILENAME);
  if (log)
    fclose (logfile);
}
