/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/
#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include "variolow.h"
#include "../sbllog.h"
#include "misc.h"

	/*      The filedescriptor of the open port, sorry to say, wee need a global
	 *      one here */

unsigned char st_disp[4];
static int devfd = -1;

int varioinit (char *dev)
{
  struct termios tiodata;

  /*      Idiot check one */
  if (!dev)
   {
     return -1;
   }
  devfd = open (dev, O_RDWR | O_NOCTTY);
  /*      If we got it open, get the old attributed of the port */
  if (devfd == -1 || tcgetattr (devfd, &tiodata))
   {
     sbl_log ("Port open failed: %s: %s", dev, strerror (0));
     if (devfd > 0)
      {
	close (devfd);
      }
     return -1;
   }
  tiodata.c_cflag = (CLOCAL | PARODD | PARENB | CREAD | CS8);
  tiodata.c_iflag = IGNPAR;
  tiodata.c_oflag = 0;
  tiodata.c_lflag = 0;
  tiodata.c_cc[VMIN] = 0;
  tiodata.c_cc[VTIME] = 0;

  /*      Force down DTR, flush any pending data and then 
   *      the port to what we want it to be */
  if (cfsetispeed (&tiodata, B0) ||
      cfsetospeed (&tiodata, B0) ||
      tcsetattr (devfd, TCSANOW, &tiodata) ||
      tcflush (devfd, TCIOFLUSH) ||
      cfsetispeed (&tiodata, B19200) ||
      cfsetospeed (&tiodata, B19200) || tcsetattr (devfd, TCSANOW, &tiodata))
   {
     sbl_log ("Port init failed: %s: %s", dev, strerror (0));
     return -1;
   }
  /*      Pause to let them take effect */
  usleep (500);
  /* resetbrl */
/*  write(devfd,0xff,1); */
  varioreset ();

  usleep (1000);
  {
    char id1, id2;

    read (devfd, &id1, 1);
    read (devfd, &id2, 1);
    sbl_log ("id is %d %d\n", id1, id2);
  }

  return devfd;
}

int varioclose ()
{
  /*      Flush all pending output and then close the port */
  if (devfd > 0)
   {
     tcflush (devfd, TCIOFLUSH);
     close (devfd);
     return 0;
   }
  return -1;
}

int varioreset ()
{
  char c = VARIO_RESET;

  if (devfd <= 0)
   {
     return -1;
   }
  return write (devfd, &c, sizeof (c)) != 1;
}

int variodisplay (char *buff)
{

  if (!buff)
   {
     return -1;
   }
  /*      Write header and then data ... */
  write (devfd, VARIO_DISPLAY_DATA, VARIO_DISPLAY_DATA_LEN);
  write (devfd, st_disp, BRL_ST_CELLS);
  write (devfd, buff, BRLCOLS);

  return 0;
}

int variocheckwaiting ()
{
  fd_set checkset;
  struct timeval tval;

  tval.tv_sec = 0;
  tval.tv_usec = 0;

  FD_ZERO (&checkset);
  FD_SET (devfd, &checkset);
  return !select (devfd + 1, &checkset, NULL, NULL, &tval);
}

int varioget ()
{
  unsigned char data = 0;

  /*      And read a tiny little byte */

  if (read (devfd, &data, 1) == 1)
   {
     return data;
   }
  else
   {
     return -1;
   }
}

int variotranslate (unsigned char *frombuff, char *tobuff, int count)
{
  if (!frombuff | !tobuff)
   {
     return -1;
   }
  /*      Just apply the nify macro for all chars */
  for (; count >= 0; count--)
   {
     tobuff[count - 1] = CHAR_TO_VARIO_CHAR (frombuff[count - 1]);
   }

  return 0;
}
