#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include "libbrld.h"

static int brld_connected = 0;
static int event_mode = 0;
static int brld_cmd (char *cmd, char *result);
static int sockID = -1;

brld_interface brld = {
  brld_open, brld_reg, brld_close, brld_getkey, brld_write, brld_reset,
  brld_getname, brld_getalias, brld_getxy, brld_cursor, brld_attrtbl,
  brld_texttbl, brld_seteventmode, brld_unseteventmode
};

int brld_open (char *host, int port)
{
  struct hostent *hp, *gethostbyname ();
  struct sockaddr_in sad;	  /*--sckt struct for addresses----*/

  memset ((char *) &sad, 0, sizeof (sad));	/*--zero out bits--*/
  sad.sin_family = AF_INET;			/*--TCP family-----*/
  if (strlen (host))
    hp = gethostbyname (host);
  else
    hp = gethostbyname ("localhost");
  memcpy (&sad.sin_addr, hp->h_addr, hp->h_length);
  sad.sin_port = htons (port);

  if ((sockID = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    return -1;

  if (connect (sockID, (struct sockaddr *) &sad, sizeof (sad)) < 0)
    return -2;

  brld_connected = 1;
  return sockID;
}

int brld_reg (int type, char *authkey)
{
  char cmdstr[MAX_MSG_LEN] = "";
  char str[MAX_MSG_LEN] = "";

  memset (str, 0, sizeof (str));
  sprintf (cmdstr, "reg %02d %s", type, authkey);
  if (brld_cmd (cmdstr, str))
    return 1;
  if (strcmp (str, "OK\r\n"))
    return 2;

  return 0;

}

void brld_close ()
{

  send (sockID, "quit", 5, 0);
  usleep (1000);
  close (sockID);
  sockID = -1;
  brld_connected = 0;
}

static int brld_cmd (char *cmd, char *result)
{
  int cnt = 0, timeout = 0;
  char tmpstr[MAX_MSG_LEN];

  if (!brld_connected)
    return 1;

  memset (tmpstr, 0, sizeof (tmpstr));
  send (sockID, cmd, strlen (cmd) + 1, 0);
/* give the server time to response */
  usleep (100);
  while (timeout < 1000)
   {
     timeout++;
     cnt = recv (sockID, tmpstr, 50, MSG_DONTWAIT);
     if (cnt > 0)
      {
	timeout = 0;
	tmpstr[cnt] = 0;
	strcpy (result, tmpstr);

	if (!strncmp (result, "error", 5))
	  return 2;
	else
	  return 0;
      }
     usleep (10);
   }

  return 3;			/* timeout */

}

int brld_reset ()
{
  char str[MAX_MSG_LEN] = "";

  if (brld_cmd ("reset", str))
    return 1;
  if (strcmp (str, "OK\r\n"))
    return 2;

  return 0;
}

int brld_getkey (int *pressed)
{

  char str[MAX_MSG_LEN] = "";

  if (!event_mode)
   {
     if (brld_cmd ("getkey", str))
       return -1;

     if (strlen (str) < 8)
       return -2;
   }
  else
   {
     usleep (200);
     recv (sockID, str, 10, MSG_DONTWAIT);
   }

  *pressed = atoi (str + 4);
  str[3] = 0;
  return atoi (str);
}

int brld_getxy (int *x, int *y)
{

  char str[MAX_MSG_LEN];

  *x = 0;
  *y = 0;

  if (brld_cmd ("getxy", str))
    return 1;

  if (strlen (str) < 7)
    return 2;

  *y = atoi (str + 3);
  str[3] = 0;
  *x = atoi (str);
  return 0;
}

int brld_getname (char *name)
{

  char str[MAX_MSG_LEN] = "";

  if (brld_cmd ("getname", str))
    return 1;

  if (strlen (str) > 1)
   {
     str[strlen (str) - 2] = 0;
     strcpy (name, str);
     return 0;
   }

  return 2;

}

int brld_getalias (char *alias)
{

  char str[MAX_MSG_LEN] = "";

  if (brld_cmd ("getalias", str))
    return 1;

  if (strlen (str) > 1)
   {
     str[strlen (str) - 2] = 0;
     strcpy (alias, str);
     return 0;
   }

  return 2;

}

int brld_write (int csrpos, char *text, char *attr)
{
  char cmd[MAX_MSG_LEN] = "";
  unsigned int attrlen = 0;

  if (attr)
   {
     attrlen = strlen (attr);
     if (attrlen != strlen (text))
       attrlen = 0;
   }

  sprintf (cmd, "write %03d %03d %02d %s%s", csrpos, strlen (text),
	   attrlen ? 1 : 0, text, attrlen ? attr : "");
  send (sockID, cmd, strlen (cmd) + 1, 0);
  usleep (100);
  return 0;
}

int brld_cursor (int form)
{
  char str[MAX_MSG_LEN];
  char cmd_str[MAX_MSG_LEN];

  memset (str, 0, sizeof (str));
  memset (cmd_str, 0, sizeof (cmd_str));
  sprintf (cmd_str, "cursor %02d", form);

  if (brld_cmd (cmd_str, str))
    return 1;
  if (strcmp (str, "OK\r\n"))
    return 2;

  return 0;
}

int brld_attrtbl ()
{
  char str[MAX_MSG_LEN];

  memset (str, 0, sizeof (str));

  if (brld_cmd ("attrtbl", str))
    return 1;

  if (strcmp (str, "OK\r\n"))
    return 2;

  return 0;
}

int brld_texttbl ()
{
  char str[MAX_MSG_LEN];

  memset (str, 0, sizeof (str));

  if (brld_cmd ("texttbl", str))
    return 1;

  if (strcmp (str, "OK\r\n"))
    return 2;

  return 0;
}

void brld_seteventmode ()
{
  send (sockID, "seteventmode\r\n", 14, 0);
  event_mode = 1;
}

int brld_unseteventmode ()
{

  char str[10] = "";

  if (brld_cmd ("unsetevenmode", str))
    return 1;

  event_mode = 0;
  return 0;
}
